/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.server;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.protobuf.BlockingService;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import javax.management.ObjectName;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.HddsUtils;
import org.apache.hadoop.hdds.annotation.InterfaceAudience;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.PlacementPolicy;
import org.apache.hadoop.hdds.scm.ScmConfig;
import org.apache.hadoop.hdds.scm.block.BlockManager;
import org.apache.hadoop.hdds.scm.block.BlockManagerImpl;
import org.apache.hadoop.hdds.scm.block.DeletedBlockLogImpl;
import org.apache.hadoop.hdds.scm.block.PendingDeleteHandler;
import org.apache.hadoop.hdds.scm.command.CommandStatusReportHandler;
import org.apache.hadoop.hdds.scm.container.CloseContainerEventHandler;
import org.apache.hadoop.hdds.scm.container.ContainerActionsHandler;
import org.apache.hadoop.hdds.scm.container.ContainerID;
import org.apache.hadoop.hdds.scm.container.ContainerInfo;
import org.apache.hadoop.hdds.scm.container.ContainerManager;
import org.apache.hadoop.hdds.scm.container.ContainerReportHandler;
import org.apache.hadoop.hdds.scm.container.IncrementalContainerReportHandler;
import org.apache.hadoop.hdds.scm.container.ReplicationManager;
import org.apache.hadoop.hdds.scm.container.SCMContainerManager;
import org.apache.hadoop.hdds.scm.container.placement.algorithms.ContainerPlacementPolicyFactory;
import org.apache.hadoop.hdds.scm.container.placement.algorithms.SCMContainerPlacementMetrics;
import org.apache.hadoop.hdds.scm.container.placement.metrics.ContainerStat;
import org.apache.hadoop.hdds.scm.container.placement.metrics.SCMMetrics;
import org.apache.hadoop.hdds.scm.events.SCMEvents;
import org.apache.hadoop.hdds.scm.exceptions.SCMException;
import org.apache.hadoop.hdds.scm.metadata.SCMMetadataStore;
import org.apache.hadoop.hdds.scm.metadata.SCMMetadataStoreRDBImpl;
import org.apache.hadoop.hdds.scm.net.NetworkTopology;
import org.apache.hadoop.hdds.scm.net.NetworkTopologyImpl;
import org.apache.hadoop.hdds.scm.node.DeadNodeHandler;
import org.apache.hadoop.hdds.scm.node.NewNodeHandler;
import org.apache.hadoop.hdds.scm.node.NodeManager;
import org.apache.hadoop.hdds.scm.node.NodeReportHandler;
import org.apache.hadoop.hdds.scm.node.NonHealthyToHealthyNodeHandler;
import org.apache.hadoop.hdds.scm.node.SCMNodeManager;
import org.apache.hadoop.hdds.scm.node.StaleNodeHandler;
import org.apache.hadoop.hdds.scm.pipeline.PipelineActionHandler;
import org.apache.hadoop.hdds.scm.pipeline.PipelineManager;
import org.apache.hadoop.hdds.scm.pipeline.PipelineReportHandler;
import org.apache.hadoop.hdds.scm.pipeline.SCMPipelineManager;
import org.apache.hadoop.hdds.scm.safemode.SCMSafeModeManager;
import org.apache.hadoop.hdds.scm.safemode.SafeModeHandler;
import org.apache.hadoop.hdds.scm.server.OzoneStorageContainerManager;
import org.apache.hadoop.hdds.scm.server.SCMBlockProtocolServer;
import org.apache.hadoop.hdds.scm.server.SCMCertStore;
import org.apache.hadoop.hdds.scm.server.SCMClientProtocolServer;
import org.apache.hadoop.hdds.scm.server.SCMConfigurator;
import org.apache.hadoop.hdds.scm.server.SCMContainerMetrics;
import org.apache.hadoop.hdds.scm.server.SCMDatanodeProtocolServer;
import org.apache.hadoop.hdds.scm.server.SCMMXBean;
import org.apache.hadoop.hdds.scm.server.SCMSecurityProtocolServer;
import org.apache.hadoop.hdds.scm.server.SCMStorageConfig;
import org.apache.hadoop.hdds.scm.server.StorageContainerManagerHttpServer;
import org.apache.hadoop.hdds.security.exception.SCMSecurityException;
import org.apache.hadoop.hdds.security.x509.SecurityConfig;
import org.apache.hadoop.hdds.security.x509.certificate.authority.CertificateServer;
import org.apache.hadoop.hdds.security.x509.certificate.authority.CertificateStore;
import org.apache.hadoop.hdds.security.x509.certificate.authority.DefaultCAServer;
import org.apache.hadoop.hdds.security.x509.certificate.utils.CertificateCodec;
import org.apache.hadoop.hdds.server.ServiceRuntimeInfoImpl;
import org.apache.hadoop.hdds.server.events.Event;
import org.apache.hadoop.hdds.server.events.EventHandler;
import org.apache.hadoop.hdds.server.events.EventPublisher;
import org.apache.hadoop.hdds.server.events.EventQueue;
import org.apache.hadoop.hdds.utils.HddsServerUtil;
import org.apache.hadoop.hdds.utils.HddsVersionInfo;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.util.MBeans;
import org.apache.hadoop.ozone.OzoneSecurityUtil;
import org.apache.hadoop.ozone.common.Storage;
import org.apache.hadoop.ozone.lease.LeaseManager;
import org.apache.hadoop.ozone.lock.LockManager;
import org.apache.hadoop.ozone.protocol.commands.CommandForDatanode;
import org.apache.hadoop.ozone.protocol.commands.RetriableDatanodeEventWatcher;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authentication.client.AuthenticationException;
import org.apache.hadoop.util.JvmPauseMonitor;
import org.apache.ratis.grpc.GrpcTlsConfig;
import org.bouncycastle.cert.X509CertificateHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.LimitedPrivate(value={"HDFS", "CBLOCK", "OZONE", "HBASE"})
public final class StorageContainerManager
extends ServiceRuntimeInfoImpl
implements SCMMXBean,
OzoneStorageContainerManager {
    private static final Logger LOG = LoggerFactory.getLogger(StorageContainerManager.class);
    private static SCMMetrics metrics;
    private final SCMDatanodeProtocolServer datanodeProtocolServer;
    private final SCMBlockProtocolServer blockProtocolServer;
    private final SCMClientProtocolServer clientProtocolServer;
    private SCMSecurityProtocolServer securityProtocolServer;
    private NodeManager scmNodeManager;
    private PipelineManager pipelineManager;
    private ContainerManager containerManager;
    private BlockManager scmBlockManager;
    private final SCMStorageConfig scmStorageConfig;
    private SCMMetadataStore scmMetadataStore;
    private final EventQueue eventQueue;
    private final StorageContainerManagerHttpServer httpServer;
    private final Collection<String> scmAdminUsernames;
    private ObjectName scmInfoBeanName;
    private final Cache<String, ContainerStat> containerReportCache;
    private ReplicationManager replicationManager;
    private final LeaseManager<Long> commandWatcherLeaseManager;
    private SCMSafeModeManager scmSafeModeManager;
    private CertificateServer certificateServer;
    private GrpcTlsConfig grpcTlsConfig;
    private JvmPauseMonitor jvmPauseMonitor;
    private final OzoneConfiguration configuration;
    private final SafeModeHandler safeModeHandler;
    private SCMContainerMetrics scmContainerMetrics;
    private SCMContainerPlacementMetrics placementMetrics;
    private MetricsSystem ms;
    private NetworkTopology clusterMap;

    public StorageContainerManager(OzoneConfiguration conf) throws IOException, AuthenticationException {
        this(conf, new SCMConfigurator());
    }

    public StorageContainerManager(OzoneConfiguration conf, SCMConfigurator configurator) throws IOException, AuthenticationException {
        super(HddsVersionInfo.HDDS_VERSION_INFO);
        Objects.requireNonNull(configurator, "configurator cannot not be null");
        Objects.requireNonNull(conf, "configuration cannot not be null");
        this.configuration = conf;
        StorageContainerManager.initMetrics();
        this.containerReportCache = this.buildContainerReportCache();
        this.scmStorageConfig = new SCMStorageConfig(conf);
        if (this.scmStorageConfig.getState() != Storage.StorageState.INITIALIZED) {
            LOG.error("Please make sure you have run 'ozone scm --init' command to generate all the required metadata.");
            throw new SCMException("SCM not initialized due to storage config failure.", SCMException.ResultCodes.SCM_NOT_INITIALIZED);
        }
        if (OzoneSecurityUtil.isSecurityEnabled((Configuration)conf)) {
            this.loginAsSCMUser((Configuration)conf);
        }
        this.initalizeMetadataStore(conf, configurator);
        if (OzoneSecurityUtil.isSecurityEnabled((Configuration)conf)) {
            this.initializeCAnSecurityProtocol(conf, configurator);
        } else {
            this.certificateServer = null;
            this.securityProtocolServer = null;
        }
        this.eventQueue = new EventQueue();
        long watcherTimeout = conf.getTimeDuration("hdds.scm.watcher.timeout", "10m", TimeUnit.MILLISECONDS);
        this.commandWatcherLeaseManager = new LeaseManager("CommandWatcher", watcherTimeout);
        this.initializeSystemManagers(conf, configurator);
        CloseContainerEventHandler closeContainerHandler = new CloseContainerEventHandler(this.pipelineManager, this.containerManager);
        NodeReportHandler nodeReportHandler = new NodeReportHandler(this.scmNodeManager);
        PipelineReportHandler pipelineReportHandler = new PipelineReportHandler(this.scmSafeModeManager, this.pipelineManager, (Configuration)conf);
        CommandStatusReportHandler cmdStatusReportHandler = new CommandStatusReportHandler();
        NewNodeHandler newNodeHandler = new NewNodeHandler(this.pipelineManager, (Configuration)conf);
        StaleNodeHandler staleNodeHandler = new StaleNodeHandler(this.scmNodeManager, this.pipelineManager, conf);
        DeadNodeHandler deadNodeHandler = new DeadNodeHandler(this.scmNodeManager, this.pipelineManager, this.containerManager);
        NonHealthyToHealthyNodeHandler nonHealthyToHealthyNodeHandler = new NonHealthyToHealthyNodeHandler(this.pipelineManager, conf);
        ContainerActionsHandler actionsHandler = new ContainerActionsHandler();
        PendingDeleteHandler pendingDeleteHandler = new PendingDeleteHandler(this.scmBlockManager.getSCMBlockDeletingService());
        ContainerReportHandler containerReportHandler = new ContainerReportHandler(this.scmNodeManager, this.containerManager);
        IncrementalContainerReportHandler incrementalContainerReportHandler = new IncrementalContainerReportHandler(this.scmNodeManager, this.containerManager);
        PipelineActionHandler pipelineActionHandler = new PipelineActionHandler(this.pipelineManager, conf);
        RetriableDatanodeEventWatcher<CommandStatusReportHandler.DeleteBlockStatus> retriableDatanodeEventWatcher = new RetriableDatanodeEventWatcher<CommandStatusReportHandler.DeleteBlockStatus>((Event<CommandForDatanode>)SCMEvents.RETRIABLE_DATANODE_COMMAND, (Event<CommandStatusReportHandler.DeleteBlockStatus>)SCMEvents.DELETE_BLOCK_STATUS, this.commandWatcherLeaseManager);
        retriableDatanodeEventWatcher.start(this.eventQueue);
        this.scmAdminUsernames = conf.getTrimmedStringCollection("ozone.administrators");
        String scmUsername = UserGroupInformation.getCurrentUser().getUserName();
        if (!this.scmAdminUsernames.contains(scmUsername)) {
            this.scmAdminUsernames.add(scmUsername);
        }
        this.datanodeProtocolServer = new SCMDatanodeProtocolServer(conf, this, (EventPublisher)this.eventQueue);
        this.blockProtocolServer = new SCMBlockProtocolServer(conf, this);
        this.clientProtocolServer = new SCMClientProtocolServer(conf, this);
        this.httpServer = new StorageContainerManagerHttpServer((Configuration)conf);
        this.safeModeHandler = new SafeModeHandler((Configuration)this.configuration, this.clientProtocolServer, this.scmBlockManager, this.replicationManager, this.pipelineManager);
        this.eventQueue.addHandler(SCMEvents.DATANODE_COMMAND, (EventHandler)this.scmNodeManager);
        this.eventQueue.addHandler(SCMEvents.RETRIABLE_DATANODE_COMMAND, (EventHandler)this.scmNodeManager);
        this.eventQueue.addHandler(SCMEvents.NODE_REPORT, (EventHandler)nodeReportHandler);
        this.eventQueue.addHandler(SCMEvents.CONTAINER_REPORT, (EventHandler)containerReportHandler);
        this.eventQueue.addHandler(SCMEvents.INCREMENTAL_CONTAINER_REPORT, (EventHandler)incrementalContainerReportHandler);
        this.eventQueue.addHandler(SCMEvents.CONTAINER_ACTIONS, (EventHandler)actionsHandler);
        this.eventQueue.addHandler(SCMEvents.CLOSE_CONTAINER, (EventHandler)closeContainerHandler);
        this.eventQueue.addHandler(SCMEvents.NEW_NODE, (EventHandler)newNodeHandler);
        this.eventQueue.addHandler(SCMEvents.STALE_NODE, (EventHandler)staleNodeHandler);
        this.eventQueue.addHandler(SCMEvents.NON_HEALTHY_TO_HEALTHY_NODE, (EventHandler)nonHealthyToHealthyNodeHandler);
        this.eventQueue.addHandler(SCMEvents.DEAD_NODE, (EventHandler)deadNodeHandler);
        this.eventQueue.addHandler(SCMEvents.CMD_STATUS_REPORT, (EventHandler)cmdStatusReportHandler);
        this.eventQueue.addHandler(SCMEvents.PENDING_DELETE_STATUS, (EventHandler)pendingDeleteHandler);
        this.eventQueue.addHandler(SCMEvents.DELETE_BLOCK_STATUS, (EventHandler)((DeletedBlockLogImpl)this.scmBlockManager.getDeletedBlockLog()));
        this.eventQueue.addHandler(SCMEvents.PIPELINE_ACTIONS, (EventHandler)pipelineActionHandler);
        this.eventQueue.addHandler(SCMEvents.PIPELINE_REPORT, (EventHandler)pipelineReportHandler);
        this.eventQueue.addHandler(SCMEvents.SAFE_MODE_STATUS, (EventHandler)this.safeModeHandler);
        this.scmSafeModeManager.emitSafeModeStatus();
        this.registerMXBean();
        this.registerMetricsSource(this);
    }

    private void initializeSystemManagers(OzoneConfiguration conf, SCMConfigurator configurator) throws IOException {
        this.clusterMap = configurator.getNetworkTopology() != null ? configurator.getNetworkTopology() : new NetworkTopologyImpl((Configuration)conf);
        this.scmNodeManager = configurator.getScmNodeManager() != null ? configurator.getScmNodeManager() : new SCMNodeManager(conf, this.scmStorageConfig, (EventPublisher)this.eventQueue, this.clusterMap);
        this.placementMetrics = SCMContainerPlacementMetrics.create();
        PlacementPolicy containerPlacementPolicy = ContainerPlacementPolicyFactory.getPolicy((Configuration)conf, this.scmNodeManager, this.clusterMap, true, this.placementMetrics);
        this.pipelineManager = configurator.getPipelineManager() != null ? configurator.getPipelineManager() : new SCMPipelineManager((Configuration)conf, this.scmNodeManager, (EventPublisher)this.eventQueue);
        this.containerManager = configurator.getContainerManager() != null ? configurator.getContainerManager() : new SCMContainerManager((Configuration)conf, this.pipelineManager);
        this.scmBlockManager = configurator.getScmBlockManager() != null ? configurator.getScmBlockManager() : new BlockManagerImpl((Configuration)conf, this);
        this.replicationManager = configurator.getReplicationManager() != null ? configurator.getReplicationManager() : new ReplicationManager((ReplicationManager.ReplicationManagerConfiguration)conf.getObject(ReplicationManager.ReplicationManagerConfiguration.class), this.containerManager, containerPlacementPolicy, (EventPublisher)this.eventQueue, (LockManager<ContainerID>)new LockManager((Configuration)conf));
        this.scmSafeModeManager = configurator.getScmSafeModeManager() != null ? configurator.getScmSafeModeManager() : new SCMSafeModeManager((Configuration)conf, this.containerManager.getContainers(), this.pipelineManager, this.eventQueue);
    }

    private void initializeCAnSecurityProtocol(OzoneConfiguration conf, SCMConfigurator configurator) throws IOException {
        this.certificateServer = configurator.getCertificateServer() != null ? configurator.getCertificateServer() : this.initializeCertificateServer(this.getScmStorageConfig().getClusterID(), this.getScmStorageConfig().getScmId());
        this.certificateServer.init(new SecurityConfig((Configuration)conf), CertificateServer.CAType.SELF_SIGNED_CA);
        this.securityProtocolServer = new SCMSecurityProtocolServer(conf, this.certificateServer);
        this.grpcTlsConfig = StorageContainerManager.createTlsClientConfigForSCM(new SecurityConfig((Configuration)conf), this.certificateServer);
    }

    static GrpcTlsConfig createTlsClientConfigForSCM(SecurityConfig conf, CertificateServer certificateServer) throws IOException {
        if (conf.isSecurityEnabled() && conf.isGrpcTlsEnabled()) {
            try {
                X509Certificate caCert = CertificateCodec.getX509Certificate((X509CertificateHolder)certificateServer.getCACertificate());
                return new GrpcTlsConfig(null, null, caCert, false);
            }
            catch (CertificateException ex) {
                throw new SCMSecurityException("Fail to find SCM CA certificate.", (Throwable)ex);
            }
        }
        return null;
    }

    private void initalizeMetadataStore(OzoneConfiguration conf, SCMConfigurator configurator) throws IOException {
        this.scmMetadataStore = configurator.getMetadataStore() != null ? configurator.getMetadataStore() : new SCMMetadataStoreRDBImpl(conf);
    }

    private void loginAsSCMUser(Configuration conf) throws IOException, AuthenticationException {
        if (LOG.isDebugEnabled()) {
            ScmConfig scmConfig = (ScmConfig)this.configuration.getObject(ScmConfig.class);
            LOG.debug("Ozone security is enabled. Attempting login for SCM user. Principal: {}, keytab: {}", (Object)scmConfig.getKerberosPrincipal(), (Object)scmConfig.getKerberosKeytab());
        }
        if (!SecurityUtil.getAuthenticationMethod((Configuration)conf).equals((Object)UserGroupInformation.AuthenticationMethod.KERBEROS)) {
            throw new AuthenticationException(SecurityUtil.getAuthenticationMethod((Configuration)conf) + " authentication method not support. SCM user login failed.");
        }
        UserGroupInformation.setConfiguration((Configuration)conf);
        InetSocketAddress socAddr = HddsServerUtil.getScmBlockClientBindAddress((Configuration)conf);
        SecurityUtil.login((Configuration)conf, (String)"hdds.scm.kerberos.keytab.file", (String)"hdds.scm.kerberos.principal", (String)socAddr.getHostName());
        LOG.info("SCM login successful.");
    }

    private CertificateServer initializeCertificateServer(String clusterID, String scmID) throws IOException {
        String subject = "scm@" + InetAddress.getLocalHost().getHostName();
        if (this.scmMetadataStore == null) {
            LOG.error("Cannot initialize Certificate Server without a valid meta data layer.");
            throw new SCMException("Cannot initialize CA without a valid metadata store", SCMException.ResultCodes.SCM_NOT_INITIALIZED);
        }
        SCMCertStore certStore = new SCMCertStore(this.scmMetadataStore);
        return new DefaultCAServer(subject, clusterID, scmID, (CertificateStore)certStore);
    }

    public static String buildRpcServerStartMessage(String description, InetSocketAddress addr) {
        return addr != null ? String.format("%s is listening at %s", description, addr.toString()) : String.format("%s not started", description);
    }

    public static RPC.Server startRpcServer(OzoneConfiguration conf, InetSocketAddress addr, Class<?> protocol, BlockingService instance, int handlerCount) throws IOException {
        RPC.Server rpcServer = new RPC.Builder((Configuration)conf).setProtocol(protocol).setInstance((Object)instance).setBindAddress(addr.getHostString()).setPort(addr.getPort()).setNumHandlers(handlerCount).setVerbose(false).setSecretManager(null).build();
        DFSUtil.addPBProtocol((Configuration)conf, protocol, (BlockingService)instance, (RPC.Server)rpcServer);
        return rpcServer;
    }

    public static StorageContainerManager createSCM(OzoneConfiguration conf) throws IOException, AuthenticationException {
        return new StorageContainerManager(conf);
    }

    public static boolean scmInit(OzoneConfiguration conf, String clusterId) throws IOException {
        SCMStorageConfig scmStorageConfig = new SCMStorageConfig(conf);
        Storage.StorageState state = scmStorageConfig.getState();
        if (state != Storage.StorageState.INITIALIZED) {
            try {
                if (clusterId != null && !clusterId.isEmpty()) {
                    scmStorageConfig.setClusterId(clusterId);
                }
                scmStorageConfig.initialize();
                LOG.info("SCM initialization succeeded. Current cluster id for sd={};cid={}", (Object)scmStorageConfig.getStorageDir(), (Object)scmStorageConfig.getClusterID());
                return true;
            }
            catch (IOException ioe) {
                LOG.error("Could not initialize SCM version file", (Throwable)ioe);
                return false;
            }
        }
        LOG.info("SCM already initialized. Reusing existing cluster id for sd={};cid={}", (Object)scmStorageConfig.getStorageDir(), (Object)scmStorageConfig.getClusterID());
        return true;
    }

    public static void initMetrics() {
        metrics = SCMMetrics.create();
    }

    public static SCMMetrics getMetrics() {
        return metrics == null ? SCMMetrics.create() : metrics;
    }

    public SCMStorageConfig getScmStorageConfig() {
        return this.scmStorageConfig;
    }

    public SCMDatanodeProtocolServer getDatanodeProtocolServer() {
        return this.datanodeProtocolServer;
    }

    public SCMBlockProtocolServer getBlockProtocolServer() {
        return this.blockProtocolServer;
    }

    public SCMClientProtocolServer getClientProtocolServer() {
        return this.clientProtocolServer;
    }

    public SCMSecurityProtocolServer getSecurityProtocolServer() {
        return this.securityProtocolServer;
    }

    private Cache<String, ContainerStat> buildContainerReportCache() {
        return CacheBuilder.newBuilder().expireAfterAccess(Long.MAX_VALUE, TimeUnit.MILLISECONDS).maximumSize(Integer.MAX_VALUE).removalListener(removalNotification -> {
            Cache<String, ContainerStat> cache = this.containerReportCache;
            synchronized (cache) {
                ContainerStat stat = (ContainerStat)removalNotification.getValue();
                if (stat != null) {
                    metrics.decrContainerStat(stat);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Remove expired container stat entry for datanode: {}.", removalNotification.getKey());
                }
            }
        }).build();
    }

    private void registerMXBean() {
        HashMap<String, String> jmxProperties = new HashMap<String, String>();
        jmxProperties.put("component", "ServerRuntime");
        this.scmInfoBeanName = HddsUtils.registerWithJmxProperties((String)"StorageContainerManager", (String)"StorageContainerManagerInfo", jmxProperties, (Object)this);
    }

    private void registerMetricsSource(SCMMXBean scmMBean) {
        this.scmContainerMetrics = SCMContainerMetrics.create(scmMBean);
    }

    private void unregisterMXBean() {
        if (this.scmInfoBeanName != null) {
            MBeans.unregister((ObjectName)this.scmInfoBeanName);
            this.scmInfoBeanName = null;
        }
    }

    @VisibleForTesting
    public ContainerInfo getContainerInfo(long containerID) throws IOException {
        return this.containerManager.getContainer(ContainerID.valueof((long)containerID));
    }

    @VisibleForTesting
    public InetSocketAddress getClientRpcAddress() {
        return this.getClientProtocolServer().getClientRpcAddress();
    }

    @Override
    public String getClientRpcPort() {
        InetSocketAddress addr = this.getClientRpcAddress();
        return addr == null ? "0" : Integer.toString(addr.getPort());
    }

    public InetSocketAddress getDatanodeRpcAddress() {
        return this.getDatanodeProtocolServer().getDatanodeRpcAddress();
    }

    @Override
    public String getDatanodeRpcPort() {
        InetSocketAddress addr = this.getDatanodeRpcAddress();
        return addr == null ? "0" : Integer.toString(addr.getPort());
    }

    @Override
    public void start() throws IOException {
        if (LOG.isInfoEnabled()) {
            LOG.info(StorageContainerManager.buildRpcServerStartMessage("StorageContainerLocationProtocol RPC server", this.getClientRpcAddress()));
        }
        this.ms = HddsServerUtil.initializeMetrics((OzoneConfiguration)this.configuration, (String)"StorageContainerManager");
        this.commandWatcherLeaseManager.start();
        this.getClientProtocolServer().start();
        if (LOG.isInfoEnabled()) {
            LOG.info(StorageContainerManager.buildRpcServerStartMessage("ScmBlockLocationProtocol RPC server", this.getBlockProtocolServer().getBlockRpcAddress()));
        }
        this.getBlockProtocolServer().start();
        if (LOG.isInfoEnabled()) {
            LOG.info(StorageContainerManager.buildRpcServerStartMessage("ScmDatanodeProtocl RPC server", this.getDatanodeProtocolServer().getDatanodeRpcAddress()));
        }
        this.getDatanodeProtocolServer().start();
        if (this.getSecurityProtocolServer() != null) {
            this.getSecurityProtocolServer().start();
        }
        this.httpServer.start();
        this.scmBlockManager.start();
        this.jvmPauseMonitor = new JvmPauseMonitor();
        this.jvmPauseMonitor.init((Configuration)this.configuration);
        this.jvmPauseMonitor.start();
        this.setStartTime();
    }

    @Override
    public void stop() {
        try {
            LOG.info("Stopping Replication Manager Service.");
            this.replicationManager.stop();
        }
        catch (Exception ex) {
            LOG.error("Replication manager service stop failed.", (Throwable)ex);
        }
        try {
            LOG.info("Stopping Lease Manager of the command watchers");
            this.commandWatcherLeaseManager.shutdown();
        }
        catch (Exception ex) {
            LOG.error("Lease Manager of the command watchers stop failed");
        }
        try {
            LOG.info("Stopping datanode service RPC server");
            this.getDatanodeProtocolServer().stop();
        }
        catch (Exception ex) {
            LOG.error("Storage Container Manager datanode RPC stop failed.", (Throwable)ex);
        }
        try {
            LOG.info("Stopping block service RPC server");
            this.getBlockProtocolServer().stop();
        }
        catch (Exception ex) {
            LOG.error("Storage Container Manager blockRpcServer stop failed.", (Throwable)ex);
        }
        try {
            LOG.info("Stopping the StorageContainerLocationProtocol RPC server");
            this.getClientProtocolServer().stop();
        }
        catch (Exception ex) {
            LOG.error("Storage Container Manager clientRpcServer stop failed.", (Throwable)ex);
        }
        try {
            LOG.info("Stopping Storage Container Manager HTTP server.");
            this.httpServer.stop();
        }
        catch (Exception ex) {
            LOG.error("Storage Container Manager HTTP server stop failed.", (Throwable)ex);
        }
        if (this.getSecurityProtocolServer() != null) {
            this.getSecurityProtocolServer().stop();
        }
        try {
            LOG.info("Stopping Block Manager Service.");
            this.scmBlockManager.stop();
        }
        catch (Exception ex) {
            LOG.error("SCM block manager service stop failed.", (Throwable)ex);
        }
        if (this.containerReportCache != null) {
            this.containerReportCache.invalidateAll();
            this.containerReportCache.cleanUp();
        }
        if (metrics != null) {
            metrics.unRegister();
        }
        this.unregisterMXBean();
        if (this.scmContainerMetrics != null) {
            this.scmContainerMetrics.unRegister();
        }
        if (this.placementMetrics != null) {
            this.placementMetrics.unRegister();
        }
        try {
            LOG.info("Stopping SCM Event Queue.");
            this.eventQueue.close();
        }
        catch (Exception ex) {
            LOG.error("SCM Event Queue stop failed", (Throwable)ex);
        }
        if (this.jvmPauseMonitor != null) {
            this.jvmPauseMonitor.stop();
        }
        IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{this.containerManager});
        IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{this.pipelineManager});
        try {
            this.scmMetadataStore.stop();
        }
        catch (Exception ex) {
            LOG.error("SCM Metadata store stop failed", (Throwable)ex);
        }
        if (this.ms != null) {
            this.ms.stop();
        }
        this.scmSafeModeManager.stop();
    }

    @Override
    public void join() {
        try {
            this.getBlockProtocolServer().join();
            this.getClientProtocolServer().join();
            this.getDatanodeProtocolServer().join();
            if (this.getSecurityProtocolServer() != null) {
                this.getSecurityProtocolServer().join();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LOG.info("Interrupted during StorageContainerManager join.");
        }
    }

    public int getNodeCount(HddsProtos.NodeState nodestate) {
        return this.scmNodeManager.getNodeCount(nodestate);
    }

    @Override
    @VisibleForTesting
    public ContainerManager getContainerManager() {
        return this.containerManager;
    }

    @Override
    @VisibleForTesting
    public NodeManager getScmNodeManager() {
        return this.scmNodeManager;
    }

    @Override
    @VisibleForTesting
    public PipelineManager getPipelineManager() {
        return this.pipelineManager;
    }

    @Override
    @VisibleForTesting
    public BlockManager getScmBlockManager() {
        return this.scmBlockManager;
    }

    @VisibleForTesting
    public SafeModeHandler getSafeModeHandler() {
        return this.safeModeHandler;
    }

    @VisibleForTesting
    public SCMSafeModeManager getScmSafeModeManager() {
        return this.scmSafeModeManager;
    }

    @Override
    @VisibleForTesting
    public ReplicationManager getReplicationManager() {
        return this.replicationManager;
    }

    public void checkAdminAccess(String remoteUser) throws IOException {
        if (remoteUser != null && !this.scmAdminUsernames.contains(remoteUser)) {
            throw new IOException("Access denied for user " + remoteUser + ". Superuser privilege is required.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeContainerReport(String datanodeUuid) {
        Cache<String, ContainerStat> cache = this.containerReportCache;
        synchronized (cache) {
            this.containerReportCache.invalidate((Object)datanodeUuid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContainerStat getContainerReport(String datanodeUuid) {
        ContainerStat stat = null;
        Cache<String, ContainerStat> cache = this.containerReportCache;
        synchronized (cache) {
            stat = (ContainerStat)this.containerReportCache.getIfPresent((Object)datanodeUuid);
        }
        return stat;
    }

    public ConcurrentMap<String, ContainerStat> getContainerReportCache() {
        return this.containerReportCache.asMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String> getContainerReport() {
        HashMap<String, String> id2StatMap = new HashMap<String, String>();
        Cache<String, ContainerStat> cache = this.containerReportCache;
        synchronized (cache) {
            ConcurrentMap map = this.containerReportCache.asMap();
            for (Map.Entry entry : map.entrySet()) {
                id2StatMap.put((String)entry.getKey(), ((ContainerStat)entry.getValue()).toJsonString());
            }
        }
        return id2StatMap;
    }

    @Override
    public double getSafeModeCurrentContainerThreshold() {
        return this.getCurrentContainerThreshold();
    }

    @Override
    public boolean isInSafeMode() {
        return this.scmSafeModeManager.getInSafeMode();
    }

    public EventPublisher getEventQueue() {
        return this.eventQueue;
    }

    public boolean exitSafeMode() {
        this.scmSafeModeManager.exitSafeMode((EventPublisher)this.eventQueue);
        return true;
    }

    @VisibleForTesting
    public double getCurrentContainerThreshold() {
        return this.scmSafeModeManager.getCurrentContainerThreshold();
    }

    @Override
    public Map<String, Integer> getContainerStateCount() {
        HashMap<String, Integer> nodeStateCount = new HashMap<String, Integer>();
        for (HddsProtos.LifeCycleState state : HddsProtos.LifeCycleState.values()) {
            nodeStateCount.put(state.toString(), this.containerManager.getContainerCountByState(state));
        }
        return nodeStateCount;
    }

    public SCMMetadataStore getScmMetadataStore() {
        return this.scmMetadataStore;
    }

    public NetworkTopology getClusterMap() {
        return this.clusterMap;
    }
}

