/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.block;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.hdds.scm.block.DatanodeDeletedBlockTransactions;
import org.apache.hadoop.hdds.scm.block.DeletedBlockLog;
import org.apache.hadoop.hdds.scm.command.CommandStatusReportHandler;
import org.apache.hadoop.hdds.scm.container.ContainerID;
import org.apache.hadoop.hdds.scm.container.ContainerInfo;
import org.apache.hadoop.hdds.scm.container.ContainerManager;
import org.apache.hadoop.hdds.scm.container.ContainerReplica;
import org.apache.hadoop.hdds.scm.metadata.SCMMetadataStore;
import org.apache.hadoop.hdds.server.events.EventHandler;
import org.apache.hadoop.hdds.server.events.EventPublisher;
import org.apache.hadoop.hdds.utils.db.BatchOperation;
import org.apache.hadoop.hdds.utils.db.Table;
import org.apache.hadoop.hdds.utils.db.TableIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeletedBlockLogImpl
implements DeletedBlockLog,
EventHandler<CommandStatusReportHandler.DeleteBlockStatus> {
    public static final Logger LOG = LoggerFactory.getLogger(DeletedBlockLogImpl.class);
    private final int maxRetry;
    private final ContainerManager containerManager;
    private final SCMMetadataStore scmMetadataStore;
    private final Lock lock;
    private Map<Long, Set<UUID>> transactionToDNsCommitMap;

    public DeletedBlockLogImpl(ConfigurationSource conf, ContainerManager containerManager, SCMMetadataStore scmMetadataStore) {
        this.maxRetry = conf.getInt("ozone.scm.block.deletion.max.retry", 4096);
        this.containerManager = containerManager;
        this.scmMetadataStore = scmMetadataStore;
        this.lock = new ReentrantLock();
        this.transactionToDNsCommitMap = new ConcurrentHashMap<Long, Set<UUID>>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<StorageContainerDatanodeProtocolProtos.DeletedBlocksTransaction> getFailedTransactions() throws IOException {
        this.lock.lock();
        try {
            ArrayList failedTXs = Lists.newArrayList();
            try (TableIterator iter = this.scmMetadataStore.getDeletedBlocksTXTable().iterator();){
                while (iter.hasNext()) {
                    StorageContainerDatanodeProtocolProtos.DeletedBlocksTransaction delTX = (StorageContainerDatanodeProtocolProtos.DeletedBlocksTransaction)((Table.KeyValue)iter.next()).getValue();
                    if (delTX.getCount() != -1) continue;
                    failedTXs.add(delTX);
                }
            }
            ArrayList arrayList = failedTXs;
            return arrayList;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void incrementCount(List<Long> txIDs) throws IOException {
        for (Long txID : txIDs) {
            this.lock.lock();
            try {
                StorageContainerDatanodeProtocolProtos.DeletedBlocksTransaction block = (StorageContainerDatanodeProtocolProtos.DeletedBlocksTransaction)this.scmMetadataStore.getDeletedBlocksTXTable().get((Object)txID);
                if (block == null) {
                    LOG.warn("Deleted TXID {} not found.", (Object)txID);
                    continue;
                }
                StorageContainerDatanodeProtocolProtos.DeletedBlocksTransaction.Builder builder = block.toBuilder();
                int currentCount = block.getCount();
                if (currentCount > -1) {
                    builder.setCount(++currentCount);
                }
                if (currentCount > this.maxRetry) {
                    builder.setCount(-1);
                }
                this.scmMetadataStore.getDeletedBlocksTXTable().put((Object)txID, (Object)builder.build());
            }
            catch (IOException ex) {
                LOG.warn("Cannot increase count for txID " + txID, (Throwable)ex);
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    private StorageContainerDatanodeProtocolProtos.DeletedBlocksTransaction constructNewTransaction(long txID, long containerID, List<Long> blocks) {
        return StorageContainerDatanodeProtocolProtos.DeletedBlocksTransaction.newBuilder().setTxID(txID).setContainerID(containerID).addAllLocalID(blocks).setCount(0).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commitTransactions(List<StorageContainerDatanodeProtocolProtos.ContainerBlocksDeletionACKProto.DeleteBlockTransactionResult> transactionResults, UUID dnID) {
        this.lock.lock();
        try {
            for (StorageContainerDatanodeProtocolProtos.ContainerBlocksDeletionACKProto.DeleteBlockTransactionResult transactionResult : transactionResults) {
                ContainerID containerId;
                Set<UUID> dnsWithCommittedTxn;
                long txID;
                block9: {
                    if (this.isTransactionFailed(transactionResult)) continue;
                    txID = transactionResult.getTxID();
                    dnsWithCommittedTxn = this.transactionToDNsCommitMap.get(txID);
                    containerId = ContainerID.valueof((long)transactionResult.getContainerID());
                    if (dnsWithCommittedTxn != null) break block9;
                    LOG.warn("Transaction txId={} commit by dnId={} for containerID={} failed. Corresponding entry not found.", new Object[]{txID, dnID, containerId});
                    return;
                }
                try {
                    List containerDns;
                    dnsWithCommittedTxn.add(dnID);
                    ContainerInfo container = this.containerManager.getContainer(containerId);
                    Set<ContainerReplica> replicas = this.containerManager.getContainerReplicas(containerId);
                    if (Math.min(replicas.size(), dnsWithCommittedTxn.size()) >= container.getReplicationFactor().getNumber() && dnsWithCommittedTxn.containsAll(containerDns = replicas.stream().map(ContainerReplica::getDatanodeDetails).map(DatanodeDetails::getUuid).collect(Collectors.toList()))) {
                        this.transactionToDNsCommitMap.remove(txID);
                        LOG.debug("Purging txId={} from block deletion log", (Object)txID);
                        this.scmMetadataStore.getDeletedBlocksTXTable().delete((Object)txID);
                    }
                    LOG.debug("Datanode txId={} containerId={} committed by dnId={}", new Object[]{txID, containerId, dnID});
                }
                catch (IOException e) {
                    LOG.warn("Could not commit delete block transaction: " + transactionResult.getTxID(), (Throwable)e);
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private boolean isTransactionFailed(StorageContainerDatanodeProtocolProtos.ContainerBlocksDeletionACKProto.DeleteBlockTransactionResult result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Got block deletion ACK from datanode, TXIDs={}, success={}", (Object)result.getTxID(), (Object)result.getSuccess());
        }
        if (!result.getSuccess()) {
            LOG.warn("Got failed ACK for TXID={}, prepare to resend the TX in next interval", (Object)result.getTxID());
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addTransaction(long containerID, List<Long> blocks) throws IOException {
        this.lock.lock();
        try {
            Long nextTXID = this.scmMetadataStore.getNextDeleteBlockTXID();
            StorageContainerDatanodeProtocolProtos.DeletedBlocksTransaction tx = this.constructNewTransaction(nextTXID, containerID, blocks);
            this.scmMetadataStore.getDeletedBlocksTXTable().put((Object)nextTXID, (Object)tx);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getNumOfValidTransactions() throws IOException {
        this.lock.lock();
        try {
            AtomicInteger num = new AtomicInteger(0);
            try (TableIterator iter = this.scmMetadataStore.getDeletedBlocksTXTable().iterator();){
                while (iter.hasNext()) {
                    StorageContainerDatanodeProtocolProtos.DeletedBlocksTransaction delTX = (StorageContainerDatanodeProtocolProtos.DeletedBlocksTransaction)((Table.KeyValue)iter.next()).getValue();
                    if (delTX.getCount() <= -1) continue;
                    num.incrementAndGet();
                }
            }
            int n = num.get();
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addTransactions(Map<Long, List<Long>> containerBlocksMap) throws IOException {
        this.lock.lock();
        try {
            BatchOperation batch = this.scmMetadataStore.getStore().initBatchOperation();
            for (Map.Entry<Long, List<Long>> entry : containerBlocksMap.entrySet()) {
                long nextTXID = this.scmMetadataStore.getNextDeleteBlockTXID();
                StorageContainerDatanodeProtocolProtos.DeletedBlocksTransaction tx = this.constructNewTransaction(nextTXID, entry.getKey(), entry.getValue());
                this.scmMetadataStore.getDeletedBlocksTXTable().putWithBatch(batch, (Object)nextTXID, (Object)tx);
            }
            this.scmMetadataStore.getStore().commitBatchOperation(batch);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void close() throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<Long, Long> getTransactions(DatanodeDeletedBlockTransactions transactions) throws IOException {
        this.lock.lock();
        try {
            HashMap<Long, Long> deleteTransactionMap = new HashMap<Long, Long>();
            try (TableIterator iter = this.scmMetadataStore.getDeletedBlocksTXTable().iterator();){
                while (iter.hasNext()) {
                    Table.KeyValue keyValue = (Table.KeyValue)iter.next();
                    StorageContainerDatanodeProtocolProtos.DeletedBlocksTransaction block = (StorageContainerDatanodeProtocolProtos.DeletedBlocksTransaction)keyValue.getValue();
                    if (block.getCount() <= -1 || block.getCount() > this.maxRetry || !transactions.addTransaction(block, this.transactionToDNsCommitMap.get(block.getTxID()))) continue;
                    deleteTransactionMap.put(block.getContainerID(), block.getTxID());
                    this.transactionToDNsCommitMap.putIfAbsent(block.getTxID(), new LinkedHashSet());
                }
            }
            HashMap<Long, Long> hashMap = deleteTransactionMap;
            return hashMap;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void onMessage(CommandStatusReportHandler.DeleteBlockStatus deleteBlockStatus, EventPublisher publisher) {
        StorageContainerDatanodeProtocolProtos.ContainerBlocksDeletionACKProto ackProto = deleteBlockStatus.getCmdStatus().getBlockDeletionAck();
        this.commitTransactions(ackProto.getResultsList(), UUID.fromString(ackProto.getDnId()));
    }
}

