/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.container;

import java.io.Closeable;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.container.ContainerID;
import org.apache.hadoop.hdds.scm.container.ContainerInfo;
import org.apache.hadoop.hdds.scm.container.ContainerNotFoundException;
import org.apache.hadoop.hdds.scm.container.ContainerReplica;
import org.apache.hadoop.hdds.scm.container.ContainerReplicaNotFoundException;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;

public interface ContainerManager
extends Closeable {
    public Set<ContainerID> getContainerIDs();

    public List<ContainerInfo> getContainers();

    public List<ContainerInfo> getContainers(HddsProtos.LifeCycleState var1);

    public Integer getContainerCountByState(HddsProtos.LifeCycleState var1);

    public ContainerInfo getContainer(ContainerID var1) throws ContainerNotFoundException;

    public boolean exists(ContainerID var1);

    public List<ContainerInfo> listContainer(ContainerID var1, int var2);

    public ContainerInfo allocateContainer(HddsProtos.ReplicationType var1, HddsProtos.ReplicationFactor var2, String var3) throws IOException;

    public void deleteContainer(ContainerID var1) throws IOException;

    public HddsProtos.LifeCycleState updateContainerState(ContainerID var1, HddsProtos.LifeCycleEvent var2) throws IOException;

    public Set<ContainerReplica> getContainerReplicas(ContainerID var1) throws ContainerNotFoundException;

    public void updateContainerReplica(ContainerID var1, ContainerReplica var2) throws ContainerNotFoundException;

    public void removeContainerReplica(ContainerID var1, ContainerReplica var2) throws ContainerNotFoundException, ContainerReplicaNotFoundException;

    public void updateDeleteTransactionId(Map<Long, Long> var1) throws IOException;

    public ContainerInfo getMatchingContainer(long var1, String var3, Pipeline var4);

    public ContainerInfo getMatchingContainer(long var1, String var3, Pipeline var4, Collection<ContainerID> var5);

    public void notifyContainerReportProcessing(boolean var1, boolean var2);
}

