/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.container.placement.algorithms;

import org.apache.hadoop.hdds.scm.ContainerPlacementStatus;

public class ContainerPlacementStatusDefault
implements ContainerPlacementStatus {
    private final int requiredRacks;
    private final int currentRacks;
    private final int totalRacks;

    public ContainerPlacementStatusDefault(int currentRacks, int requiredRacks, int totalRacks) {
        this.requiredRacks = requiredRacks;
        this.currentRacks = currentRacks;
        this.totalRacks = totalRacks;
    }

    public boolean isPolicySatisfied() {
        return this.currentRacks >= this.totalRacks || this.currentRacks >= this.requiredRacks;
    }

    public String misReplicatedReason() {
        if (this.isPolicySatisfied()) {
            return null;
        }
        return "The container is mis-replicated as it is on " + this.currentRacks + " racks but should be on " + this.requiredRacks + " racks.";
    }

    public int misReplicationCount() {
        if (this.isPolicySatisfied()) {
            return 0;
        }
        return this.requiredRacks - this.currentRacks;
    }

    public int expectedPlacementCount() {
        return Math.min(this.requiredRacks, this.totalRacks);
    }

    public int actualPlacementCount() {
        return this.currentRacks;
    }
}

