/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.metadata;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.time.Instant;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.apache.hadoop.hdds.utils.db.Codec;

public class PipelineCodec
implements Codec<Pipeline> {
    public byte[] toPersistedFormat(Pipeline object) throws IOException {
        return object.getProtobufMessage().toByteArray();
    }

    public Pipeline fromPersistedFormat(byte[] rawData) throws IOException {
        HddsProtos.Pipeline.Builder pipelineBuilder = HddsProtos.Pipeline.newBuilder((HddsProtos.Pipeline)((HddsProtos.Pipeline)HddsProtos.Pipeline.PARSER.parseFrom(rawData)));
        Pipeline pipeline = Pipeline.getFromProtobuf((HddsProtos.Pipeline)pipelineBuilder.setState(HddsProtos.PipelineState.PIPELINE_ALLOCATED).build());
        pipeline.setCreationTimestamp(Instant.now());
        Preconditions.checkNotNull((Object)pipeline);
        return pipeline;
    }

    public Pipeline copyObject(Pipeline object) {
        throw new UnsupportedOperationException();
    }
}

