/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.metadata;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.UUID;
import org.apache.hadoop.hdds.scm.pipeline.PipelineID;
import org.apache.hadoop.hdds.utils.db.Codec;

public class PipelineIDCodec
implements Codec<PipelineID> {
    public byte[] toPersistedFormat(PipelineID object) throws IOException {
        byte[] bytes = new byte[16];
        System.arraycopy(this.asByteArray(object.getId().getMostSignificantBits()), 0, bytes, 0, 8);
        System.arraycopy(this.asByteArray(object.getId().getLeastSignificantBits()), 0, bytes, 8, 8);
        return bytes;
    }

    private byte[] asByteArray(long bits) {
        ByteBuffer buffer = ByteBuffer.allocate(8);
        buffer.putLong(bits);
        return buffer.array();
    }

    public PipelineID fromPersistedFormat(byte[] rawData) throws IOException {
        long mostSiginificantBits = this.toLong(rawData, 0);
        long leastSignificantBits = this.toLong(rawData, 8);
        UUID id = new UUID(mostSiginificantBits, leastSignificantBits);
        return PipelineID.valueOf((UUID)id);
    }

    private long toLong(byte[] arr, int startIdx) throws IOException {
        if (arr.length < startIdx + 8) {
            throw new IOException("Key conversion error.", new ArrayIndexOutOfBoundsException("Key does not have the least expected amount of bytes,and does not contain a UUID. Key: " + Arrays.toString(arr)));
        }
        ByteBuffer buffer = ByteBuffer.allocate(8);
        buffer.put(arr, startIdx, 8);
        buffer.flip();
        return buffer.getLong();
    }

    public PipelineID copyObject(PipelineID object) {
        throw new UnsupportedOperationException();
    }
}

