/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.metadata;

import java.io.IOException;
import java.math.BigInteger;
import java.security.cert.X509Certificate;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.hdds.scm.container.ContainerID;
import org.apache.hadoop.hdds.scm.container.ContainerInfo;
import org.apache.hadoop.hdds.scm.metadata.SCMDBDefinition;
import org.apache.hadoop.hdds.scm.metadata.SCMMetadataStore;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.apache.hadoop.hdds.scm.pipeline.PipelineID;
import org.apache.hadoop.hdds.security.x509.certificate.authority.CertificateStore;
import org.apache.hadoop.hdds.utils.db.BatchOperationHandler;
import org.apache.hadoop.hdds.utils.db.DBDefinition;
import org.apache.hadoop.hdds.utils.db.DBStore;
import org.apache.hadoop.hdds.utils.db.DBStoreBuilder;
import org.apache.hadoop.hdds.utils.db.Table;
import org.apache.hadoop.hdds.utils.db.TableIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SCMMetadataStoreImpl
implements SCMMetadataStore {
    private Table<Long, StorageContainerDatanodeProtocolProtos.DeletedBlocksTransaction> deletedBlocksTable;
    private Table<BigInteger, X509Certificate> validCertsTable;
    private Table<BigInteger, X509Certificate> revokedCertsTable;
    private Table<ContainerID, ContainerInfo> containerTable;
    private Table<PipelineID, Pipeline> pipelineTable;
    private static final Logger LOG = LoggerFactory.getLogger(SCMMetadataStoreImpl.class);
    private DBStore store;
    private final OzoneConfiguration configuration;
    private final AtomicLong txID;

    public SCMMetadataStoreImpl(OzoneConfiguration config) throws IOException {
        this.configuration = config;
        this.start(this.configuration);
        this.txID = new AtomicLong(this.getLargestRecordedTXID());
    }

    @Override
    public void start(OzoneConfiguration config) throws IOException {
        if (this.store == null) {
            this.store = DBStoreBuilder.createDBStore((ConfigurationSource)config, (DBDefinition)new SCMDBDefinition());
            this.deletedBlocksTable = SCMDBDefinition.DELETED_BLOCKS.getTable(this.store);
            this.checkTableStatus(this.deletedBlocksTable, SCMDBDefinition.DELETED_BLOCKS.getName());
            this.validCertsTable = SCMDBDefinition.VALID_CERTS.getTable(this.store);
            this.checkTableStatus(this.validCertsTable, SCMDBDefinition.VALID_CERTS.getName());
            this.revokedCertsTable = SCMDBDefinition.REVOKED_CERTS.getTable(this.store);
            this.checkTableStatus(this.revokedCertsTable, SCMDBDefinition.REVOKED_CERTS.getName());
            this.pipelineTable = SCMDBDefinition.PIPELINES.getTable(this.store);
            this.containerTable = SCMDBDefinition.CONTAINERS.getTable(this.store);
        }
    }

    @Override
    public void stop() throws Exception {
        if (this.store != null) {
            this.store.close();
            this.store = null;
        }
    }

    @Override
    public DBStore getStore() {
        return this.store;
    }

    @Override
    public Table<Long, StorageContainerDatanodeProtocolProtos.DeletedBlocksTransaction> getDeletedBlocksTXTable() {
        return this.deletedBlocksTable;
    }

    @Override
    public Long getNextDeleteBlockTXID() {
        return this.txID.incrementAndGet();
    }

    @Override
    public Table<BigInteger, X509Certificate> getValidCertsTable() {
        return this.validCertsTable;
    }

    @Override
    public Table<BigInteger, X509Certificate> getRevokedCertsTable() {
        return this.revokedCertsTable;
    }

    @Override
    public TableIterator getAllCerts(CertificateStore.CertType certType) {
        if (certType == CertificateStore.CertType.VALID_CERTS) {
            return this.validCertsTable.iterator();
        }
        if (certType == CertificateStore.CertType.REVOKED_CERTS) {
            return this.revokedCertsTable.iterator();
        }
        return null;
    }

    @Override
    public Table<PipelineID, Pipeline> getPipelineTable() {
        return this.pipelineTable;
    }

    @Override
    public BatchOperationHandler getBatchHandler() {
        return this.store;
    }

    @Override
    public Table<ContainerID, ContainerInfo> getContainerTable() {
        return this.containerTable;
    }

    @Override
    public Long getCurrentTXID() {
        return this.txID.get();
    }

    private Long getLargestRecordedTXID() throws IOException {
        try (TableIterator txIter = this.deletedBlocksTable.iterator();){
            txIter.seekToLast();
            Long txid = (Long)txIter.key();
            if (txid != null) {
                Long l = txid;
                return l;
            }
        }
        return 0L;
    }

    private void checkTableStatus(Table table, String name) throws IOException {
        String logMessage = "Unable to get a reference to %s table. Cannot continue.";
        String errMsg = "Inconsistent DB state, Table - %s. Please check the logs for more info.";
        if (table == null) {
            LOG.error(String.format(logMessage, name));
            throw new IOException(String.format(errMsg, name));
        }
    }
}

