/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.pipeline;

import java.io.IOException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.pipeline.PipelineManager;
import org.apache.hadoop.hdds.utils.Scheduler;
import org.apache.hadoop.ozone.OzoneConfigKeys;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BackgroundPipelineCreator {
    private static final Logger LOG = LoggerFactory.getLogger(BackgroundPipelineCreator.class);
    private final Scheduler scheduler;
    private final AtomicBoolean isPipelineCreatorRunning;
    private final PipelineManager pipelineManager;
    private final ConfigurationSource conf;
    private ScheduledFuture<?> periodicTask;

    BackgroundPipelineCreator(PipelineManager pipelineManager, Scheduler scheduler, ConfigurationSource conf) {
        this.pipelineManager = pipelineManager;
        this.conf = conf;
        this.scheduler = scheduler;
        this.isPipelineCreatorRunning = new AtomicBoolean(false);
    }

    private boolean shouldSchedulePipelineCreator() {
        return this.isPipelineCreatorRunning.compareAndSet(false, true);
    }

    synchronized void startFixedIntervalPipelineCreator() {
        if (this.periodicTask != null) {
            return;
        }
        long intervalInMillis = this.conf.getTimeDuration("ozone.scm.pipeline.creation.interval", "120s", TimeUnit.MILLISECONDS);
        this.periodicTask = this.scheduler.scheduleWithFixedDelay(() -> {
            if (!this.shouldSchedulePipelineCreator()) {
                return;
            }
            this.createPipelines();
        }, 0L, intervalInMillis, TimeUnit.MILLISECONDS);
    }

    void triggerPipelineCreation() {
        if (!this.shouldSchedulePipelineCreator()) {
            return;
        }
        this.scheduler.schedule(this::createPipelines, 0L, TimeUnit.MILLISECONDS);
    }

    private boolean skipCreation(HddsProtos.ReplicationFactor factor, HddsProtos.ReplicationType type, boolean autoCreate) {
        if (type == HddsProtos.ReplicationType.RATIS) {
            return factor == HddsProtos.ReplicationFactor.ONE && !autoCreate;
        }
        return factor == HddsProtos.ReplicationFactor.THREE;
    }

    private void createPipelines() {
        HddsProtos.ReplicationType type = HddsProtos.ReplicationType.valueOf((String)this.conf.get("ozone.replication.type", OzoneConfigKeys.OZONE_REPLICATION_TYPE_DEFAULT));
        boolean autoCreateFactorOne = this.conf.getBoolean("ozone.scm.pipeline.creation.auto.factor.one", true);
        for (HddsProtos.ReplicationFactor factor : HddsProtos.ReplicationFactor.values()) {
            if (this.skipCreation(factor, type, autoCreateFactorOne)) continue;
            if (!this.pipelineManager.getSafeModeStatus()) {
                try {
                    this.pipelineManager.scrubPipeline(type, factor);
                }
                catch (IOException e) {
                    LOG.error("Error while scrubbing pipelines {}", (Throwable)e);
                }
            }
            try {
                while (!this.scheduler.isClosed()) {
                    this.pipelineManager.createPipeline(type, factor);
                }
            }
            catch (IOException ioe) {
            }
            catch (Throwable t) {
                LOG.error("Error while creating pipelines", t);
            }
        }
        this.isPipelineCreatorRunning.set(false);
    }
}

