/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.pipeline;

import com.google.common.base.Preconditions;
import java.io.IOException;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.hdds.scm.events.SCMEvents;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.apache.hadoop.hdds.scm.pipeline.PipelineID;
import org.apache.hadoop.hdds.scm.pipeline.PipelineManager;
import org.apache.hadoop.hdds.scm.pipeline.PipelineNotFoundException;
import org.apache.hadoop.hdds.scm.pipeline.SCMPipelineMetrics;
import org.apache.hadoop.hdds.scm.safemode.SafeModeManager;
import org.apache.hadoop.hdds.scm.server.SCMDatanodeHeartbeatDispatcher;
import org.apache.hadoop.hdds.server.events.EventHandler;
import org.apache.hadoop.hdds.server.events.EventPublisher;
import org.apache.hadoop.ozone.protocol.commands.ClosePipelineCommand;
import org.apache.hadoop.ozone.protocol.commands.CommandForDatanode;
import org.apache.hadoop.ozone.protocol.commands.SCMCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipelineReportHandler
implements EventHandler<SCMDatanodeHeartbeatDispatcher.PipelineReportFromDatanode> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipelineReportHandler.class);
    private final PipelineManager pipelineManager;
    private final ConfigurationSource conf;
    private final SafeModeManager scmSafeModeManager;
    private final boolean pipelineAvailabilityCheck;
    private final SCMPipelineMetrics metrics;

    public PipelineReportHandler(SafeModeManager scmSafeModeManager, PipelineManager pipelineManager, ConfigurationSource conf) {
        Preconditions.checkNotNull((Object)pipelineManager);
        this.scmSafeModeManager = scmSafeModeManager;
        this.pipelineManager = pipelineManager;
        this.conf = conf;
        this.metrics = SCMPipelineMetrics.create();
        this.pipelineAvailabilityCheck = conf.getBoolean("hdds.scm.safemode.pipeline-availability.check", true);
    }

    public void onMessage(SCMDatanodeHeartbeatDispatcher.PipelineReportFromDatanode pipelineReportFromDatanode, EventPublisher publisher) {
        Preconditions.checkNotNull((Object)pipelineReportFromDatanode);
        DatanodeDetails dn = pipelineReportFromDatanode.getDatanodeDetails();
        StorageContainerDatanodeProtocolProtos.PipelineReportsProto pipelineReport = (StorageContainerDatanodeProtocolProtos.PipelineReportsProto)pipelineReportFromDatanode.getReport();
        Preconditions.checkNotNull((Object)dn, (Object)"Pipeline Report is missing DatanodeDetails.");
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Processing pipeline report for dn: {}", (Object)dn);
        }
        for (StorageContainerDatanodeProtocolProtos.PipelineReport report : pipelineReport.getPipelineReportList()) {
            try {
                this.processPipelineReport(report, dn, publisher);
            }
            catch (IOException e) {
                LOGGER.error("Could not process pipeline report={} from dn={} {}", new Object[]{report, dn, e});
            }
        }
    }

    protected void processPipelineReport(StorageContainerDatanodeProtocolProtos.PipelineReport report, DatanodeDetails dn, EventPublisher publisher) throws IOException {
        Pipeline pipeline;
        PipelineID pipelineID = PipelineID.getFromProtobuf((HddsProtos.PipelineID)report.getPipelineID());
        try {
            pipeline = this.pipelineManager.getPipeline(pipelineID);
        }
        catch (PipelineNotFoundException e) {
            ClosePipelineCommand closeCommand = new ClosePipelineCommand(pipelineID);
            CommandForDatanode datanodeCommand = new CommandForDatanode(dn.getUuid(), (SCMCommand)closeCommand);
            publisher.fireEvent(SCMEvents.DATANODE_COMMAND, (Object)datanodeCommand);
            return;
        }
        this.setReportedDatanode(pipeline, dn);
        this.setPipelineLeaderId(report, pipeline, dn);
        if (pipeline.getPipelineState() == Pipeline.PipelineState.ALLOCATED) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Pipeline {} {} reported by {}", new Object[]{pipeline.getFactor(), pipeline.getId(), dn});
            }
            if (pipeline.isHealthy()) {
                this.pipelineManager.openPipeline(pipelineID);
                if (this.pipelineAvailabilityCheck && this.scmSafeModeManager.getInSafeMode()) {
                    publisher.fireEvent(SCMEvents.OPEN_PIPELINE, (Object)pipeline);
                }
            }
        }
    }

    protected void setReportedDatanode(Pipeline pipeline, DatanodeDetails dn) throws IOException {
        pipeline.reportDatanode(dn);
    }

    protected void setPipelineLeaderId(StorageContainerDatanodeProtocolProtos.PipelineReport report, Pipeline pipeline, DatanodeDetails dn) {
        if (report.getIsLeader() || pipeline.getFactor() == HddsProtos.ReplicationFactor.ONE) {
            pipeline.setLeaderId(dn.getUuid());
            this.metrics.incNumPipelineBytesWritten(pipeline, report.getBytesWritten());
        }
    }

    protected PipelineManager getPipelineManager() {
        return this.pipelineManager;
    }
}

