/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.pipeline;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.events.SCMEvents;
import org.apache.hadoop.hdds.scm.exceptions.SCMException;
import org.apache.hadoop.hdds.scm.node.NodeManager;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.apache.hadoop.hdds.scm.pipeline.PipelineID;
import org.apache.hadoop.hdds.scm.pipeline.PipelinePlacementPolicy;
import org.apache.hadoop.hdds.scm.pipeline.PipelineProvider;
import org.apache.hadoop.hdds.scm.pipeline.PipelineStateManager;
import org.apache.hadoop.hdds.server.events.EventPublisher;
import org.apache.hadoop.ozone.protocol.commands.ClosePipelineCommand;
import org.apache.hadoop.ozone.protocol.commands.CommandForDatanode;
import org.apache.hadoop.ozone.protocol.commands.CreatePipelineCommand;
import org.apache.hadoop.ozone.protocol.commands.SCMCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RatisPipelineProvider
extends PipelineProvider {
    private static final Logger LOG = LoggerFactory.getLogger(RatisPipelineProvider.class);
    private final ConfigurationSource conf;
    private final EventPublisher eventPublisher;
    private final PipelinePlacementPolicy placementPolicy;
    private int pipelineNumberLimit;
    private int maxPipelinePerDatanode;

    RatisPipelineProvider(NodeManager nodeManager, PipelineStateManager stateManager, ConfigurationSource conf, EventPublisher eventPublisher) {
        super(nodeManager, stateManager);
        this.conf = conf;
        this.eventPublisher = eventPublisher;
        this.placementPolicy = new PipelinePlacementPolicy(nodeManager, stateManager, conf);
        this.pipelineNumberLimit = conf.getInt("ozone.scm.ratis.pipeline.limit", 0);
        this.maxPipelinePerDatanode = conf.getInt("ozone.datanode.pipeline.limit", 2);
    }

    private boolean exceedPipelineNumberLimit(HddsProtos.ReplicationFactor factor) {
        if (factor != HddsProtos.ReplicationFactor.THREE) {
            return false;
        }
        if (this.maxPipelinePerDatanode > 0) {
            return this.getPipelineStateManager().getPipelines(HddsProtos.ReplicationType.RATIS, factor).size() - this.getPipelineStateManager().getPipelines(HddsProtos.ReplicationType.RATIS, factor, Pipeline.PipelineState.CLOSED).size() > this.maxPipelinePerDatanode * this.getNodeManager().getNodeCount(HddsProtos.NodeState.HEALTHY) / factor.getNumber();
        }
        if (this.pipelineNumberLimit > 0) {
            return this.getPipelineStateManager().getPipelines(HddsProtos.ReplicationType.RATIS, HddsProtos.ReplicationFactor.THREE).size() - this.getPipelineStateManager().getPipelines(HddsProtos.ReplicationType.RATIS, HddsProtos.ReplicationFactor.THREE, Pipeline.PipelineState.CLOSED).size() > this.pipelineNumberLimit - this.getPipelineStateManager().getPipelines(HddsProtos.ReplicationType.RATIS, HddsProtos.ReplicationFactor.ONE).size();
        }
        return false;
    }

    @Override
    public Pipeline create(HddsProtos.ReplicationFactor factor) throws IOException {
        List<DatanodeDetails> dns;
        if (this.exceedPipelineNumberLimit(factor)) {
            throw new SCMException("Ratis pipeline number meets the limit: " + this.pipelineNumberLimit + " factor : " + factor.getNumber(), SCMException.ResultCodes.FAILED_TO_FIND_SUITABLE_NODE);
        }
        switch (factor) {
            case ONE: {
                dns = this.pickNodesNeverUsed(HddsProtos.ReplicationType.RATIS, HddsProtos.ReplicationFactor.ONE);
                break;
            }
            case THREE: {
                dns = this.placementPolicy.chooseDatanodes(null, null, factor.getNumber(), 0L);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown factor: " + factor.name());
            }
        }
        Pipeline pipeline = Pipeline.newBuilder().setId(PipelineID.randomId()).setState(Pipeline.PipelineState.ALLOCATED).setType(HddsProtos.ReplicationType.RATIS).setFactor(factor).setNodes(dns).build();
        CreatePipelineCommand createCommand = new CreatePipelineCommand(pipeline.getId(), pipeline.getType(), factor, dns);
        dns.forEach(node -> {
            LOG.info("Sending CreatePipelineCommand for pipeline:{} to datanode:{}", (Object)pipeline.getId(), (Object)node.getUuidString());
            this.eventPublisher.fireEvent(SCMEvents.DATANODE_COMMAND, (Object)new CommandForDatanode(node.getUuid(), (SCMCommand)createCommand));
        });
        return pipeline;
    }

    @Override
    public Pipeline create(HddsProtos.ReplicationFactor factor, List<DatanodeDetails> nodes) {
        return Pipeline.newBuilder().setId(PipelineID.randomId()).setState(Pipeline.PipelineState.ALLOCATED).setType(HddsProtos.ReplicationType.RATIS).setFactor(factor).setNodes(nodes).build();
    }

    @Override
    public void shutdown() {
    }

    @Override
    public void close(Pipeline pipeline) {
        ClosePipelineCommand closeCommand = new ClosePipelineCommand(pipeline.getId());
        pipeline.getNodes().stream().forEach(node -> {
            CommandForDatanode datanodeCommand = new CommandForDatanode(node.getUuid(), (SCMCommand)closeCommand);
            LOG.info("Send pipeline:{} close command to datanode {}", (Object)pipeline.getId(), (Object)datanodeCommand.getDatanodeId());
            this.eventPublisher.fireEvent(SCMEvents.DATANODE_COMMAND, (Object)datanodeCommand);
        });
    }
}

