/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.pipeline;

import java.io.IOException;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.ratis.RatisHelper;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.apache.hadoop.hdds.scm.pipeline.PipelineID;
import org.apache.hadoop.hdds.scm.pipeline.PipelineStateManager;
import org.apache.ratis.client.RaftClient;
import org.apache.ratis.grpc.GrpcTlsConfig;
import org.apache.ratis.protocol.RaftGroup;
import org.apache.ratis.protocol.RaftGroupId;
import org.apache.ratis.protocol.RaftPeer;
import org.apache.ratis.retry.RetryPolicy;
import org.apache.ratis.rpc.RpcType;
import org.apache.ratis.rpc.SupportedRpcType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RatisPipelineUtils {
    private static final Logger LOG = LoggerFactory.getLogger(RatisPipelineUtils.class);

    private RatisPipelineUtils() {
    }

    public static void destroyPipeline(Pipeline pipeline, ConfigurationSource ozoneConf, GrpcTlsConfig grpcTlsConfig) {
        RaftGroup group = RatisHelper.newRaftGroup((Pipeline)pipeline);
        if (LOG.isDebugEnabled()) {
            LOG.debug("destroying pipeline:{} with {}", (Object)pipeline.getId(), (Object)group);
        }
        for (DatanodeDetails dn : pipeline.getNodes()) {
            try {
                RatisPipelineUtils.destroyPipeline(dn, pipeline.getId(), ozoneConf, grpcTlsConfig);
            }
            catch (IOException e) {
                LOG.warn("Pipeline destroy failed for pipeline={} dn={} exception={}", new Object[]{pipeline.getId(), dn, e.getMessage()});
            }
        }
    }

    static void destroyPipeline(DatanodeDetails dn, PipelineID pipelineID, ConfigurationSource ozoneConf, GrpcTlsConfig grpcTlsConfig) throws IOException {
        String rpcType = ozoneConf.get("dfs.container.ratis.rpc.type", "GRPC");
        RetryPolicy retryPolicy = RatisHelper.createRetryPolicy((ConfigurationSource)ozoneConf);
        RaftPeer p = RatisHelper.toRaftPeer((DatanodeDetails)dn);
        try (RaftClient client = RatisHelper.newRaftClient((RpcType)SupportedRpcType.valueOfIgnoreCase((String)rpcType), (RaftPeer)p, (RetryPolicy)retryPolicy, (GrpcTlsConfig)grpcTlsConfig, (ConfigurationSource)ozoneConf);){
            client.groupRemove(RaftGroupId.valueOf((UUID)pipelineID.getId()), true, p.getId());
        }
    }

    static List<Pipeline> checkPipelineContainSameDatanodes(PipelineStateManager stateManager, Pipeline pipeline) {
        return stateManager.getPipelines(HddsProtos.ReplicationType.RATIS, HddsProtos.ReplicationFactor.THREE).stream().filter(p -> !p.getId().equals((Object)pipeline.getId()) && p.getPipelineState() != Pipeline.PipelineState.CLOSED && p.sameDatanodes(pipeline)).collect(Collectors.toList());
    }
}

