/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.safemode;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.exceptions.SCMException;
import org.apache.hadoop.hdds.scm.safemode.Precheck;
import org.apache.hadoop.hdds.scm.safemode.SafeModeRestrictedOps;

public class SafeModePrecheck
implements Precheck<HddsProtos.ScmOps> {
    private AtomicBoolean inSafeMode;
    public static final String PRECHECK_TYPE = "SafeModePrecheck";

    public SafeModePrecheck(ConfigurationSource conf) {
        boolean safeModeEnabled = conf.getBoolean("hdds.scm.safemode.enabled", true);
        this.inSafeMode = safeModeEnabled ? new AtomicBoolean(true) : new AtomicBoolean(false);
    }

    @Override
    public boolean check(HddsProtos.ScmOps op) throws SCMException {
        if (this.inSafeMode.get() && SafeModeRestrictedOps.isRestrictedInSafeMode(op)) {
            throw new SCMException("SafeModePrecheck failed for " + op, SCMException.ResultCodes.SAFE_MODE_EXCEPTION);
        }
        return this.inSafeMode.get();
    }

    @Override
    public String type() {
        return PRECHECK_TYPE;
    }

    public boolean isInSafeMode() {
        return this.inSafeMode.get();
    }

    public void setInSafeMode(boolean inSafeMode) {
        this.inSafeMode.set(inSafeMode);
    }
}

