/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.scm.ContainerPlacementStatus;
import org.apache.hadoop.hdds.scm.PlacementPolicy;
import org.apache.hadoop.hdds.scm.container.placement.algorithms.ContainerPlacementStatusDefault;
import org.apache.hadoop.hdds.scm.container.placement.metrics.SCMNodeMetric;
import org.apache.hadoop.hdds.scm.exceptions.SCMException;
import org.apache.hadoop.hdds.scm.net.NetworkTopology;
import org.apache.hadoop.hdds.scm.net.Node;
import org.apache.hadoop.hdds.scm.node.NodeManager;
import org.apache.hadoop.hdds.scm.node.NodeStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SCMCommonPlacementPolicy
implements PlacementPolicy {
    @VisibleForTesting
    static final Logger LOG = LoggerFactory.getLogger(SCMCommonPlacementPolicy.class);
    private final NodeManager nodeManager;
    private final Random rand;
    private final ConfigurationSource conf;
    private ContainerPlacementStatus validPlacement = new ContainerPlacementStatusDefault(1, 1, 1);
    private ContainerPlacementStatus invalidPlacement = new ContainerPlacementStatusDefault(0, 1, 1);

    public SCMCommonPlacementPolicy(NodeManager nodeManager, ConfigurationSource conf) {
        this.nodeManager = nodeManager;
        this.rand = new Random();
        this.conf = conf;
    }

    public NodeManager getNodeManager() {
        return this.nodeManager;
    }

    public Random getRand() {
        return this.rand;
    }

    public ConfigurationSource getConf() {
        return this.conf;
    }

    public List<DatanodeDetails> chooseDatanodes(List<DatanodeDetails> excludedNodes, List<DatanodeDetails> favoredNodes, int nodesRequired, long sizeRequired) throws SCMException {
        List<DatanodeDetails> healthyNodes = this.nodeManager.getNodes(NodeStatus.inServiceHealthy());
        if (excludedNodes != null) {
            healthyNodes.removeAll(excludedNodes);
        }
        if (healthyNodes.size() == 0) {
            String msg = "No healthy node found to allocate container.";
            LOG.error(msg);
            throw new SCMException(msg, SCMException.ResultCodes.FAILED_TO_FIND_HEALTHY_NODES);
        }
        if (healthyNodes.size() < nodesRequired) {
            String msg = String.format("Not enough healthy nodes to allocate container. %d  datanodes required. Found %d", nodesRequired, healthyNodes.size());
            LOG.error(msg);
            throw new SCMException(msg, SCMException.ResultCodes.FAILED_TO_FIND_SUITABLE_NODE);
        }
        List<DatanodeDetails> healthyList = healthyNodes.stream().filter(d -> this.hasEnoughSpace((DatanodeDetails)d, sizeRequired)).collect(Collectors.toList());
        if (healthyList.size() < nodesRequired) {
            String msg = String.format("Unable to find enough nodes that meet the space requirement of %d bytes in healthy node set. Nodes required: %d Found: %d", sizeRequired, nodesRequired, healthyList.size());
            LOG.error(msg);
            throw new SCMException(msg, SCMException.ResultCodes.FAILED_TO_FIND_NODES_WITH_SPACE);
        }
        return healthyList;
    }

    public boolean hasEnoughSpace(DatanodeDetails datanodeDetails, long sizeRequired) {
        SCMNodeMetric nodeMetric = this.nodeManager.getNodeStat(datanodeDetails);
        return nodeMetric != null && nodeMetric.get() != null && nodeMetric.get().getRemaining().hasResources(sizeRequired);
    }

    public List<DatanodeDetails> getResultSet(int nodesRequired, List<DatanodeDetails> healthyNodes) throws SCMException {
        ArrayList<DatanodeDetails> results = new ArrayList<DatanodeDetails>();
        for (int x = 0; x < nodesRequired; ++x) {
            DatanodeDetails nodeId = this.chooseNode(healthyNodes);
            if (nodeId == null) continue;
            results.add(nodeId);
        }
        if (results.size() < nodesRequired) {
            LOG.error("Unable to find the required number of healthy nodes that meet the criteria. Required nodes: {}, Found nodes: {}", (Object)nodesRequired, (Object)results.size());
            throw new SCMException("Unable to find required number of nodes.", SCMException.ResultCodes.FAILED_TO_FIND_SUITABLE_NODE);
        }
        return results;
    }

    public abstract DatanodeDetails chooseNode(List<DatanodeDetails> var1);

    protected int getRequiredRackCount() {
        return 1;
    }

    public ContainerPlacementStatus validateContainerPlacement(List<DatanodeDetails> dns, int replicas) {
        NetworkTopology topology = this.nodeManager.getClusterNetworkTopologyMap();
        int requiredRacks = this.getRequiredRackCount();
        if (topology == null || replicas == 1 || requiredRacks == 1) {
            if (dns.size() > 0) {
                return this.validPlacement;
            }
            return this.invalidPlacement;
        }
        int numRacks = 1;
        int maxLevel = topology.getMaxLevel();
        numRacks = topology.getNumOfNodes(maxLevel - 1);
        long currentRackCount = dns.stream().map(d -> topology.getAncestor((Node)d, 1)).distinct().count();
        if (replicas < requiredRacks) {
            requiredRacks = replicas;
        }
        return new ContainerPlacementStatusDefault((int)currentRackCount, requiredRacks, numRacks);
    }
}

