/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.block;

import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.management.ObjectName;
import org.apache.hadoop.hdds.client.BlockID;
import org.apache.hadoop.hdds.client.ContainerBlockID;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.StorageUnit;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.PipelineChoosePolicy;
import org.apache.hadoop.hdds.scm.PipelineRequestInformation;
import org.apache.hadoop.hdds.scm.ScmConfig;
import org.apache.hadoop.hdds.scm.ScmUtils;
import org.apache.hadoop.hdds.scm.block.BlockManager;
import org.apache.hadoop.hdds.scm.block.BlockmanagerMXBean;
import org.apache.hadoop.hdds.scm.block.DeletedBlockLog;
import org.apache.hadoop.hdds.scm.block.DeletedBlockLogImpl;
import org.apache.hadoop.hdds.scm.block.SCMBlockDeletingService;
import org.apache.hadoop.hdds.scm.container.ContainerInfo;
import org.apache.hadoop.hdds.scm.container.ContainerManager;
import org.apache.hadoop.hdds.scm.container.common.helpers.AllocatedBlock;
import org.apache.hadoop.hdds.scm.container.common.helpers.ExcludeList;
import org.apache.hadoop.hdds.scm.exceptions.SCMException;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.apache.hadoop.hdds.scm.pipeline.PipelineManager;
import org.apache.hadoop.hdds.scm.pipeline.PipelineNotFoundException;
import org.apache.hadoop.hdds.scm.safemode.SCMSafeModeManager;
import org.apache.hadoop.hdds.scm.safemode.SafeModePrecheck;
import org.apache.hadoop.hdds.scm.server.StorageContainerManager;
import org.apache.hadoop.hdds.server.events.EventPublisher;
import org.apache.hadoop.hdds.utils.UniqueId;
import org.apache.hadoop.metrics2.util.MBeans;
import org.apache.hadoop.ozone.common.BlockGroup;
import org.apache.hadoop.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlockManagerImpl
implements BlockManager,
BlockmanagerMXBean {
    private static final Logger LOG = LoggerFactory.getLogger(BlockManagerImpl.class);
    private final PipelineManager pipelineManager;
    private final ContainerManager containerManager;
    private final long containerSize;
    private final DeletedBlockLog deletedBlockLog;
    private final SCMBlockDeletingService blockDeletingService;
    private ObjectName mxBean;
    private SafeModePrecheck safeModePrecheck;
    private PipelineChoosePolicy pipelineChoosePolicy;

    public BlockManagerImpl(ConfigurationSource conf, StorageContainerManager scm) throws IOException {
        Objects.requireNonNull(scm, "SCM cannot be null");
        this.pipelineManager = scm.getPipelineManager();
        this.containerManager = scm.getContainerManager();
        this.pipelineChoosePolicy = scm.getPipelineChoosePolicy();
        this.containerSize = (long)conf.getStorageSize("ozone.scm.container.size", "5GB", StorageUnit.BYTES);
        this.mxBean = MBeans.register((String)"BlockManager", (String)"BlockManagerImpl", (Object)this);
        this.deletedBlockLog = new DeletedBlockLogImpl(conf, scm.getContainerManager(), scm.getScmMetadataStore());
        Duration svcInterval = ((ScmConfig)conf.getObject(ScmConfig.class)).getBlockDeletionInterval();
        long serviceTimeout = conf.getTimeDuration("ozone.block.deleting.service.timeout", "300s", TimeUnit.MILLISECONDS);
        this.blockDeletingService = new SCMBlockDeletingService(this.deletedBlockLog, this.containerManager, scm.getScmNodeManager(), scm.getEventQueue(), svcInterval, serviceTimeout, conf);
        this.safeModePrecheck = new SafeModePrecheck(conf);
    }

    @Override
    public void start() throws IOException {
        this.blockDeletingService.start();
    }

    @Override
    public void stop() throws IOException {
        this.blockDeletingService.shutdown();
        this.close();
    }

    @Override
    public AllocatedBlock allocateBlock(long size, HddsProtos.ReplicationType type, HddsProtos.ReplicationFactor factor, String owner, ExcludeList excludeList) throws IOException {
        block9: {
            Pipeline pipeline;
            ContainerInfo containerInfo;
            if (LOG.isTraceEnabled()) {
                LOG.trace("Size : {} , type : {}, factor : {} ", new Object[]{size, type, factor});
            }
            ScmUtils.preCheck(HddsProtos.ScmOps.allocateBlock, this.safeModePrecheck);
            if (size < 0L || size > this.containerSize) {
                LOG.warn("Invalid block size requested : {}", (Object)size);
                throw new SCMException("Unsupported block size: " + size, SCMException.ResultCodes.INVALID_BLOCK_SIZE);
            }
            do {
                List<Pipeline> availablePipelines;
                block10: {
                    availablePipelines = this.pipelineManager.getPipelines(type, factor, Pipeline.PipelineState.OPEN, excludeList.getDatanodes(), excludeList.getPipelineIds());
                    pipeline = null;
                    if (availablePipelines.size() == 0 && !excludeList.isEmpty()) {
                        availablePipelines = this.pipelineManager.getPipelines(type, factor, Pipeline.PipelineState.OPEN);
                    }
                    if (availablePipelines.size() == 0) {
                        try {
                            pipeline = this.pipelineManager.createPipeline(type, factor);
                            this.pipelineManager.waitPipelineReady(pipeline.getId(), 0L);
                        }
                        catch (SCMException se) {
                            LOG.warn("Pipeline creation failed for type:{} factor:{}. Datanodes may be used up.", new Object[]{type, factor, se});
                            break block9;
                        }
                        catch (IOException e) {
                            LOG.warn("Pipeline creation failed for type:{} factor:{}. Retrying get pipelines call once.", new Object[]{type, factor, e});
                            availablePipelines = this.pipelineManager.getPipelines(type, factor, Pipeline.PipelineState.OPEN, excludeList.getDatanodes(), excludeList.getPipelineIds());
                            if (availablePipelines.size() == 0 && !excludeList.isEmpty()) {
                                availablePipelines = this.pipelineManager.getPipelines(type, factor, Pipeline.PipelineState.OPEN);
                            }
                            if (availablePipelines.size() != 0) break block10;
                            LOG.info("Could not find available pipeline of type:{} and factor:{} even after retrying", (Object)type, (Object)factor);
                            break block9;
                        }
                    }
                }
                if (null != pipeline) continue;
                PipelineRequestInformation pri = PipelineRequestInformation.Builder.getBuilder().setSize(size).build();
                pipeline = this.pipelineChoosePolicy.choosePipeline(availablePipelines, pri);
            } while ((containerInfo = this.containerManager.getMatchingContainer(size, owner, pipeline, excludeList.getContainerIds())) == null);
            return this.newBlock(containerInfo);
        }
        LOG.error("Unable to allocate a block for the size: {}, type: {}, factor: {}", new Object[]{size, type, factor});
        return null;
    }

    private AllocatedBlock newBlock(ContainerInfo containerInfo) {
        try {
            Pipeline pipeline = this.pipelineManager.getPipeline(containerInfo.getPipelineID());
            long localID = UniqueId.next();
            long containerID = containerInfo.getContainerID();
            AllocatedBlock.Builder abb = new AllocatedBlock.Builder().setContainerBlockID(new ContainerBlockID(containerID, localID)).setPipeline(pipeline);
            if (LOG.isTraceEnabled()) {
                LOG.trace("New block allocated : {} Container ID: {}", (Object)localID, (Object)containerID);
            }
            this.pipelineManager.incNumBlocksAllocatedMetric(pipeline.getId());
            return abb.build();
        }
        catch (PipelineNotFoundException ex) {
            LOG.error("Pipeline Machine count is zero.", (Throwable)ex);
            return null;
        }
    }

    @Override
    public void deleteBlocks(List<BlockGroup> keyBlocksInfoList) throws IOException {
        ScmUtils.preCheck(HddsProtos.ScmOps.deleteBlock, this.safeModePrecheck);
        HashMap<Long, List<Long>> containerBlocks = new HashMap<Long, List<Long>>();
        for (BlockGroup bg : keyBlocksInfoList) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Deleting blocks {}", (Object)StringUtils.join((CharSequence)",", (Iterable)bg.getBlockIDList()));
            }
            for (BlockID block : bg.getBlockIDList()) {
                long containerID = block.getContainerID();
                if (containerBlocks.containsKey(containerID)) {
                    ((List)containerBlocks.get(containerID)).add(block.getLocalID());
                    continue;
                }
                ArrayList<Long> item = new ArrayList<Long>();
                item.add(block.getLocalID());
                containerBlocks.put(containerID, item);
            }
        }
        try {
            this.deletedBlockLog.addTransactions(containerBlocks);
        }
        catch (IOException e) {
            throw new IOException("Skip writing the deleted blocks info to the delLog because addTransaction fails. " + keyBlocksInfoList.size() + "Keys skipped", e);
        }
    }

    @Override
    public DeletedBlockLog getDeletedBlockLog() {
        return this.deletedBlockLog;
    }

    @Override
    public void close() throws IOException {
        if (this.deletedBlockLog != null) {
            this.deletedBlockLog.close();
        }
        this.blockDeletingService.shutdown();
        if (this.mxBean != null) {
            MBeans.unregister((ObjectName)this.mxBean);
            this.mxBean = null;
        }
    }

    @Override
    public int getOpenContainersNo() {
        return 0;
    }

    @Override
    public SCMBlockDeletingService getSCMBlockDeletingService() {
        return this.blockDeletingService;
    }

    public boolean isScmInSafeMode() {
        return this.safeModePrecheck.isInSafeMode();
    }

    public static Logger getLogger() {
        return LOG;
    }

    public void onMessage(SCMSafeModeManager.SafeModeStatus status, EventPublisher publisher) {
        this.safeModePrecheck.setInSafeMode(status.isInSafeMode());
    }
}

