/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.container;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.hdds.scm.container.ContainerID;
import org.apache.hadoop.hdds.scm.container.ContainerInfo;
import org.apache.hadoop.hdds.scm.container.ContainerManager;
import org.apache.hadoop.hdds.scm.container.ContainerNotFoundException;
import org.apache.hadoop.hdds.scm.container.ContainerReplica;
import org.apache.hadoop.hdds.scm.container.ContainerReplicaNotFoundException;
import org.apache.hadoop.hdds.scm.events.SCMEvents;
import org.apache.hadoop.hdds.server.events.EventPublisher;
import org.apache.hadoop.ozone.protocol.commands.CommandForDatanode;
import org.apache.hadoop.ozone.protocol.commands.DeleteContainerCommand;
import org.apache.hadoop.ozone.protocol.commands.SCMCommand;
import org.slf4j.Logger;

public class AbstractContainerReportHandler {
    private final ContainerManager containerManager;
    private final Logger logger;

    AbstractContainerReportHandler(ContainerManager containerManager, Logger logger) {
        Preconditions.checkNotNull((Object)containerManager);
        Preconditions.checkNotNull((Object)logger);
        this.containerManager = containerManager;
        this.logger = logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processContainerReplica(DatanodeDetails datanodeDetails, StorageContainerDatanodeProtocolProtos.ContainerReplicaProto replicaProto, EventPublisher publisher) throws IOException {
        ContainerID containerId = ContainerID.valueof((long)replicaProto.getContainerID());
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Processing replica of container {} from datanode {}", (Object)containerId, (Object)datanodeDetails);
        }
        ContainerInfo containerInfo = this.containerManager.getContainer(containerId);
        synchronized (containerInfo) {
            this.updateContainerStats(datanodeDetails, containerId, replicaProto);
            if (!this.updateContainerState(datanodeDetails, containerId, replicaProto, publisher)) {
                this.updateContainerReplica(datanodeDetails, containerId, replicaProto);
            }
        }
    }

    private void updateContainerStats(DatanodeDetails datanodeDetails, ContainerID containerId, StorageContainerDatanodeProtocolProtos.ContainerReplicaProto replicaProto) throws ContainerNotFoundException {
        ContainerInfo containerInfo = this.containerManager.getContainer(containerId);
        if (this.isHealthy(() -> ((StorageContainerDatanodeProtocolProtos.ContainerReplicaProto)replicaProto).getState())) {
            if (containerInfo.getSequenceId() < replicaProto.getBlockCommitSequenceId()) {
                containerInfo.updateSequenceId(replicaProto.getBlockCommitSequenceId());
            }
            List<ContainerReplica> otherReplicas = this.getOtherReplicas(containerId, datanodeDetails);
            long usedBytes = replicaProto.getUsed();
            long keyCount = replicaProto.getKeyCount();
            for (ContainerReplica r : otherReplicas) {
                if (containerInfo.getState().equals((Object)HddsProtos.LifeCycleState.OPEN)) {
                    usedBytes = Math.min(usedBytes, r.getBytesUsed());
                    keyCount = Math.min(keyCount, r.getKeyCount());
                    continue;
                }
                usedBytes = Math.max(usedBytes, r.getBytesUsed());
                keyCount = Math.max(keyCount, r.getKeyCount());
            }
            if (containerInfo.getUsedBytes() != usedBytes) {
                containerInfo.setUsedBytes(usedBytes);
            }
            if (containerInfo.getNumberOfKeys() != keyCount) {
                containerInfo.setNumberOfKeys(keyCount);
            }
        }
    }

    private List<ContainerReplica> getOtherReplicas(ContainerID containerId, DatanodeDetails exclude) throws ContainerNotFoundException {
        ArrayList<ContainerReplica> filteredReplicas = new ArrayList<ContainerReplica>();
        Set<ContainerReplica> replicas = this.containerManager.getContainerReplicas(containerId);
        for (ContainerReplica r : replicas) {
            if (r.getDatanodeDetails().equals((Object)exclude)) continue;
            filteredReplicas.add(r);
        }
        return filteredReplicas;
    }

    private boolean updateContainerState(DatanodeDetails datanode, ContainerID containerId, StorageContainerDatanodeProtocolProtos.ContainerReplicaProto replica, EventPublisher publisher) throws IOException {
        ContainerInfo container = this.containerManager.getContainer(containerId);
        boolean ignored = false;
        switch (container.getState()) {
            case OPEN: {
                if (replica.getState() == StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State.OPEN) break;
                this.logger.warn("Container {} is in OPEN state, but the datanode {} reports an {} replica.", new Object[]{containerId, datanode, replica.getState()});
                break;
            }
            case CLOSING: {
                if (replica.getState() == StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State.QUASI_CLOSED) {
                    this.logger.info("Moving container {} to QUASI_CLOSED state, datanode {} reported QUASI_CLOSED replica.", (Object)containerId, (Object)datanode);
                    this.containerManager.updateContainerState(containerId, HddsProtos.LifeCycleEvent.QUASI_CLOSE);
                }
                if (replica.getState() != StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State.CLOSED) break;
                this.logger.info("Moving container {} to CLOSED state, datanode {} reported CLOSED replica.", (Object)containerId, (Object)datanode);
                Preconditions.checkArgument((replica.getBlockCommitSequenceId() == container.getSequenceId() ? 1 : 0) != 0);
                this.containerManager.updateContainerState(containerId, HddsProtos.LifeCycleEvent.CLOSE);
                break;
            }
            case QUASI_CLOSED: {
                if (replica.getState() != StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State.CLOSED) break;
                this.logger.info("Moving container {} to CLOSED state, datanode {} reported CLOSED replica.", (Object)containerId, (Object)datanode);
                Preconditions.checkArgument((replica.getBlockCommitSequenceId() == container.getSequenceId() ? 1 : 0) != 0);
                this.containerManager.updateContainerState(containerId, HddsProtos.LifeCycleEvent.FORCE_CLOSE);
                break;
            }
            case CLOSED: {
                break;
            }
            case DELETING: {
                break;
            }
            case DELETED: {
                this.deleteReplica(containerId, datanode, publisher, "DELETED");
                ignored = true;
                break;
            }
        }
        return ignored;
    }

    private void updateContainerReplica(DatanodeDetails datanodeDetails, ContainerID containerId, StorageContainerDatanodeProtocolProtos.ContainerReplicaProto replicaProto) throws ContainerNotFoundException, ContainerReplicaNotFoundException {
        ContainerReplica replica = ContainerReplica.newBuilder().setContainerID(containerId).setContainerState(replicaProto.getState()).setDatanodeDetails(datanodeDetails).setOriginNodeId(UUID.fromString(replicaProto.getOriginNodeId())).setSequenceId(replicaProto.getBlockCommitSequenceId()).setKeyCount(replicaProto.getKeyCount()).setBytesUsed(replicaProto.getUsed()).build();
        if (replica.getState().equals((Object)StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State.DELETED)) {
            this.containerManager.removeContainerReplica(containerId, replica);
        } else {
            this.containerManager.updateContainerReplica(containerId, replica);
        }
    }

    private boolean isHealthy(Supplier<StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State> replicaState) {
        return replicaState.get() != StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State.UNHEALTHY && replicaState.get() != StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State.INVALID && replicaState.get() != StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State.DELETED;
    }

    protected ContainerManager getContainerManager() {
        return this.containerManager;
    }

    protected void deleteReplica(ContainerID containerID, DatanodeDetails dn, EventPublisher publisher, String reason) {
        DeleteContainerCommand deleteCommand = new DeleteContainerCommand(containerID.getId(), true);
        CommandForDatanode datanodeCommand = new CommandForDatanode(dn.getUuid(), (SCMCommand)deleteCommand);
        publisher.fireEvent(SCMEvents.DATANODE_COMMAND, (Object)datanodeCommand);
        this.logger.info("Sending delete container command for " + reason + " container {} to datanode {}", (Object)containerID.getId(), (Object)dn);
    }
}

