/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.container;

import com.google.common.base.Preconditions;
import java.util.Optional;
import java.util.UUID;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.hdds.scm.container.ContainerID;

public final class ContainerReplica
implements Comparable<ContainerReplica> {
    private final ContainerID containerID;
    private final StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State state;
    private final DatanodeDetails datanodeDetails;
    private final UUID placeOfBirth;
    private Long sequenceId;
    private final long keyCount;
    private final long bytesUsed;

    private ContainerReplica(ContainerID containerID, StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State state, DatanodeDetails datanode, UUID originNodeId, long keyNum, long dataSize) {
        this.containerID = containerID;
        this.state = state;
        this.datanodeDetails = datanode;
        this.placeOfBirth = originNodeId;
        this.keyCount = keyNum;
        this.bytesUsed = dataSize;
    }

    private void setSequenceId(Long seqId) {
        this.sequenceId = seqId;
    }

    public DatanodeDetails getDatanodeDetails() {
        return this.datanodeDetails;
    }

    public UUID getOriginDatanodeId() {
        return this.placeOfBirth;
    }

    public StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State getState() {
        return this.state;
    }

    public Long getSequenceId() {
        return this.sequenceId;
    }

    public long getKeyCount() {
        return this.keyCount;
    }

    public long getBytesUsed() {
        return this.bytesUsed;
    }

    public int hashCode() {
        return new HashCodeBuilder(61, 71).append((Object)this.containerID).append((Object)this.datanodeDetails).toHashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContainerReplica that = (ContainerReplica)o;
        return new EqualsBuilder().append((Object)this.containerID, (Object)that.containerID).append((Object)this.datanodeDetails, (Object)that.datanodeDetails).isEquals();
    }

    @Override
    public int compareTo(ContainerReplica that) {
        Preconditions.checkNotNull((Object)that);
        return new CompareToBuilder().append((Object)this.containerID, (Object)that.containerID).append((Object)this.datanodeDetails, (Object)that.datanodeDetails).build();
    }

    public static ContainerReplicaBuilder newBuilder() {
        return new ContainerReplicaBuilder();
    }

    public String toString() {
        return "ContainerReplica{containerID=" + this.containerID + ", state=" + this.state + ", datanodeDetails=" + this.datanodeDetails + ", placeOfBirth=" + this.placeOfBirth + ", sequenceId=" + this.sequenceId + ", keyCount=" + this.keyCount + ", bytesUsed=" + this.bytesUsed + '}';
    }

    public static class ContainerReplicaBuilder {
        private ContainerID containerID;
        private StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State state;
        private DatanodeDetails datanode;
        private UUID placeOfBirth;
        private Long sequenceId;
        private long bytesUsed;
        private long keyCount;

        public ContainerReplicaBuilder setContainerID(ContainerID cID) {
            this.containerID = cID;
            return this;
        }

        public ContainerReplicaBuilder setContainerState(StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State containerState) {
            this.state = containerState;
            return this;
        }

        public ContainerReplicaBuilder setDatanodeDetails(DatanodeDetails datanodeDetails) {
            this.datanode = datanodeDetails;
            return this;
        }

        public ContainerReplicaBuilder setOriginNodeId(UUID originNodeId) {
            this.placeOfBirth = originNodeId;
            return this;
        }

        public ContainerReplicaBuilder setSequenceId(long seqId) {
            this.sequenceId = seqId;
            return this;
        }

        public ContainerReplicaBuilder setKeyCount(long count) {
            this.keyCount = count;
            return this;
        }

        public ContainerReplicaBuilder setBytesUsed(long used) {
            this.bytesUsed = used;
            return this;
        }

        public ContainerReplica build() {
            Preconditions.checkNotNull((Object)this.containerID, (Object)"Container Id can't be null");
            Preconditions.checkNotNull((Object)this.state, (Object)"Container state can't be null");
            Preconditions.checkNotNull((Object)this.datanode, (Object)"DatanodeDetails can't be null");
            ContainerReplica replica = new ContainerReplica(this.containerID, this.state, this.datanode, Optional.ofNullable(this.placeOfBirth).orElse(this.datanode.getUuid()), this.keyCount, this.bytesUsed);
            Optional.ofNullable(this.sequenceId).ifPresent(x$0 -> replica.setSequenceId(x$0));
            return replica;
        }
    }
}

