/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.container.placement.algorithms;

import java.lang.reflect.Constructor;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.scm.PlacementPolicy;
import org.apache.hadoop.hdds.scm.container.placement.algorithms.SCMContainerPlacementMetrics;
import org.apache.hadoop.hdds.scm.container.placement.algorithms.SCMContainerPlacementRandom;
import org.apache.hadoop.hdds.scm.exceptions.SCMException;
import org.apache.hadoop.hdds.scm.net.NetworkTopology;
import org.apache.hadoop.hdds.scm.node.NodeManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ContainerPlacementPolicyFactory {
    private static final Logger LOG = LoggerFactory.getLogger(ContainerPlacementPolicyFactory.class);
    private static final Class<? extends PlacementPolicy> OZONE_SCM_CONTAINER_PLACEMENT_IMPL_DEFAULT = SCMContainerPlacementRandom.class;

    private ContainerPlacementPolicyFactory() {
    }

    public static PlacementPolicy getPolicy(ConfigurationSource conf, NodeManager nodeManager, NetworkTopology clusterMap, boolean fallback, SCMContainerPlacementMetrics metrics) throws SCMException {
        Constructor constructor;
        Class placementClass = conf.getClass("ozone.scm.container.placement.impl", OZONE_SCM_CONTAINER_PLACEMENT_IMPL_DEFAULT, PlacementPolicy.class);
        try {
            constructor = placementClass.getDeclaredConstructor(NodeManager.class, ConfigurationSource.class, NetworkTopology.class, Boolean.TYPE, SCMContainerPlacementMetrics.class);
            LOG.info("Create container placement policy of type {}", (Object)placementClass.getCanonicalName());
        }
        catch (NoSuchMethodException e) {
            String msg = "Failed to find constructor(NodeManager, Configuration, NetworkTopology, boolean) for class " + placementClass.getCanonicalName();
            LOG.error(msg);
            throw new SCMException(msg, SCMException.ResultCodes.FAILED_TO_INIT_CONTAINER_PLACEMENT_POLICY);
        }
        try {
            return (PlacementPolicy)constructor.newInstance(nodeManager, conf, clusterMap, fallback, metrics);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to instantiate class " + placementClass.getCanonicalName() + " for " + e.getMessage());
        }
    }
}

