/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.server;

import java.io.File;
import java.io.IOException;
import java.util.Properties;
import java.util.UUID;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.server.ServerUtils;
import org.apache.hadoop.ozone.common.Storage;

public class SCMStorageConfig
extends Storage {
    public SCMStorageConfig(OzoneConfiguration conf) throws IOException {
        super(HddsProtos.NodeType.SCM, ServerUtils.getScmDbDir((ConfigurationSource)conf), "scm");
    }

    public SCMStorageConfig(HddsProtos.NodeType type, File root, String sdName) throws IOException {
        super(type, root, sdName);
    }

    public void setScmId(String scmId) throws IOException {
        if (this.getState() == Storage.StorageState.INITIALIZED) {
            throw new IOException("SCM is already initialized.");
        }
        this.getStorageInfo().setProperty("scmUuid", scmId);
    }

    public String getScmId() {
        return this.getStorageInfo().getProperty("scmUuid");
    }

    protected Properties getNodeProperties() {
        String scmId = this.getScmId();
        if (scmId == null) {
            scmId = UUID.randomUUID().toString();
        }
        Properties scmProperties = new Properties();
        scmProperties.setProperty("scmUuid", scmId);
        return scmProperties;
    }
}

