/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.test;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.TimeoutException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.impl.Log4JLogger;
import org.apache.hadoop.test.TimedOutTestsListener;
import org.apache.log4j.Appender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.WriterAppender;
import org.junit.Assert;
import org.slf4j.Logger;

public abstract class GenericTestUtils {
    public static final String SYSPROP_TEST_DATA_DIR = "test.build.data";
    public static final String DEFAULT_TEST_DATA_DIR;
    public static final String DEFAULT_TEST_DATA_PATH = "target/test/data/";
    public static final String ERROR_MISSING_ARGUMENT = "Input supplier interface should be initialized";
    public static final String ERROR_INVALID_ARGUMENT = "Total wait time should be greater than check interval time";
    public static final boolean WINDOWS;
    private static final long NANOSECONDS_PER_MILLISECOND = 1000000L;

    public static File getTestDir() {
        String prop = System.getProperty(SYSPROP_TEST_DATA_DIR, DEFAULT_TEST_DATA_DIR);
        if (prop.isEmpty()) {
            prop = DEFAULT_TEST_DATA_DIR;
        }
        File dir = new File(prop).getAbsoluteFile();
        GenericTestUtils.assertDirCreation(dir);
        return dir;
    }

    public static File getTestDir(String subdir) {
        return new File(GenericTestUtils.getTestDir(), subdir).getAbsoluteFile();
    }

    public static File getRandomizedTestDir() {
        return new File(GenericTestUtils.getRandomizedTempPath());
    }

    public static String getTempPath(String subpath) {
        String prop;
        String string = prop = WINDOWS ? DEFAULT_TEST_DATA_PATH : System.getProperty(SYSPROP_TEST_DATA_DIR, DEFAULT_TEST_DATA_PATH);
        if (prop.isEmpty()) {
            prop = DEFAULT_TEST_DATA_PATH;
        }
        if (!prop.endsWith("/")) {
            prop = prop + "/";
        }
        return prop + subpath;
    }

    public static String getRandomizedTempPath() {
        return GenericTestUtils.getTempPath(RandomStringUtils.randomAlphanumeric((int)10));
    }

    public static void assertExists(File f) {
        Assert.assertTrue((String)("File " + f + " should exist"), (boolean)f.exists());
    }

    public static void assertDirCreation(File f) {
        Assert.assertTrue((String)("Could not create dir " + f + ", nor does it exist"), (f.mkdirs() || f.exists() ? 1 : 0) != 0);
    }

    public static void assertExceptionContains(String expectedText, Throwable t) {
        GenericTestUtils.assertExceptionContains(expectedText, t, "");
    }

    public static void assertExceptionContains(String expectedText, Throwable t, String message) {
        Assert.assertNotNull((String)"Null Throwable", (Object)t);
        String msg = t.toString();
        if (msg == null) {
            throw new AssertionError("Null Throwable.toString() value", t);
        }
        if (expectedText != null && !msg.contains(expectedText)) {
            String prefix = StringUtils.isEmpty((CharSequence)message) ? "" : message + ": ";
            throw new AssertionError(String.format("%s Expected to find '%s' %s: %s", prefix, expectedText, "but got unexpected exception", GenericTestUtils.stringifyException(t)), t);
        }
    }

    public static String stringifyException(Throwable e) {
        StringWriter stm = new StringWriter();
        PrintWriter wrt = new PrintWriter(stm);
        e.printStackTrace(wrt);
        wrt.close();
        return stm.toString();
    }

    public static void waitFor(Supplier<Boolean> check, int checkEveryMillis, int waitForMillis) throws TimeoutException, InterruptedException {
        Preconditions.checkNotNull(check, (Object)ERROR_MISSING_ARGUMENT);
        Preconditions.checkArgument((waitForMillis >= checkEveryMillis ? 1 : 0) != 0, (Object)ERROR_INVALID_ARGUMENT);
        long st = GenericTestUtils.monotonicNow();
        boolean result = (Boolean)check.get();
        while (!result && GenericTestUtils.monotonicNow() - st < (long)waitForMillis) {
            Thread.sleep(checkEveryMillis);
            result = (Boolean)check.get();
        }
        if (!result) {
            throw new TimeoutException("Timed out waiting for condition. Thread diagnostics:\n" + TimedOutTestsListener.buildThreadDiagnosticString());
        }
    }

    @Deprecated
    public static void setLogLevel(org.apache.log4j.Logger logger, Level level) {
        logger.setLevel(level);
    }

    public static void setLogLevel(Logger logger, org.slf4j.event.Level level) {
        GenericTestUtils.setLogLevel(GenericTestUtils.toLog4j(logger), Level.toLevel((String)level.toString()));
    }

    public static void setRootLogLevel(org.slf4j.event.Level level) {
        GenericTestUtils.setLogLevel(LogManager.getRootLogger(), Level.toLevel((String)level.toString()));
    }

    @Deprecated
    public static org.apache.log4j.Logger toLog4j(Logger logger) {
        return LogManager.getLogger((String)logger.getName());
    }

    private static long monotonicNow() {
        return System.nanoTime() / 1000000L;
    }

    static {
        WINDOWS = System.getProperty("os.name").startsWith("Windows");
        DEFAULT_TEST_DATA_DIR = "target" + File.separator + "test" + File.separator + "data";
    }

    public static class TeePrintStream
    extends PrintStream {
        private final PrintStream other;

        public TeePrintStream(OutputStream main, PrintStream other) throws UnsupportedEncodingException {
            super(main, false, StandardCharsets.UTF_8.name());
            this.other = other;
        }

        @Override
        public void flush() {
            super.flush();
            this.other.flush();
        }

        @Override
        public void write(byte[] buf, int off, int len) {
            super.write(buf, off, len);
            this.other.write(buf, off, len);
        }
    }

    public static class SystemErrCapturer
    implements AutoCloseable {
        private final ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        private final PrintStream bytesPrintStream = new PrintStream((OutputStream)this.bytes, false, StandardCharsets.UTF_8.name());
        private final PrintStream oldErr = System.err;

        public SystemErrCapturer() throws UnsupportedEncodingException {
            System.setErr(new TeePrintStream((OutputStream)this.oldErr, this.bytesPrintStream));
        }

        public String getOutput() throws UnsupportedEncodingException {
            return this.bytes.toString(StandardCharsets.UTF_8.name());
        }

        @Override
        public void close() throws Exception {
            IOUtils.closeQuietly((OutputStream)this.bytesPrintStream);
            System.setErr(this.oldErr);
        }
    }

    public static final class LogCapturer {
        private StringWriter sw = new StringWriter();
        private WriterAppender appender;
        private org.apache.log4j.Logger logger;

        public static LogCapturer captureLogs(Log l) {
            org.apache.log4j.Logger logger = ((Log4JLogger)l).getLogger();
            return new LogCapturer(logger);
        }

        public static LogCapturer captureLogs(Logger logger) {
            return new LogCapturer(GenericTestUtils.toLog4j(logger));
        }

        private LogCapturer(org.apache.log4j.Logger logger) {
            this.logger = logger;
            Appender defaultAppender = org.apache.log4j.Logger.getRootLogger().getAppender("stdout");
            if (defaultAppender == null) {
                defaultAppender = org.apache.log4j.Logger.getRootLogger().getAppender("console");
            }
            PatternLayout layout = defaultAppender == null ? new PatternLayout() : defaultAppender.getLayout();
            this.appender = new WriterAppender((Layout)layout, (Writer)this.sw);
            logger.addAppender((Appender)this.appender);
        }

        public String getOutput() {
            return this.sw.toString();
        }

        public void stopCapturing() {
            this.logger.removeAppender((Appender)this.appender);
        }

        public void clearOutput() {
            this.sw.getBuffer().setLength(0);
        }
    }
}

