/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.test;

import java.io.BufferedWriter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.management.LockInfo;
import java.lang.management.ManagementFactory;
import java.lang.management.MonitorInfo;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;

public class TimedOutTestsListener
extends RunListener {
    private static final String TEST_TIMED_OUT_PREFIX = "test timed out after";
    private static final String INDENT = "    ";
    private final PrintWriter output;

    public TimedOutTestsListener() {
        this(new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)System.err, StandardCharsets.UTF_8))));
    }

    public TimedOutTestsListener(PrintWriter output) {
        this.output = output;
    }

    public void testFailure(Failure failure) throws Exception {
        if (failure != null && failure.getMessage() != null && failure.getMessage().startsWith(TEST_TIMED_OUT_PREFIX)) {
            this.output.println("====> TEST TIMED OUT. PRINTING THREAD DUMP. <====");
            this.output.println();
            this.output.print(TimedOutTestsListener.buildThreadDiagnosticString());
        }
    }

    public static String buildThreadDiagnosticString() {
        StringWriter sw = new StringWriter();
        PrintWriter output = new PrintWriter(sw);
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss,SSS");
        output.println(String.format("Timestamp: %s", dateFormat.format(new Date())));
        output.println();
        output.println(TimedOutTestsListener.buildThreadDump());
        String deadlocksInfo = TimedOutTestsListener.buildDeadlockInfo();
        if (deadlocksInfo != null) {
            output.println("====> DEADLOCKS DETECTED <====");
            output.println();
            output.println(deadlocksInfo);
        }
        return sw.toString();
    }

    static String buildThreadDump() {
        StringBuilder dump = new StringBuilder();
        Map<Thread, StackTraceElement[]> stackTraces = Thread.getAllStackTraces();
        for (Map.Entry<Thread, StackTraceElement[]> e : stackTraces.entrySet()) {
            Thread thread = e.getKey();
            dump.append(String.format("\"%s\" %s prio=%d tid=%d %s%njava.lang.Thread.State: %s", thread.getName(), thread.isDaemon() ? "daemon" : "", thread.getPriority(), thread.getId(), Thread.State.WAITING.equals((Object)thread.getState()) ? "in Object.wait()" : thread.getState().name().toLowerCase(Locale.ENGLISH), Thread.State.WAITING.equals((Object)thread.getState()) ? "WAITING (on object monitor)" : thread.getState()));
            for (StackTraceElement stackTraceElement : e.getValue()) {
                dump.append("\n        at ");
                dump.append(stackTraceElement);
            }
            dump.append("\n");
        }
        return dump.toString();
    }

    static String buildDeadlockInfo() {
        ThreadMXBean threadBean = ManagementFactory.getThreadMXBean();
        long[] threadIds = threadBean.findMonitorDeadlockedThreads();
        if (threadIds != null && threadIds.length > 0) {
            ThreadInfo[] infos;
            StringWriter stringWriter = new StringWriter();
            PrintWriter out = new PrintWriter(stringWriter);
            for (ThreadInfo ti : infos = threadBean.getThreadInfo(threadIds, true, true)) {
                TimedOutTestsListener.printThreadInfo(ti, out);
                TimedOutTestsListener.printLockInfo(ti.getLockedSynchronizers(), out);
                out.println();
            }
            out.close();
            return stringWriter.toString();
        }
        return null;
    }

    private static void printThreadInfo(ThreadInfo ti, PrintWriter out) {
        TimedOutTestsListener.printThread(ti, out);
        StackTraceElement[] stacktrace = ti.getStackTrace();
        MonitorInfo[] monitors = ti.getLockedMonitors();
        for (int i = 0; i < stacktrace.length; ++i) {
            StackTraceElement ste = stacktrace[i];
            out.println("    at " + ste.toString());
            for (MonitorInfo mi : monitors) {
                if (mi.getLockedStackDepth() != i) continue;
                out.println("      - locked " + mi);
            }
        }
        out.println();
    }

    private static void printThread(ThreadInfo ti, PrintWriter out) {
        out.print("\"" + ti.getThreadName() + "\" Id=" + ti.getThreadId() + " in " + (Object)((Object)ti.getThreadState()));
        if (ti.getLockName() != null) {
            out.print(" on lock=" + ti.getLockName());
        }
        if (ti.isSuspended()) {
            out.print(" (suspended)");
        }
        if (ti.isInNative()) {
            out.print(" (running in native)");
        }
        out.println();
        if (ti.getLockOwnerName() != null) {
            out.println("     owned by " + ti.getLockOwnerName() + " Id=" + ti.getLockOwnerId());
        }
    }

    private static void printLockInfo(LockInfo[] locks, PrintWriter out) {
        out.println("    Locked synchronizers: count = " + locks.length);
        for (LockInfo li : locks) {
            out.println("      - " + li);
        }
        out.println();
    }
}

