/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import com.google.common.base.Preconditions;
import java.io.EOFException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.Future;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ChecksumException;
import org.apache.hadoop.fs.ReadOption;
import org.apache.hadoop.hdfs.BlockReader;
import org.apache.hadoop.hdfs.ByteBufferStrategy;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DFSInputStream;
import org.apache.hadoop.hdfs.DFSUtilClient;
import org.apache.hadoop.hdfs.ReaderStrategy;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.ErasureCodingPolicy;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.protocol.LocatedStripedBlock;
import org.apache.hadoop.hdfs.protocol.datatransfer.InvalidEncryptionKeyException;
import org.apache.hadoop.hdfs.util.StripedBlockUtil;
import org.apache.hadoop.io.ByteBufferPool;
import org.apache.hadoop.io.ElasticByteBufferPool;
import org.apache.hadoop.io.erasurecode.CodecUtil;
import org.apache.hadoop.io.erasurecode.ErasureCoderOptions;
import org.apache.hadoop.io.erasurecode.rawcoder.RawErasureDecoder;

@InterfaceAudience.Private
public class DFSStripedInputStream
extends DFSInputStream {
    private static final ByteBufferPool BUFFER_POOL = new ElasticByteBufferPool();
    private final BlockReaderInfo[] blockReaders;
    private final int cellSize;
    private final short dataBlkNum;
    private final short parityBlkNum;
    private final int groupSize;
    private ByteBuffer curStripeBuf;
    private ByteBuffer parityBuf;
    private final ErasureCodingPolicy ecPolicy;
    private final RawErasureDecoder decoder;
    private StripeRange curStripeRange;
    private final CompletionService<Void> readingService;
    private final Set<String> warnedNodes = Collections.newSetFromMap(new ConcurrentHashMap());

    DFSStripedInputStream(DFSClient dfsClient, String src, boolean verifyChecksum, ErasureCodingPolicy ecPolicy, LocatedBlocks locatedBlocks) throws IOException {
        super(dfsClient, src, verifyChecksum, locatedBlocks);
        assert (ecPolicy != null);
        this.ecPolicy = ecPolicy;
        this.cellSize = ecPolicy.getCellSize();
        this.dataBlkNum = (short)ecPolicy.getNumDataUnits();
        this.parityBlkNum = (short)ecPolicy.getNumParityUnits();
        this.groupSize = this.dataBlkNum + this.parityBlkNum;
        this.blockReaders = new BlockReaderInfo[this.groupSize];
        this.curStripeRange = new StripeRange(0L, 0L);
        this.readingService = new ExecutorCompletionService<Void>(dfsClient.getStripedReadsThreadPool());
        ErasureCoderOptions coderOptions = new ErasureCoderOptions((int)this.dataBlkNum, (int)this.parityBlkNum);
        this.decoder = CodecUtil.createRawDecoder((Configuration)dfsClient.getConfiguration(), (String)ecPolicy.getCodecName(), (ErasureCoderOptions)coderOptions);
        if (DFSClient.LOG.isDebugEnabled()) {
            DFSClient.LOG.debug("Creating an striped input stream for file " + src);
        }
    }

    private boolean useDirectBuffer() {
        return this.decoder.preferDirectBuffer();
    }

    private void resetCurStripeBuffer() {
        if (this.curStripeBuf == null) {
            this.curStripeBuf = BUFFER_POOL.getBuffer(this.useDirectBuffer(), this.cellSize * this.dataBlkNum);
        }
        this.curStripeBuf.clear();
        this.curStripeRange = new StripeRange(0L, 0L);
    }

    private ByteBuffer getParityBuffer() {
        if (this.parityBuf == null) {
            this.parityBuf = BUFFER_POOL.getBuffer(this.useDirectBuffer(), this.cellSize * this.parityBlkNum);
        }
        this.parityBuf.clear();
        return this.parityBuf;
    }

    private synchronized void blockSeekTo(long target) throws IOException {
        if (target >= this.getFileLength()) {
            throw new IOException("Attempted to read past end of file");
        }
        this.closeCurrentBlockReaders();
        LocatedStripedBlock targetBlockGroup = this.getBlockGroupAt(target);
        this.pos = target;
        this.blockEnd = targetBlockGroup.getStartOffset() + targetBlockGroup.getBlockSize() - 1L;
        this.currentLocatedBlock = targetBlockGroup;
    }

    @Override
    public synchronized void close() throws IOException {
        super.close();
        if (this.curStripeBuf != null) {
            BUFFER_POOL.putBuffer(this.curStripeBuf);
            this.curStripeBuf = null;
        }
        if (this.parityBuf != null) {
            BUFFER_POOL.putBuffer(this.parityBuf);
            this.parityBuf = null;
        }
    }

    @Override
    protected void closeCurrentBlockReaders() {
        this.resetCurStripeBuffer();
        if (this.blockReaders == null || this.blockReaders.length == 0) {
            return;
        }
        for (int i = 0; i < this.groupSize; ++i) {
            this.closeReader(this.blockReaders[i]);
            this.blockReaders[i] = null;
        }
        this.blockEnd = -1L;
    }

    private void closeReader(BlockReaderInfo readerInfo) {
        if (readerInfo != null) {
            if (readerInfo.reader != null) {
                try {
                    readerInfo.reader.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            readerInfo.skip();
        }
    }

    private long getOffsetInBlockGroup() {
        return this.getOffsetInBlockGroup(this.pos);
    }

    private long getOffsetInBlockGroup(long pos) {
        return pos - this.currentLocatedBlock.getStartOffset();
    }

    private void readOneStripe(DFSUtilClient.CorruptedBlocks corruptedBlocks) throws IOException {
        this.resetCurStripeBuffer();
        long offsetInBlockGroup = this.getOffsetInBlockGroup();
        long stripeLen = this.cellSize * this.dataBlkNum;
        int stripeIndex = (int)(offsetInBlockGroup / stripeLen);
        int stripeBufOffset = (int)(offsetInBlockGroup % stripeLen);
        int stripeLimit = (int)Math.min(this.currentLocatedBlock.getBlockSize() - (long)stripeIndex * stripeLen, stripeLen);
        StripeRange stripeRange = new StripeRange(offsetInBlockGroup, stripeLimit - stripeBufOffset);
        LocatedStripedBlock blockGroup = (LocatedStripedBlock)this.currentLocatedBlock;
        StripedBlockUtil.AlignedStripe[] stripes = StripedBlockUtil.divideOneStripe(this.ecPolicy, this.cellSize, blockGroup, offsetInBlockGroup, offsetInBlockGroup + stripeRange.length - 1L, this.curStripeBuf);
        LocatedBlock[] blks = StripedBlockUtil.parseStripedBlockGroup(blockGroup, this.cellSize, this.dataBlkNum, this.parityBlkNum);
        for (StripedBlockUtil.AlignedStripe stripe : stripes) {
            StatefulStripeReader sreader = new StatefulStripeReader(this.readingService, stripe, blks, this.blockReaders, corruptedBlocks);
            sreader.readStripe();
        }
        this.curStripeBuf.position(stripeBufOffset);
        this.curStripeBuf.limit(stripeLimit);
        this.curStripeRange = stripeRange;
    }

    private Callable<Void> readCells(final BlockReader reader, final DatanodeInfo datanode, final long currentReaderOffset, final long targetReaderOffset, final ByteBufferStrategy[] strategies, final ExtendedBlock currentBlock, final DFSUtilClient.CorruptedBlocks corruptedBlocks) {
        return new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                if (reader == null) {
                    throw new IOException("The BlockReader is null. The BlockReader creation failed or the reader hit exception.");
                }
                Preconditions.checkState((currentReaderOffset <= targetReaderOffset ? 1 : 0) != 0);
                if (currentReaderOffset < targetReaderOffset) {
                    long skipped = reader.skip(targetReaderOffset - currentReaderOffset);
                    Preconditions.checkState((skipped == targetReaderOffset - currentReaderOffset ? 1 : 0) != 0);
                }
                int result = 0;
                for (ByteBufferStrategy strategy : strategies) {
                    result += DFSStripedInputStream.this.readToBuffer(reader, datanode, strategy, currentBlock, corruptedBlocks);
                }
                return null;
            }
        };
    }

    private int readToBuffer(BlockReader blockReader, DatanodeInfo currentNode, ByteBufferStrategy strategy, ExtendedBlock currentBlock, DFSUtilClient.CorruptedBlocks corruptedBlocks) throws IOException {
        int targetLength = strategy.getTargetLength();
        try {
            int length;
            int ret;
            for (length = 0; length < targetLength; length += ret) {
                ret = strategy.readFromBlock(blockReader);
                if (ret >= 0) continue;
                throw new IOException("Unexpected EOS from the reader");
            }
            return length;
        }
        catch (ChecksumException ce) {
            DFSClient.LOG.warn("Found Checksum error for " + currentBlock + " from " + currentNode + " at " + ce.getPos());
            corruptedBlocks.addCorruptedBlock(currentBlock, currentNode);
            throw ce;
        }
        catch (IOException e) {
            DFSClient.LOG.warn("Exception while reading from " + currentBlock + " of " + this.src + " from " + currentNode, (Throwable)e);
            throw e;
        }
    }

    @Override
    public synchronized void seek(long targetPos) throws IOException {
        long targetOffsetInBlk;
        if (targetPos > this.getFileLength()) {
            throw new EOFException("Cannot seek after EOF");
        }
        if (targetPos < 0L) {
            throw new EOFException("Cannot seek to negative offset");
        }
        if (this.closed.get()) {
            throw new IOException("Stream is closed!");
        }
        if (targetPos <= this.blockEnd && this.curStripeRange.include(targetOffsetInBlk = this.getOffsetInBlockGroup(targetPos))) {
            int bufOffset = this.getStripedBufOffset(targetOffsetInBlk);
            this.curStripeBuf.position(bufOffset);
            this.pos = targetPos;
            return;
        }
        this.pos = targetPos;
        this.blockEnd = -1L;
    }

    private int getStripedBufOffset(long offsetInBlockGroup) {
        long stripeLen = this.cellSize * this.dataBlkNum;
        return (int)(offsetInBlockGroup % stripeLen);
    }

    @Override
    public synchronized boolean seekToNewSource(long targetPos) throws IOException {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected synchronized int readWithStrategy(ReaderStrategy strategy) throws IOException {
        this.dfsClient.checkOpen();
        if (this.closed.get()) {
            throw new IOException("Stream closed");
        }
        int len = strategy.getTargetLength();
        DFSUtilClient.CorruptedBlocks corruptedBlocks = new DFSUtilClient.CorruptedBlocks();
        if (this.pos < this.getFileLength()) {
            try {
                if (this.pos > this.blockEnd) {
                    this.blockSeekTo(this.pos);
                }
                int realLen = (int)Math.min((long)len, this.blockEnd - this.pos + 1L);
                Object object = this.infoLock;
                synchronized (object) {
                    if (this.locatedBlocks.isLastBlockComplete()) {
                        realLen = (int)Math.min((long)realLen, this.locatedBlocks.getFileLength() - this.pos);
                    }
                }
                int result = 0;
                while (result < realLen) {
                    if (!this.curStripeRange.include(this.getOffsetInBlockGroup())) {
                        this.readOneStripe(corruptedBlocks);
                    }
                    int ret = this.copyToTargetBuf(strategy, realLen - result);
                    result += ret;
                    this.pos += (long)ret;
                }
                int n = result;
                return n;
            }
            finally {
                this.reportCheckSumFailure(corruptedBlocks, this.currentLocatedBlock.getLocations().length, true);
            }
        }
        return -1;
    }

    private int copyToTargetBuf(ReaderStrategy strategy, int length) {
        long offsetInBlk = this.getOffsetInBlockGroup();
        int bufOffset = this.getStripedBufOffset(offsetInBlk);
        this.curStripeBuf.position(bufOffset);
        return strategy.readFromBuffer(this.curStripeBuf, Math.min(length, this.curStripeBuf.remaining()));
    }

    @Override
    protected LocatedBlock refreshLocatedBlock(LocatedBlock block) throws IOException {
        int i;
        LocatedStripedBlock lb;
        int idx = StripedBlockUtil.getBlockIndex(block.getBlock().getLocalBlock());
        LocatedStripedBlock lsb = lb = this.getBlockGroupAt(block.getStartOffset());
        for (i = 0; i < lsb.getBlockIndices().length && lsb.getBlockIndices()[i] != idx; ++i) {
        }
        if (DFSClient.LOG.isDebugEnabled()) {
            DFSClient.LOG.debug("refreshLocatedBlock for striped blocks, offset=" + block.getStartOffset() + ". Obtained block " + lb + ", idx=" + idx);
        }
        return StripedBlockUtil.constructInternalBlock(lsb, i, this.cellSize, this.dataBlkNum, idx);
    }

    private LocatedStripedBlock getBlockGroupAt(long offset) throws IOException {
        LocatedBlock lb = super.getBlockAt(offset);
        assert (lb instanceof LocatedStripedBlock) : "NameNode should return a LocatedStripedBlock for a striped file";
        return (LocatedStripedBlock)lb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void fetchBlockByteRange(LocatedBlock block, long start, long end, byte[] buf, int offset, DFSUtilClient.CorruptedBlocks corruptedBlocks) throws IOException {
        LocatedStripedBlock blockGroup = this.getBlockGroupAt(block.getStartOffset());
        StripedBlockUtil.AlignedStripe[] stripes = StripedBlockUtil.divideByteRangeIntoStripes(this.ecPolicy, this.cellSize, blockGroup, start, end, buf, offset);
        ExecutorCompletionService<Void> readService = new ExecutorCompletionService<Void>(this.dfsClient.getStripedReadsThreadPool());
        LocatedBlock[] blks = StripedBlockUtil.parseStripedBlockGroup(blockGroup, this.cellSize, this.dataBlkNum, this.parityBlkNum);
        BlockReaderInfo[] preaderInfos = new BlockReaderInfo[this.groupSize];
        try {
            for (StripedBlockUtil.AlignedStripe stripe : stripes) {
                PositionStripeReader preader = new PositionStripeReader(readService, stripe, blks, preaderInfos, corruptedBlocks);
                preader.readStripe();
            }
        }
        finally {
            for (BlockReaderInfo preaderInfo : preaderInfos) {
                this.closeReader(preaderInfo);
            }
        }
    }

    @Override
    protected void reportLostBlock(LocatedBlock lostBlock, Collection<DatanodeInfo> ignoredNodes) {
        Object[] nodes = lostBlock.getLocations();
        if (nodes != null && nodes.length > 0) {
            ArrayList<String> dnUUIDs = new ArrayList<String>();
            for (DatanodeInfo datanodeInfo : nodes) {
                dnUUIDs.add(datanodeInfo.getDatanodeUuid());
            }
            if (!this.warnedNodes.containsAll(dnUUIDs)) {
                DFSClient.LOG.warn(Arrays.toString(nodes) + " are unavailable and all striping blocks on them are lost. IgnoredNodes = " + ignoredNodes);
                this.warnedNodes.addAll(dnUUIDs);
            }
        } else {
            super.reportLostBlock(lostBlock, ignoredNodes);
        }
    }

    @Override
    public synchronized ByteBuffer read(ByteBufferPool bufferPool, int maxLength, EnumSet<ReadOption> opts) throws IOException, UnsupportedOperationException {
        throw new UnsupportedOperationException("Not support enhanced byte buffer access.");
    }

    @Override
    public synchronized void releaseBuffer(ByteBuffer buffer) {
        throw new UnsupportedOperationException("Not support enhanced byte buffer access.");
    }

    private void clearFutures(Collection<Future<Void>> futures) {
        for (Future<Void> future : futures) {
            future.cancel(false);
        }
        futures.clear();
    }

    class StatefulStripeReader
    extends StripeReader {
        ByteBuffer[] decodeInputs;

        StatefulStripeReader(CompletionService<Void> service, StripedBlockUtil.AlignedStripe alignedStripe, LocatedBlock[] targetBlocks, BlockReaderInfo[] readerInfos, DFSUtilClient.CorruptedBlocks corruptedBlocks) {
            super(service, alignedStripe, targetBlocks, readerInfos, corruptedBlocks);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void prepareDecodeInputs() {
            if (this.decodeInputs == null) {
                ByteBuffer cur;
                this.decodeInputs = new ByteBuffer[DFSStripedInputStream.this.dataBlkNum + DFSStripedInputStream.this.parityBlkNum];
                DFSStripedInputStream dFSStripedInputStream = DFSStripedInputStream.this;
                synchronized (dFSStripedInputStream) {
                    cur = DFSStripedInputStream.this.curStripeBuf.duplicate();
                }
                StripedBlockUtil.VerticalRange range = this.alignedStripe.range;
                for (int i = 0; i < DFSStripedInputStream.this.dataBlkNum; ++i) {
                    cur.limit(cur.capacity());
                    int pos = (int)(range.offsetInBlock % (long)DFSStripedInputStream.this.cellSize + (long)(DFSStripedInputStream.this.cellSize * i));
                    cur.position(pos);
                    cur.limit((int)((long)pos + range.spanInBlock));
                    this.decodeInputs[i] = cur.slice();
                    if (this.alignedStripe.chunks[i] != null) continue;
                    this.alignedStripe.chunks[i] = new StripedBlockUtil.StripingChunk(this.decodeInputs[i]);
                }
            }
        }

        @Override
        boolean prepareParityChunk(int index) {
            Preconditions.checkState((index >= DFSStripedInputStream.this.dataBlkNum && this.alignedStripe.chunks[index] == null ? 1 : 0) != 0);
            if (DFSStripedInputStream.this.blockReaders[index] != null && ((DFSStripedInputStream)DFSStripedInputStream.this).blockReaders[index].shouldSkip) {
                this.alignedStripe.chunks[index] = new StripedBlockUtil.StripingChunk(2);
                return false;
            }
            int parityIndex = index - DFSStripedInputStream.this.dataBlkNum;
            ByteBuffer buf = DFSStripedInputStream.this.getParityBuffer().duplicate();
            buf.position(DFSStripedInputStream.this.cellSize * parityIndex);
            buf.limit(DFSStripedInputStream.this.cellSize * parityIndex + (int)this.alignedStripe.range.spanInBlock);
            this.decodeInputs[index] = buf.slice();
            this.alignedStripe.chunks[index] = new StripedBlockUtil.StripingChunk(this.decodeInputs[index]);
            return true;
        }

        @Override
        void decode() {
            int span = (int)this.alignedStripe.getSpanInBlock();
            for (int i = 0; i < this.alignedStripe.chunks.length; ++i) {
                if (this.alignedStripe.chunks[i] != null && this.alignedStripe.chunks[i].state == 15) {
                    for (int j = 0; j < span; ++j) {
                        this.decodeInputs[i].put((byte)0);
                    }
                    this.decodeInputs[i].flip();
                    continue;
                }
                if (this.alignedStripe.chunks[i] == null || this.alignedStripe.chunks[i].state != 1) continue;
                this.decodeInputs[i].position(0);
                this.decodeInputs[i].limit(span);
            }
            int[] decodeIndices = new int[DFSStripedInputStream.this.parityBlkNum];
            int pos = 0;
            for (int i = 0; i < this.alignedStripe.chunks.length; ++i) {
                if (this.alignedStripe.chunks[i] == null || this.alignedStripe.chunks[i].state != 2) continue;
                if (i < DFSStripedInputStream.this.dataBlkNum) {
                    decodeIndices[pos++] = i;
                    continue;
                }
                this.decodeInputs[i] = null;
            }
            decodeIndices = Arrays.copyOf(decodeIndices, pos);
            int decodeChunkNum = decodeIndices.length;
            ByteBuffer[] outputs = new ByteBuffer[decodeChunkNum];
            for (int i = 0; i < decodeChunkNum; ++i) {
                outputs[i] = this.decodeInputs[decodeIndices[i]];
                outputs[i].position(0);
                outputs[i].limit((int)this.alignedStripe.range.spanInBlock);
                this.decodeInputs[decodeIndices[i]] = null;
            }
            DFSStripedInputStream.this.decoder.decode(this.decodeInputs, decodeIndices, outputs);
        }
    }

    class PositionStripeReader
    extends StripeReader {
        private byte[][] decodeInputs;

        PositionStripeReader(CompletionService<Void> service, StripedBlockUtil.AlignedStripe alignedStripe, LocatedBlock[] targetBlocks, BlockReaderInfo[] readerInfos, DFSUtilClient.CorruptedBlocks corruptedBlocks) {
            super(service, alignedStripe, targetBlocks, readerInfos, corruptedBlocks);
            this.decodeInputs = null;
        }

        @Override
        void prepareDecodeInputs() {
            if (this.decodeInputs == null) {
                this.decodeInputs = StripedBlockUtil.initDecodeInputs(this.alignedStripe, DFSStripedInputStream.this.dataBlkNum, DFSStripedInputStream.this.parityBlkNum);
            }
        }

        @Override
        boolean prepareParityChunk(int index) {
            Preconditions.checkState((index >= DFSStripedInputStream.this.dataBlkNum && this.alignedStripe.chunks[index] == null ? 1 : 0) != 0);
            this.alignedStripe.chunks[index] = new StripedBlockUtil.StripingChunk(this.decodeInputs[index]);
            this.alignedStripe.chunks[index].addByteArraySlice(0, (int)this.alignedStripe.getSpanInBlock());
            return true;
        }

        @Override
        void decode() {
            StripedBlockUtil.finalizeDecodeInputs(this.decodeInputs, this.alignedStripe);
            StripedBlockUtil.decodeAndFillBuffer(this.decodeInputs, this.alignedStripe, DFSStripedInputStream.this.dataBlkNum, DFSStripedInputStream.this.parityBlkNum, DFSStripedInputStream.this.decoder);
        }
    }

    private abstract class StripeReader {
        final Map<Future<Void>, Integer> futures = new HashMap<Future<Void>, Integer>();
        final StripedBlockUtil.AlignedStripe alignedStripe;
        final CompletionService<Void> service;
        final LocatedBlock[] targetBlocks;
        final DFSUtilClient.CorruptedBlocks corruptedBlocks;
        final BlockReaderInfo[] readerInfos;

        StripeReader(CompletionService<Void> service, StripedBlockUtil.AlignedStripe alignedStripe, LocatedBlock[] targetBlocks, BlockReaderInfo[] readerInfos, DFSUtilClient.CorruptedBlocks corruptedBlocks) {
            this.service = service;
            this.alignedStripe = alignedStripe;
            this.targetBlocks = targetBlocks;
            this.readerInfos = readerInfos;
            this.corruptedBlocks = corruptedBlocks;
        }

        abstract void prepareDecodeInputs();

        abstract boolean prepareParityChunk(int var1);

        abstract void decode();

        void updateState4SuccessRead(StripedBlockUtil.StripingChunkReadResult result) {
            Preconditions.checkArgument((result.state == 1 ? 1 : 0) != 0);
            this.readerInfos[result.index].setOffset(this.alignedStripe.getOffsetInBlock() + this.alignedStripe.getSpanInBlock());
        }

        private void checkMissingBlocks() throws IOException {
            if (this.alignedStripe.missingChunksNum > DFSStripedInputStream.this.parityBlkNum) {
                DFSStripedInputStream.this.clearFutures(this.futures.keySet());
                throw new IOException(this.alignedStripe.missingChunksNum + " missing blocks, the stripe is: " + this.alignedStripe + "; locatedBlocks is: " + DFSStripedInputStream.this.locatedBlocks);
            }
        }

        private void readDataForDecoding() throws IOException {
            this.prepareDecodeInputs();
            for (int i = 0; i < DFSStripedInputStream.this.dataBlkNum; ++i) {
                Preconditions.checkNotNull((Object)this.alignedStripe.chunks[i]);
                if (this.alignedStripe.chunks[i].state != 8 || this.readChunk(this.targetBlocks[i], i)) continue;
                ++this.alignedStripe.missingChunksNum;
            }
            this.checkMissingBlocks();
        }

        void readParityChunks(int num) throws IOException {
            int j = 0;
            for (int i = DFSStripedInputStream.this.dataBlkNum; i < DFSStripedInputStream.this.dataBlkNum + DFSStripedInputStream.this.parityBlkNum && j < num; ++i) {
                if (this.alignedStripe.chunks[i] != null) continue;
                if (this.prepareParityChunk(i) && this.readChunk(this.targetBlocks[i], i)) {
                    ++j;
                    continue;
                }
                ++this.alignedStripe.missingChunksNum;
            }
            this.checkMissingBlocks();
        }

        boolean createBlockReader(LocatedBlock block, int chunkIndex) throws IOException {
            block6: {
                BlockReader reader = null;
                ReaderRetryPolicy retry = new ReaderRetryPolicy();
                DFSInputStream.DNAddrPair dnInfo = new DFSInputStream.DNAddrPair(null, null, null);
                do {
                    try {
                        this.targetBlocks[chunkIndex] = block = DFSStripedInputStream.this.refreshLocatedBlock(block);
                        dnInfo = DFSStripedInputStream.this.getBestNodeDNAddrPair(block, null);
                        if (dnInfo != null) {
                            reader = DFSStripedInputStream.this.getBlockReader(block, this.alignedStripe.getOffsetInBlock(), block.getBlockSize() - this.alignedStripe.getOffsetInBlock(), dnInfo.addr, dnInfo.storageType, dnInfo.info);
                            continue;
                        }
                        break block6;
                    }
                    catch (IOException e) {
                        if (e instanceof InvalidEncryptionKeyException && retry.shouldRefetchEncryptionKey()) {
                            DFSClient.LOG.info("Will fetch a new encryption key and retry, encryption key was invalid when connecting to " + dnInfo.addr + " : " + e);
                            DFSStripedInputStream.this.dfsClient.clearDataEncryptionKey();
                            retry.refetchEncryptionKey();
                            continue;
                        }
                        if (retry.shouldRefetchToken() && DFSInputStream.tokenRefetchNeeded(e, dnInfo.addr)) {
                            DFSStripedInputStream.this.fetchBlockAt(block.getStartOffset());
                            retry.refetchToken();
                            continue;
                        }
                        DFSClient.LOG.warn("Failed to connect to " + dnInfo.addr + " for block" + block.getBlock(), (Throwable)e);
                        DFSStripedInputStream.this.fetchBlockAt(block.getStartOffset());
                        DFSStripedInputStream.this.addToDeadNodes(dnInfo.info);
                    }
                } while (reader == null);
                this.readerInfos[chunkIndex] = new BlockReaderInfo(reader, dnInfo.info, this.alignedStripe.getOffsetInBlock());
                return true;
            }
            return false;
        }

        private ByteBufferStrategy[] getReadStrategies(StripedBlockUtil.StripingChunk chunk) {
            if (chunk.byteBuffer != null) {
                ByteBufferStrategy strategy = new ByteBufferStrategy(chunk.byteBuffer, DFSStripedInputStream.this.readStatistics, DFSStripedInputStream.this.dfsClient);
                return new ByteBufferStrategy[]{strategy};
            }
            ByteBufferStrategy[] strategies = new ByteBufferStrategy[chunk.byteArray.getOffsets().length];
            for (int i = 0; i < strategies.length; ++i) {
                ByteBuffer buffer = ByteBuffer.wrap(chunk.byteArray.buf(), chunk.byteArray.getOffsets()[i], chunk.byteArray.getLengths()[i]);
                strategies[i] = new ByteBufferStrategy(buffer, DFSStripedInputStream.this.readStatistics, DFSStripedInputStream.this.dfsClient);
            }
            return strategies;
        }

        boolean readChunk(LocatedBlock block, int chunkIndex) throws IOException {
            StripedBlockUtil.StripingChunk chunk = this.alignedStripe.chunks[chunkIndex];
            if (block == null) {
                chunk.state = 2;
                return false;
            }
            if (this.readerInfos[chunkIndex] == null) {
                if (!this.createBlockReader(block, chunkIndex)) {
                    chunk.state = 2;
                    return false;
                }
            } else if (this.readerInfos[chunkIndex].shouldSkip) {
                chunk.state = 2;
                return false;
            }
            chunk.state = 4;
            Callable readCallable = DFSStripedInputStream.this.readCells(this.readerInfos[chunkIndex].reader, this.readerInfos[chunkIndex].datanode, this.readerInfos[chunkIndex].blockReaderOffset, this.alignedStripe.getOffsetInBlock(), this.getReadStrategies(chunk), block.getBlock(), this.corruptedBlocks);
            Future<Void> request = this.service.submit(readCallable);
            this.futures.put(request, chunkIndex);
            return true;
        }

        void readStripe() throws IOException {
            for (int i = 0; i < DFSStripedInputStream.this.dataBlkNum; ++i) {
                if (this.alignedStripe.chunks[i] == null || this.alignedStripe.chunks[i].state == 15 || this.readChunk(this.targetBlocks[i], i)) continue;
                ++this.alignedStripe.missingChunksNum;
            }
            if (this.alignedStripe.missingChunksNum > 0) {
                this.checkMissingBlocks();
                this.readDataForDecoding();
                this.readParityChunks(this.alignedStripe.missingChunksNum);
            }
            while (!this.futures.isEmpty()) {
                try {
                    StripedBlockUtil.StripingChunkReadResult r = StripedBlockUtil.getNextCompletedStripedRead(this.service, this.futures, 0L);
                    if (DFSClient.LOG.isDebugEnabled()) {
                        DFSClient.LOG.debug("Read task returned: " + r + ", for stripe " + this.alignedStripe);
                    }
                    StripedBlockUtil.StripingChunk returnedChunk = this.alignedStripe.chunks[r.index];
                    Preconditions.checkNotNull((Object)returnedChunk);
                    Preconditions.checkState((returnedChunk.state == 4 ? 1 : 0) != 0);
                    if (r.state == 1) {
                        returnedChunk.state = 1;
                        ++this.alignedStripe.fetchedChunksNum;
                        this.updateState4SuccessRead(r);
                        if (this.alignedStripe.fetchedChunksNum != DFSStripedInputStream.this.dataBlkNum) continue;
                        DFSStripedInputStream.this.clearFutures(this.futures.keySet());
                        break;
                    }
                    returnedChunk.state = 2;
                    DFSStripedInputStream.this.closeReader(this.readerInfos[r.index]);
                    int missing = this.alignedStripe.missingChunksNum++;
                    this.checkMissingBlocks();
                    this.readDataForDecoding();
                    this.readParityChunks(this.alignedStripe.missingChunksNum - missing);
                }
                catch (InterruptedException ie) {
                    String err = "Read request interrupted";
                    DFSClient.LOG.error(err);
                    DFSStripedInputStream.this.clearFutures(this.futures.keySet());
                    throw new InterruptedIOException(err);
                }
            }
            if (this.alignedStripe.missingChunksNum > 0) {
                this.decode();
            }
        }
    }

    private static class BlockReaderInfo {
        final BlockReader reader;
        final DatanodeInfo datanode;
        long blockReaderOffset;
        boolean shouldSkip = false;

        BlockReaderInfo(BlockReader reader, DatanodeInfo dn, long offset) {
            this.reader = reader;
            this.datanode = dn;
            this.blockReaderOffset = offset;
        }

        void setOffset(long offset) {
            this.blockReaderOffset = offset;
        }

        void skip() {
            this.shouldSkip = true;
        }
    }

    private static class StripeRange {
        final long offsetInBlock;
        final long length;

        StripeRange(long offsetInBlock, long length) {
            Preconditions.checkArgument((offsetInBlock >= 0L && length >= 0L ? 1 : 0) != 0);
            this.offsetInBlock = offsetInBlock;
            this.length = length;
        }

        boolean include(long pos) {
            return pos >= this.offsetInBlock && pos < this.offsetInBlock + this.length;
        }
    }

    private static class ReaderRetryPolicy {
        private int fetchEncryptionKeyTimes = 1;
        private int fetchTokenTimes = 1;

        private ReaderRetryPolicy() {
        }

        void refetchEncryptionKey() {
            --this.fetchEncryptionKeyTimes;
        }

        void refetchToken() {
            --this.fetchTokenTimes;
        }

        boolean shouldRefetchEncryptionKey() {
            return this.fetchEncryptionKeyTimes > 0;
        }

        boolean shouldRefetchToken() {
            return this.fetchTokenTimes > 0;
        }
    }
}

