/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocol;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public enum ErasureCodingPolicyState {
    DISABLED(1),
    ENABLED(2),
    REMOVED(3);

    private static final ErasureCodingPolicyState[] CACHED_VALUES;
    private final int value;

    private ErasureCodingPolicyState(int v) {
        this.value = v;
    }

    public int getValue() {
        return this.value;
    }

    public static ErasureCodingPolicyState fromValue(int v) {
        if (v > 0 && v <= CACHED_VALUES.length) {
            return CACHED_VALUES[v - 1];
        }
        return null;
    }

    public static ErasureCodingPolicyState read(DataInput in) throws IOException {
        return ErasureCodingPolicyState.fromValue(in.readByte());
    }

    public void write(DataOutput out) throws IOException {
        out.writeByte(this.ordinal());
    }

    static {
        CACHED_VALUES = ErasureCodingPolicyState.values();
    }
}

