/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocol;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public final class ECBlockGroupStats {
    private final long lowRedundancyBlockGroups;
    private final long corruptBlockGroups;
    private final long missingBlockGroups;
    private final long bytesInFutureBlockGroups;
    private final long pendingDeletionBlocks;

    public ECBlockGroupStats(long lowRedundancyBlockGroups, long corruptBlockGroups, long missingBlockGroups, long bytesInFutureBlockGroups, long pendingDeletionBlocks) {
        this.lowRedundancyBlockGroups = lowRedundancyBlockGroups;
        this.corruptBlockGroups = corruptBlockGroups;
        this.missingBlockGroups = missingBlockGroups;
        this.bytesInFutureBlockGroups = bytesInFutureBlockGroups;
        this.pendingDeletionBlocks = pendingDeletionBlocks;
    }

    public long getBytesInFutureBlockGroups() {
        return this.bytesInFutureBlockGroups;
    }

    public long getCorruptBlockGroups() {
        return this.corruptBlockGroups;
    }

    public long getLowRedundancyBlockGroups() {
        return this.lowRedundancyBlockGroups;
    }

    public long getMissingBlockGroups() {
        return this.missingBlockGroups;
    }

    public long getPendingDeletionBlocks() {
        return this.pendingDeletionBlocks;
    }

    public String toString() {
        StringBuilder statsBuilder = new StringBuilder();
        statsBuilder.append("ECBlockGroupStats=[").append("LowRedundancyBlockGroups=").append(this.getLowRedundancyBlockGroups()).append(", CorruptBlockGroups=").append(this.getCorruptBlockGroups()).append(", MissingBlockGroups=").append(this.getMissingBlockGroups()).append(", BytesInFutureBlockGroups=").append(this.getBytesInFutureBlockGroups()).append(", PendingDeletionBlocks=").append(this.getPendingDeletionBlocks()).append("]");
        return statsBuilder.toString();
    }
}

