/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.web;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.TreeMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.web.WebHdfsFileSystem;
import org.apache.hadoop.hdfs.web.oauth2.ConfCredentialBasedAccessTokenProvider;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockserver.client.MockServerClient;
import org.mockserver.integration.ClientAndServer;
import org.mockserver.matchers.Times;
import org.mockserver.model.Header;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpResponse;
import org.mockserver.model.RequestDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestWebHDFSOAuth2 {
    public static final Logger LOG = LoggerFactory.getLogger(TestWebHDFSOAuth2.class);
    private ClientAndServer mockWebHDFS;
    private ClientAndServer mockOAuthServer;
    public static final int WEBHDFS_PORT = 7552;
    public static final int OAUTH_PORT = 7553;
    public static final Header CONTENT_TYPE_APPLICATION_JSON = new Header("Content-Type", new String[]{"application/json"});
    public static final String AUTH_TOKEN = "0123456789abcdef";
    public static final Header AUTH_TOKEN_HEADER = new Header("AUTHORIZATION", new String[]{"Bearer 0123456789abcdef"});

    @Before
    public void startMockOAuthServer() {
        this.mockOAuthServer = ClientAndServer.startClientAndServer((Integer[])new Integer[]{7553});
    }

    @Before
    public void startMockWebHDFSServer() {
        System.setProperty("hadoop.home.dir", System.getProperty("user.dir"));
        this.mockWebHDFS = ClientAndServer.startClientAndServer((Integer[])new Integer[]{7552});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void listStatusReturnsAsExpected() throws URISyntaxException, IOException {
        MockServerClient mockWebHDFSServerClient = new MockServerClient("localhost", 7552);
        MockServerClient mockOAuthServerClient = new MockServerClient("localhost", 7553);
        HttpRequest oauthServerRequest = this.getOAuthServerMockRequest(mockOAuthServerClient);
        HttpRequest fileSystemRequest = HttpRequest.request().withMethod("GET").withPath("/webhdfs/v1/test1/test2").withHeader(AUTH_TOKEN_HEADER);
        try {
            mockWebHDFSServerClient.when((RequestDefinition)fileSystemRequest, Times.exactly((int)1)).respond(HttpResponse.response().withStatusCode(Integer.valueOf(200)).withHeaders(new Header[]{CONTENT_TYPE_APPLICATION_JSON}).withBody("{\n  \"FileStatuses\":\n  {\n    \"FileStatus\":\n    [\n      {\n        \"accessTime\"      : 1320171722771,\n        \"blockSize\"       : 33554432,\n        \"group\"           : \"supergroup\",\n        \"length\"          : 24930,\n        \"modificationTime\": 1320171722771,\n        \"owner\"           : \"webuser\",\n        \"pathSuffix\"      : \"a.patch\",\n        \"permission\"      : \"644\",\n        \"replication\"     : 1,\n        \"type\"            : \"FILE\"\n      },\n      {\n        \"accessTime\"      : 0,\n        \"blockSize\"       : 0,\n        \"group\"           : \"supergroup\",\n        \"length\"          : 0,\n        \"modificationTime\": 1320895981256,\n        \"owner\"           : \"szetszwo\",\n        \"pathSuffix\"      : \"bar\",\n        \"permission\"      : \"711\",\n        \"replication\"     : 0,\n        \"type\"            : \"DIRECTORY\"\n      }\n    ]\n  }\n}\n"));
            WebHdfsFileSystem fs = new WebHdfsFileSystem();
            Configuration conf = this.getConfiguration();
            conf.set("dfs.webhdfs.oauth2.refresh.url", "http://localhost:7553/refresh");
            conf.set("dfs.webhdfs.oauth2.credential", "credential");
            URI uri = new URI("webhdfs://localhost:7552");
            fs.initialize(uri, conf);
            FileStatus[] ls = fs.listStatus(new Path("/test1/test2"));
            this.mockOAuthServer.verify(new RequestDefinition[]{oauthServerRequest});
            mockWebHDFSServerClient.verify(new RequestDefinition[]{fileSystemRequest});
            Assert.assertEquals((long)2L, (long)ls.length);
            Assert.assertEquals((Object)"a.patch", (Object)ls[0].getPath().getName());
            Assert.assertEquals((Object)"bar", (Object)ls[1].getPath().getName());
            fs.close();
        }
        finally {
            mockWebHDFSServerClient.clear((RequestDefinition)fileSystemRequest);
            mockOAuthServerClient.clear((RequestDefinition)oauthServerRequest);
        }
    }

    private HttpRequest getOAuthServerMockRequest(MockServerClient mockServerClient) throws IOException {
        HttpRequest expectedRequest = HttpRequest.request().withMethod("POST").withPath("/refresh").withBody("client_secret=credential&grant_type=client_credentials&client_id=MY_CLIENTID");
        TreeMap<String, String> map = new TreeMap<String, String>();
        map.put("expires_in", "0987654321");
        map.put("token_type", "bearer");
        map.put("access_token", AUTH_TOKEN);
        ObjectMapper mapper = new ObjectMapper();
        HttpResponse resp = HttpResponse.response().withStatusCode(Integer.valueOf(200)).withHeaders(new Header[]{CONTENT_TYPE_APPLICATION_JSON}).withBody(mapper.writeValueAsString(map));
        mockServerClient.when((RequestDefinition)expectedRequest, Times.exactly((int)1)).respond(resp);
        return expectedRequest;
    }

    public Configuration getConfiguration() {
        Configuration conf = new Configuration();
        conf.setBoolean("dfs.webhdfs.oauth2.enabled", true);
        conf.set("dfs.webhdfs.oauth2.client.id", "MY_CLIENTID");
        conf.set("dfs.webhdfs.oauth2.access.token.provider", ConfCredentialBasedAccessTokenProvider.class.getName());
        return conf;
    }

    @After
    public void stopMockWebHDFSServer() {
        this.mockWebHDFS.stop();
    }

    @After
    public void stopMockOAuthServer() {
        this.mockOAuthServer.stop();
    }
}

