/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.http.server;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.MessageFormat;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.http.server.HttpFSServerWebApp;
import org.apache.hadoop.fs.http.server.TestHttpFSServer;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.test.HTestCase;
import org.apache.hadoop.test.HadoopUsersConfTestHelper;
import org.apache.hadoop.test.TestDir;
import org.apache.hadoop.test.TestDirHelper;
import org.apache.hadoop.test.TestHdfs;
import org.apache.hadoop.test.TestJetty;
import org.apache.hadoop.test.TestJettyHelper;
import org.junit.Assert;
import org.junit.Test;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.webapp.WebAppContext;

public class TestHttpFSServerNoXAttrs
extends HTestCase {
    private MiniDFSCluster miniDfs;
    private Configuration nnConf;

    private void startMiniDFS() throws Exception {
        File testDirRoot = TestDirHelper.getTestDir();
        if (System.getProperty("hadoop.log.dir") == null) {
            System.setProperty("hadoop.log.dir", new File(testDirRoot, "hadoop-log").getAbsolutePath());
        }
        if (System.getProperty("test.build.data") == null) {
            System.setProperty("test.build.data", new File(testDirRoot, "hadoop-data").getAbsolutePath());
        }
        Configuration conf = HadoopUsersConfTestHelper.getBaseConf();
        HadoopUsersConfTestHelper.addUserConf((Configuration)conf);
        conf.set("fs.hdfs.impl.disable.cache", "true");
        conf.set("dfs.block.access.token.enable", "false");
        conf.set("dfs.permissions", "true");
        conf.set("hadoop.security.authentication", "simple");
        conf.setBoolean("dfs.namenode.xattrs.enabled", false);
        MiniDFSCluster.Builder builder = new MiniDFSCluster.Builder(conf);
        builder.numDataNodes(2);
        this.miniDfs = builder.build();
        this.nnConf = this.miniDfs.getConfiguration(0);
    }

    private void createHttpFSServer() throws Exception {
        File homeDir = TestDirHelper.getTestDir();
        Assert.assertTrue((boolean)new File(homeDir, "conf").mkdir());
        Assert.assertTrue((boolean)new File(homeDir, "log").mkdir());
        Assert.assertTrue((boolean)new File(homeDir, "temp").mkdir());
        HttpFSServerWebApp.setHomeDirForCurrentThread((String)homeDir.getAbsolutePath());
        File secretFile = new File(new File(homeDir, "conf"), "secret");
        FileWriter w = new FileWriter(secretFile);
        w.write("secret");
        ((Writer)w).close();
        File hadoopConfDir = new File(new File(homeDir, "conf"), "hadoop-conf");
        if (!hadoopConfDir.mkdirs()) {
            throw new IOException();
        }
        String fsDefaultName = this.nnConf.get("fs.defaultFS");
        Configuration conf = new Configuration(false);
        conf.set("fs.defaultFS", fsDefaultName);
        conf.setBoolean("dfs.namenode.xattrs.enabled", false);
        File hdfsSite = new File(hadoopConfDir, "hdfs-site.xml");
        FileOutputStream os = new FileOutputStream(hdfsSite);
        conf.writeXml((OutputStream)os);
        ((OutputStream)os).close();
        conf = new Configuration(false);
        conf.set("httpfs.hadoop.config.dir", hadoopConfDir.toString());
        conf.set("httpfs.proxyuser." + HadoopUsersConfTestHelper.getHadoopProxyUser() + ".groups", HadoopUsersConfTestHelper.getHadoopProxyUserGroups());
        conf.set("httpfs.proxyuser." + HadoopUsersConfTestHelper.getHadoopProxyUser() + ".hosts", HadoopUsersConfTestHelper.getHadoopProxyUserHosts());
        conf.set("httpfs.authentication.signature.secret.file", secretFile.getAbsolutePath());
        File httpfsSite = new File(new File(homeDir, "conf"), "httpfs-site.xml");
        os = new FileOutputStream(httpfsSite);
        conf.writeXml((OutputStream)os);
        ((OutputStream)os).close();
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        URL url = cl.getResource("webapp");
        if (url == null) {
            throw new IOException();
        }
        WebAppContext context = new WebAppContext(url.getPath(), "/webhdfs");
        Server server = TestJettyHelper.getJettyServer();
        server.addHandler((Handler)context);
        server.start();
    }

    private void getStatus(String filename, String command) throws Exception {
        String user = HadoopUsersConfTestHelper.getHadoopUsers()[0];
        if (filename.charAt(0) == '/') {
            filename = filename.substring(1);
        }
        String pathOps = MessageFormat.format("/webhdfs/v1/{0}?user.name={1}&op={2}", filename, user, command);
        URL url = new URL(TestJettyHelper.getJettyURL(), pathOps);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.connect();
        int resp = conn.getResponseCode();
        Assert.assertEquals((long)500L, (long)resp);
        BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getErrorStream()));
        String res = reader.readLine();
        Assert.assertTrue((boolean)res.contains("RemoteException"));
        Assert.assertTrue((boolean)res.contains("XAttr"));
        Assert.assertTrue((boolean)res.contains("rejected"));
    }

    private void putCmd(String filename, String command, String params) throws Exception {
        String user = HadoopUsersConfTestHelper.getHadoopUsers()[0];
        if (filename.charAt(0) == '/') {
            filename = filename.substring(1);
        }
        String pathOps = MessageFormat.format("/webhdfs/v1/{0}?user.name={1}{2}{3}&op={4}", filename, user, params == null ? "" : "&", params == null ? "" : params, command);
        URL url = new URL(TestJettyHelper.getJettyURL(), pathOps);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("PUT");
        conn.connect();
        int resp = conn.getResponseCode();
        Assert.assertEquals((long)500L, (long)resp);
        BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getErrorStream()));
        String err = reader.readLine();
        Assert.assertTrue((boolean)err.contains("RemoteException"));
        Assert.assertTrue((boolean)err.contains("XAttr"));
        Assert.assertTrue((boolean)err.contains("rejected"));
    }

    @Test
    @TestDir
    @TestJetty
    @TestHdfs
    public void testWithXAttrs() throws Exception {
        String name1 = "user.a1";
        byte[] value1 = new byte[]{49, 50, 51};
        String dir = "/noXAttr";
        String path = "/noXAttr/file";
        this.startMiniDFS();
        this.createHttpFSServer();
        FileSystem fs = FileSystem.get((Configuration)this.nnConf);
        fs.mkdirs(new Path("/noXAttr"));
        FSDataOutputStream os = fs.create(new Path("/noXAttr/file"));
        os.write(1);
        os.close();
        this.getStatus("/noXAttr/file", "GETXATTRS");
        this.putCmd("/noXAttr/file", "SETXATTR", TestHttpFSServer.setXAttrParam((String)"user.a1", (byte[])value1));
        this.putCmd("/noXAttr/file", "REMOVEXATTR", "xattr.name=user.a1");
    }
}

