/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.lib.servlet;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.hadoop.classification.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class HostnameFilter
implements Filter {
    static final ThreadLocal<String> HOSTNAME_TL = new ThreadLocal();
    private static final Logger log = LoggerFactory.getLogger(HostnameFilter.class);

    public void init(FilterConfig config) throws ServletException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        try {
            String hostname;
            try {
                String address = request.getRemoteAddr();
                if (address != null) {
                    hostname = InetAddress.getByName(address).getCanonicalHostName();
                } else {
                    log.warn("Request remote address is NULL");
                    hostname = "???";
                }
            }
            catch (UnknownHostException ex) {
                log.warn("Request remote address could not be resolved, {0}", (Object)ex.toString(), (Object)ex);
                hostname = "???";
            }
            HOSTNAME_TL.set(hostname);
            chain.doFilter(request, response);
        }
        finally {
            HOSTNAME_TL.remove();
        }
    }

    public static String get() {
        return (String)HOSTNAME_TL.get();
    }

    public void destroy() {
    }
}

