/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.lib.servlet;

import java.util.concurrent.atomic.AtomicBoolean;
import javax.servlet.FilterChain;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.hadoop.lib.servlet.HostnameFilter;
import org.apache.hadoop.lib.servlet.TestHostnameFilter;
import org.apache.hadoop.test.HTestCase;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestHostnameFilter
extends HTestCase {
    @Test
    public void hostname() throws Exception {
        ServletRequest request = (ServletRequest)Mockito.mock(ServletRequest.class);
        Mockito.when((Object)request.getRemoteAddr()).thenReturn((Object)"localhost");
        ServletResponse response = (ServletResponse)Mockito.mock(ServletResponse.class);
        AtomicBoolean invoked = new AtomicBoolean();
        1 chain = new /* Unavailable Anonymous Inner Class!! */;
        HostnameFilter filter = new HostnameFilter();
        filter.init(null);
        Assert.assertNull((Object)HostnameFilter.get());
        filter.doFilter(request, response, (FilterChain)chain);
        Assert.assertTrue((boolean)invoked.get());
        Assert.assertNull((Object)HostnameFilter.get());
        filter.destroy();
    }

    @Test
    public void testMissingHostname() throws Exception {
        ServletRequest request = (ServletRequest)Mockito.mock(ServletRequest.class);
        Mockito.when((Object)request.getRemoteAddr()).thenReturn(null);
        ServletResponse response = (ServletResponse)Mockito.mock(ServletResponse.class);
        AtomicBoolean invoked = new AtomicBoolean();
        2 chain = new /* Unavailable Anonymous Inner Class!! */;
        HostnameFilter filter = new HostnameFilter();
        filter.init(null);
        Assert.assertNull((Object)HostnameFilter.get());
        filter.doFilter(request, response, (FilterChain)chain);
        Assert.assertTrue((boolean)invoked.get());
        Assert.assertNull((Object)HostnameFilter.get());
        filter.destroy();
    }
}

