/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.http.server;

import java.io.IOException;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.fs.BlockStoragePolicySpi;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.FileChecksum;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.QuotaUsage;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.fs.XAttrCodec;
import org.apache.hadoop.fs.http.client.HttpFSFileSystem;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.AclStatus;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.protocol.BlockStoragePolicy;
import org.apache.hadoop.util.StringUtils;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

/*
 * Exception performing whole class analysis ignored.
 */
@InterfaceAudience.Private
public class FSOperations {
    private static Map<String, Object> toJson(FileStatus fileStatus) {
        LinkedHashMap<String, Object> json = new LinkedHashMap<String, Object>();
        json.put("FileStatus", FSOperations.toJsonInner((FileStatus)fileStatus, (boolean)true));
        return json;
    }

    private static Map<String, Object> toJson(FileStatus[] fileStatuses, boolean isFile) {
        LinkedHashMap<String, Object> json = new LinkedHashMap<String, Object>();
        LinkedHashMap<String, JSONArray> inner = new LinkedHashMap<String, JSONArray>();
        JSONArray statuses = new JSONArray();
        for (FileStatus f : fileStatuses) {
            statuses.add((Object)FSOperations.toJsonInner((FileStatus)f, (boolean)isFile));
        }
        inner.put("FileStatus", statuses);
        json.put("FileStatuses", inner);
        return json;
    }

    private static Map<String, Object> toJsonInner(FileStatus fileStatus, boolean emptyPathSuffix) {
        LinkedHashMap<String, Object> json = new LinkedHashMap<String, Object>();
        json.put("pathSuffix", emptyPathSuffix ? "" : fileStatus.getPath().getName());
        json.put("type", HttpFSFileSystem.FILE_TYPE.getType((FileStatus)fileStatus).toString());
        json.put("length", fileStatus.getLen());
        json.put("owner", fileStatus.getOwner());
        json.put("group", fileStatus.getGroup());
        json.put("permission", HttpFSFileSystem.permissionToString((FsPermission)fileStatus.getPermission()));
        json.put("accessTime", fileStatus.getAccessTime());
        json.put("modificationTime", fileStatus.getModificationTime());
        json.put("blockSize", fileStatus.getBlockSize());
        json.put("replication", fileStatus.getReplication());
        if (fileStatus.getPermission().getAclBit()) {
            json.put("aclBit", true);
        }
        if (fileStatus.getPermission().getEncryptedBit()) {
            json.put("encBit", true);
        }
        return json;
    }

    private static Map<String, Object> toJson(FileSystem.DirectoryEntries entries, boolean isFile) {
        LinkedHashMap<String, Object> json = new LinkedHashMap<String, Object>();
        LinkedHashMap<String, Object> inner = new LinkedHashMap<String, Object>();
        Map fileStatuses = FSOperations.toJson((FileStatus[])entries.getEntries(), (boolean)isFile);
        inner.put("partialListing", fileStatuses);
        inner.put("remainingEntries", entries.hasMore() ? 1 : 0);
        json.put("DirectoryListing", inner);
        return json;
    }

    private static Map<String, Object> aclStatusToJSON(AclStatus aclStatus) {
        LinkedHashMap<String, Object> json = new LinkedHashMap<String, Object>();
        LinkedHashMap<String, Object> inner = new LinkedHashMap<String, Object>();
        JSONArray entriesArray = new JSONArray();
        inner.put("owner", aclStatus.getOwner());
        inner.put("group", aclStatus.getGroup());
        inner.put("stickyBit", aclStatus.isStickyBit());
        for (AclEntry e : aclStatus.getEntries()) {
            entriesArray.add((Object)e.toString());
        }
        inner.put("entries", entriesArray);
        json.put("AclStatus", inner);
        return json;
    }

    private static Map fileChecksumToJSON(FileChecksum checksum) {
        LinkedHashMap<String, Object> json = new LinkedHashMap<String, Object>();
        json.put("algorithm", checksum.getAlgorithmName());
        json.put("bytes", StringUtils.byteToHexString((byte[])checksum.getBytes()));
        json.put("length", checksum.getLength());
        LinkedHashMap<String, LinkedHashMap<String, Object>> response = new LinkedHashMap<String, LinkedHashMap<String, Object>>();
        response.put("FileChecksum", json);
        return response;
    }

    private static Map xAttrsToJSON(Map<String, byte[]> xAttrs, XAttrCodec encoding) throws IOException {
        LinkedHashMap<String, JSONArray> jsonMap = new LinkedHashMap<String, JSONArray>();
        JSONArray jsonArray = new JSONArray();
        if (xAttrs != null) {
            for (Map.Entry<String, byte[]> e : xAttrs.entrySet()) {
                LinkedHashMap<String, String> json = new LinkedHashMap<String, String>();
                json.put("name", e.getKey());
                if (e.getValue() != null) {
                    json.put("value", XAttrCodec.encodeValue((byte[])e.getValue(), (XAttrCodec)encoding));
                }
                jsonArray.add(json);
            }
        }
        jsonMap.put("XAttrs", jsonArray);
        return jsonMap;
    }

    private static Map xAttrNamesToJSON(List<String> names) throws IOException {
        LinkedHashMap<String, String> jsonMap = new LinkedHashMap<String, String>();
        jsonMap.put("XAttrNames", JSONArray.toJSONString(names));
        return jsonMap;
    }

    private static Map contentSummaryToJSON(ContentSummary contentSummary) {
        LinkedHashMap<String, Long> json = new LinkedHashMap<String, Long>();
        json.put("directoryCount", contentSummary.getDirectoryCount());
        json.put("fileCount", contentSummary.getFileCount());
        json.put("length", contentSummary.getLength());
        Map quotaUsageMap = FSOperations.quotaUsageToMap((QuotaUsage)contentSummary);
        for (Map.Entry e : quotaUsageMap.entrySet()) {
            if (((String)e.getKey()).equals("fileAndDirectoryCount")) continue;
            json.put((String)e.getKey(), (Long)e.getValue());
        }
        LinkedHashMap<String, LinkedHashMap<String, Long>> response = new LinkedHashMap<String, LinkedHashMap<String, Long>>();
        response.put("ContentSummary", json);
        return response;
    }

    private static Map quotaUsageToJSON(QuotaUsage quotaUsage) {
        LinkedHashMap<String, Map> response = new LinkedHashMap<String, Map>();
        Map quotaUsageMap = FSOperations.quotaUsageToMap((QuotaUsage)quotaUsage);
        response.put("QuotaUsage", quotaUsageMap);
        return response;
    }

    private static Map<String, Object> quotaUsageToMap(QuotaUsage quotaUsage) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        result.put("fileAndDirectoryCount", quotaUsage.getFileAndDirectoryCount());
        result.put("quota", quotaUsage.getQuota());
        result.put("spaceConsumed", quotaUsage.getSpaceConsumed());
        result.put("spaceQuota", quotaUsage.getSpaceQuota());
        TreeMap<String, TreeMap<String, Long>> typeQuota = new TreeMap<String, TreeMap<String, Long>>();
        for (StorageType t : StorageType.getTypesSupportingQuota()) {
            long tQuota = quotaUsage.getTypeQuota(t);
            if (tQuota == -1L) continue;
            TreeMap<String, Long> type = (TreeMap<String, Long>)typeQuota.get(t.toString());
            if (type == null) {
                type = new TreeMap<String, Long>();
                typeQuota.put(t.toString(), type);
            }
            type.put("quota", quotaUsage.getTypeQuota(t));
            type.put("consumed", quotaUsage.getTypeConsumed(t));
        }
        result.put("typeQuota", typeQuota);
        return result;
    }

    private static JSONObject toJSON(String name, Object value) {
        JSONObject json = new JSONObject();
        json.put((Object)name, value);
        return json;
    }

    private static JSONObject storagePolicyToJSON(BlockStoragePolicySpi policy) {
        BlockStoragePolicy p = (BlockStoragePolicy)policy;
        JSONObject policyJson = new JSONObject();
        policyJson.put((Object)"id", (Object)p.getId());
        policyJson.put((Object)"name", (Object)p.getName());
        policyJson.put((Object)"storageTypes", (Object)FSOperations.toJsonArray((StorageType[])p.getStorageTypes()));
        policyJson.put((Object)"creationFallbacks", (Object)FSOperations.toJsonArray((StorageType[])p.getCreationFallbacks()));
        policyJson.put((Object)"replicationFallbacks", (Object)FSOperations.toJsonArray((StorageType[])p.getReplicationFallbacks()));
        policyJson.put((Object)"copyOnCreateFile", (Object)p.isCopyOnCreateFile());
        return policyJson;
    }

    private static JSONArray toJsonArray(StorageType[] storageTypes) {
        JSONArray jsonArray = new JSONArray();
        for (StorageType type : storageTypes) {
            jsonArray.add((Object)type.toString());
        }
        return jsonArray;
    }

    private static JSONObject storagePoliciesToJSON(Collection<? extends BlockStoragePolicySpi> storagePolicies) {
        JSONObject json = new JSONObject();
        JSONArray jsonArray = new JSONArray();
        JSONObject policies = new JSONObject();
        if (storagePolicies != null) {
            for (BlockStoragePolicySpi blockStoragePolicySpi : storagePolicies) {
                JSONObject policyMap = FSOperations.storagePolicyToJSON((BlockStoragePolicySpi)blockStoragePolicySpi);
                jsonArray.add((Object)policyMap);
            }
        }
        policies.put((Object)"BlockStoragePolicy", (Object)jsonArray);
        json.put((Object)"BlockStoragePolicies", (Object)policies);
        return json;
    }

    static /* synthetic */ JSONObject access$000(String x0, Object x1) {
        return FSOperations.toJSON((String)x0, (Object)x1);
    }

    static /* synthetic */ Map access$100(ContentSummary x0) {
        return FSOperations.contentSummaryToJSON((ContentSummary)x0);
    }

    static /* synthetic */ Map access$200(QuotaUsage x0) {
        return FSOperations.quotaUsageToJSON((QuotaUsage)x0);
    }

    static /* synthetic */ Map access$300(FileChecksum x0) {
        return FSOperations.fileChecksumToJSON((FileChecksum)x0);
    }

    static /* synthetic */ Map access$400(FileStatus x0) {
        return FSOperations.toJson((FileStatus)x0);
    }

    static /* synthetic */ Map access$500(FileStatus[] x0, boolean x1) {
        return FSOperations.toJson((FileStatus[])x0, (boolean)x1);
    }

    static /* synthetic */ Map access$600(FileSystem.DirectoryEntries x0, boolean x1) {
        return FSOperations.toJson((FileSystem.DirectoryEntries)x0, (boolean)x1);
    }

    static /* synthetic */ Map access$700(AclStatus x0) {
        return FSOperations.aclStatusToJSON((AclStatus)x0);
    }

    static /* synthetic */ Map access$800(List x0) throws IOException {
        return FSOperations.xAttrNamesToJSON((List)x0);
    }

    static /* synthetic */ Map access$900(Map x0, XAttrCodec x1) throws IOException {
        return FSOperations.xAttrsToJSON((Map)x0, (XAttrCodec)x1);
    }

    static /* synthetic */ JSONObject access$1000(Collection x0) {
        return FSOperations.storagePoliciesToJSON((Collection)x0);
    }

    static /* synthetic */ JSONObject access$1100(BlockStoragePolicySpi x0) {
        return FSOperations.storagePolicyToJSON((BlockStoragePolicySpi)x0);
    }
}

