/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.router;

import java.net.InetSocketAddress;
import org.apache.hadoop.hdfs.NameNodeProxiesClient;
import org.apache.hadoop.ipc.RPC;

public class ConnectionContext {
    private final NameNodeProxiesClient.ProxyAndInfo<?> client;
    private int numThreads = 0;
    private boolean closed = false;

    public ConnectionContext(NameNodeProxiesClient.ProxyAndInfo<?> connection) {
        this.client = connection;
    }

    public synchronized boolean isActive() {
        return this.numThreads > 0;
    }

    public synchronized boolean isClosed() {
        return this.closed;
    }

    public synchronized boolean isUsable() {
        return !this.isActive() && !this.isClosed();
    }

    public synchronized NameNodeProxiesClient.ProxyAndInfo<?> getClient() {
        ++this.numThreads;
        return this.client;
    }

    public synchronized void release() {
        if (--this.numThreads == 0 && this.closed) {
            this.close();
        }
    }

    public synchronized void close() {
        this.closed = true;
        if (this.numThreads == 0) {
            Object proxy = this.client.getProxy();
            RPC.stopProxy((Object)proxy);
        }
    }

    public String toString() {
        InetSocketAddress addr = this.client.getAddress();
        Object proxy = this.client.getProxy();
        Class<?> clazz = proxy.getClass();
        StringBuilder sb = new StringBuilder();
        sb.append(clazz.getSimpleName());
        sb.append("@");
        sb.append(addr);
        sb.append("x");
        sb.append(this.numThreads);
        if (this.closed) {
            sb.append("[CLOSED]");
        }
        return sb.toString();
    }
}

