/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.store.records.impl.pb;

import com.google.protobuf.Message;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.federation.protocol.proto.HdfsServerFederationProtos;
import org.apache.hadoop.hdfs.server.federation.resolver.RemoteLocation;
import org.apache.hadoop.hdfs.server.federation.resolver.order.DestinationOrder;
import org.apache.hadoop.hdfs.server.federation.router.RouterAdminServer;
import org.apache.hadoop.hdfs.server.federation.store.protocol.impl.pb.FederationProtocolPBTranslator;
import org.apache.hadoop.hdfs.server.federation.store.records.MountTable;
import org.apache.hadoop.hdfs.server.federation.store.records.impl.pb.PBRecord;

public class MountTablePBImpl
extends MountTable
implements PBRecord {
    private FederationProtocolPBTranslator<HdfsServerFederationProtos.MountTableRecordProto, HdfsServerFederationProtos.MountTableRecordProto.Builder, HdfsServerFederationProtos.MountTableRecordProtoOrBuilder> translator = new FederationProtocolPBTranslator(HdfsServerFederationProtos.MountTableRecordProto.class);

    public MountTablePBImpl() {
    }

    public MountTablePBImpl(HdfsServerFederationProtos.MountTableRecordProto proto) {
        this.setProto((Message)proto);
    }

    public HdfsServerFederationProtos.MountTableRecordProto getProto() {
        return this.translator.build();
    }

    @Override
    public void setProto(Message proto) {
        this.translator.setProto(proto);
    }

    @Override
    public void readInstance(String base64String) throws IOException {
        this.translator.readInstance(base64String);
    }

    @Override
    public String getSourcePath() {
        HdfsServerFederationProtos.MountTableRecordProtoOrBuilder proto = this.translator.getProtoOrBuilder();
        if (!proto.hasSrcPath()) {
            return null;
        }
        return proto.getSrcPath();
    }

    @Override
    public void setSourcePath(String path) {
        HdfsServerFederationProtos.MountTableRecordProto.Builder builder = this.translator.getBuilder();
        if (path == null) {
            builder.clearSrcPath();
        } else {
            builder.setSrcPath(path);
        }
    }

    @Override
    public List<RemoteLocation> getDestinations() {
        HdfsServerFederationProtos.MountTableRecordProtoOrBuilder proto = this.translator.getProtoOrBuilder();
        if (proto.getDestinationsCount() == 0) {
            return null;
        }
        LinkedList<RemoteLocation> ret = new LinkedList<RemoteLocation>();
        List<HdfsServerFederationProtos.RemoteLocationProto> destList = proto.getDestinationsList();
        for (HdfsServerFederationProtos.RemoteLocationProto dest : destList) {
            String nsId = dest.getNameserviceId();
            String path = dest.getPath();
            RemoteLocation loc = new RemoteLocation(nsId, path);
            ret.add(loc);
        }
        return ret;
    }

    @Override
    public void setDestinations(List<RemoteLocation> dests) {
        HdfsServerFederationProtos.MountTableRecordProto.Builder builder = this.translator.getBuilder();
        builder.clearDestinations();
        for (RemoteLocation dest : dests) {
            HdfsServerFederationProtos.RemoteLocationProto.Builder itemBuilder = HdfsServerFederationProtos.RemoteLocationProto.newBuilder();
            String nsId = dest.getNameserviceId();
            String path = dest.getDest();
            itemBuilder.setNameserviceId(nsId);
            itemBuilder.setPath(path);
            HdfsServerFederationProtos.RemoteLocationProto item = itemBuilder.build();
            builder.addDestinations(item);
        }
    }

    @Override
    public boolean addDestination(String nsId, String path) {
        List<RemoteLocation> dests = this.getDestinations();
        for (RemoteLocation dest : dests) {
            if (!dest.getNameserviceId().equals(nsId) || !dest.getDest().equals(path)) continue;
            return false;
        }
        HdfsServerFederationProtos.MountTableRecordProto.Builder builder = this.translator.getBuilder();
        HdfsServerFederationProtos.RemoteLocationProto.Builder itemBuilder = HdfsServerFederationProtos.RemoteLocationProto.newBuilder();
        itemBuilder.setNameserviceId(nsId);
        itemBuilder.setPath(path);
        HdfsServerFederationProtos.RemoteLocationProto item = itemBuilder.build();
        builder.addDestinations(item);
        return true;
    }

    @Override
    public void setDateModified(long time) {
        this.translator.getBuilder().setDateModified(time);
    }

    @Override
    public long getDateModified() {
        return this.translator.getProtoOrBuilder().getDateModified();
    }

    @Override
    public void setDateCreated(long time) {
        this.translator.getBuilder().setDateCreated(time);
    }

    @Override
    public long getDateCreated() {
        return this.translator.getProtoOrBuilder().getDateCreated();
    }

    @Override
    public boolean isReadOnly() {
        HdfsServerFederationProtos.MountTableRecordProtoOrBuilder proto = this.translator.getProtoOrBuilder();
        if (!proto.hasReadOnly()) {
            return false;
        }
        return proto.getReadOnly();
    }

    @Override
    public void setReadOnly(boolean ro) {
        this.translator.getBuilder().setReadOnly(ro);
    }

    @Override
    public DestinationOrder getDestOrder() {
        HdfsServerFederationProtos.MountTableRecordProtoOrBuilder proto = this.translator.getProtoOrBuilder();
        return this.convert(proto.getDestOrder());
    }

    @Override
    public void setDestOrder(DestinationOrder order) {
        HdfsServerFederationProtos.MountTableRecordProto.Builder builder = this.translator.getBuilder();
        if (order == null) {
            builder.clearDestOrder();
        } else {
            builder.setDestOrder(this.convert(order));
        }
    }

    @Override
    public String getOwnerName() {
        HdfsServerFederationProtos.MountTableRecordProtoOrBuilder proto = this.translator.getProtoOrBuilder();
        if (!proto.hasOwnerName()) {
            return RouterAdminServer.getSuperUser();
        }
        return proto.getOwnerName();
    }

    @Override
    public void setOwnerName(String owner) {
        HdfsServerFederationProtos.MountTableRecordProto.Builder builder = this.translator.getBuilder();
        if (owner == null) {
            builder.clearOwnerName();
        } else {
            builder.setOwnerName(owner);
        }
    }

    @Override
    public String getGroupName() {
        HdfsServerFederationProtos.MountTableRecordProtoOrBuilder proto = this.translator.getProtoOrBuilder();
        if (!proto.hasGroupName()) {
            return RouterAdminServer.getSuperGroup();
        }
        return proto.getGroupName();
    }

    @Override
    public void setGroupName(String group) {
        HdfsServerFederationProtos.MountTableRecordProto.Builder builder = this.translator.getBuilder();
        if (group == null) {
            builder.clearGroupName();
        } else {
            builder.setGroupName(group);
        }
    }

    @Override
    public FsPermission getMode() {
        HdfsServerFederationProtos.MountTableRecordProtoOrBuilder proto = this.translator.getProtoOrBuilder();
        short mode = 493;
        if (proto.hasMode()) {
            mode = (short)proto.getMode();
        }
        return new FsPermission(mode);
    }

    @Override
    public void setMode(FsPermission mode) {
        HdfsServerFederationProtos.MountTableRecordProto.Builder builder = this.translator.getBuilder();
        if (mode == null) {
            builder.clearMode();
        } else {
            builder.setMode(mode.toShort());
        }
    }

    private DestinationOrder convert(HdfsServerFederationProtos.MountTableRecordProto.DestOrder order) {
        switch (order) {
            case LOCAL: {
                return DestinationOrder.LOCAL;
            }
            case RANDOM: {
                return DestinationOrder.RANDOM;
            }
            case HASH_ALL: {
                return DestinationOrder.HASH_ALL;
            }
            case SPACE: {
                return DestinationOrder.SPACE;
            }
        }
        return DestinationOrder.HASH;
    }

    private HdfsServerFederationProtos.MountTableRecordProto.DestOrder convert(DestinationOrder order) {
        switch (order) {
            case LOCAL: {
                return HdfsServerFederationProtos.MountTableRecordProto.DestOrder.LOCAL;
            }
            case RANDOM: {
                return HdfsServerFederationProtos.MountTableRecordProto.DestOrder.RANDOM;
            }
            case HASH_ALL: {
                return HdfsServerFederationProtos.MountTableRecordProto.DestOrder.HASH_ALL;
            }
            case SPACE: {
                return HdfsServerFederationProtos.MountTableRecordProto.DestOrder.SPACE;
            }
        }
        return HdfsServerFederationProtos.MountTableRecordProto.DestOrder.HASH;
    }
}

