/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.tools.federation;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.server.federation.resolver.MountTableManager;
import org.apache.hadoop.hdfs.server.federation.resolver.RemoteLocation;
import org.apache.hadoop.hdfs.server.federation.resolver.order.DestinationOrder;
import org.apache.hadoop.hdfs.server.federation.router.NameserviceManager;
import org.apache.hadoop.hdfs.server.federation.router.RouterClient;
import org.apache.hadoop.hdfs.server.federation.router.RouterStateManager;
import org.apache.hadoop.hdfs.server.federation.store.protocol.AddMountTableEntryRequest;
import org.apache.hadoop.hdfs.server.federation.store.protocol.AddMountTableEntryResponse;
import org.apache.hadoop.hdfs.server.federation.store.protocol.DisableNameserviceRequest;
import org.apache.hadoop.hdfs.server.federation.store.protocol.DisableNameserviceResponse;
import org.apache.hadoop.hdfs.server.federation.store.protocol.EnableNameserviceRequest;
import org.apache.hadoop.hdfs.server.federation.store.protocol.EnableNameserviceResponse;
import org.apache.hadoop.hdfs.server.federation.store.protocol.EnterSafeModeRequest;
import org.apache.hadoop.hdfs.server.federation.store.protocol.EnterSafeModeResponse;
import org.apache.hadoop.hdfs.server.federation.store.protocol.GetDisabledNameservicesRequest;
import org.apache.hadoop.hdfs.server.federation.store.protocol.GetDisabledNameservicesResponse;
import org.apache.hadoop.hdfs.server.federation.store.protocol.GetMountTableEntriesRequest;
import org.apache.hadoop.hdfs.server.federation.store.protocol.GetMountTableEntriesResponse;
import org.apache.hadoop.hdfs.server.federation.store.protocol.GetSafeModeRequest;
import org.apache.hadoop.hdfs.server.federation.store.protocol.GetSafeModeResponse;
import org.apache.hadoop.hdfs.server.federation.store.protocol.LeaveSafeModeRequest;
import org.apache.hadoop.hdfs.server.federation.store.protocol.LeaveSafeModeResponse;
import org.apache.hadoop.hdfs.server.federation.store.protocol.RemoveMountTableEntryRequest;
import org.apache.hadoop.hdfs.server.federation.store.protocol.RemoveMountTableEntryResponse;
import org.apache.hadoop.hdfs.server.federation.store.protocol.UpdateMountTableEntryRequest;
import org.apache.hadoop.hdfs.server.federation.store.protocol.UpdateMountTableEntryResponse;
import org.apache.hadoop.hdfs.server.federation.store.records.MountTable;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class RouterAdmin
extends Configured
implements Tool {
    private static final Logger LOG = LoggerFactory.getLogger(RouterAdmin.class);
    private RouterClient client;

    public static void main(String[] argv) throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        RouterAdmin admin = new RouterAdmin((Configuration)conf);
        int res = ToolRunner.run((Tool)admin, (String[])argv);
        System.exit(res);
    }

    public RouterAdmin(Configuration conf) {
        super(conf);
    }

    public void printUsage() {
        String usage = "Federation Admin Tools:\n\t[-add <source> <nameservice1, nameservice2, ...> <destination> [-readonly] [-order HASH|LOCAL|RANDOM|HASH_ALL] -owner <owner> -group <group> -mode <mode>]\n\t[-update <source> <nameservice1, nameservice2, ...> <destination> [-readonly] [-order HASH|LOCAL|RANDOM|HASH_ALL] -owner <owner> -group <group> -mode <mode>]\n\t[-rm <source>]\n\t[-ls <path>]\n\t[-safemode enter | leave | get]\n\t[-nameservice enable | disable <nameservice>]\n\t[-getDisabledNameservices]\n";
        System.out.println(usage);
    }

    public int run(String[] argv) throws Exception {
        Throwable debugException;
        int exitCode;
        block36: {
            String cmd;
            if (argv.length < 1) {
                System.err.println("Not enough parameters specified");
                this.printUsage();
                return -1;
            }
            exitCode = -1;
            int i = 0;
            if ("-add".equals(cmd = argv[i++])) {
                if (argv.length < 4) {
                    System.err.println("Not enough parameters specified for cmd " + cmd);
                    this.printUsage();
                    return exitCode;
                }
            } else if ("-update".equals(cmd)) {
                if (argv.length < 4) {
                    System.err.println("Not enough parameters specified for cmd " + cmd);
                    this.printUsage();
                    return exitCode;
                }
            } else if ("-rm".equalsIgnoreCase(cmd)) {
                if (argv.length < 2) {
                    System.err.println("Not enough parameters specified for cmd " + cmd);
                    this.printUsage();
                    return exitCode;
                }
            } else if ("-safemode".equalsIgnoreCase(cmd)) {
                if (argv.length < 2) {
                    System.err.println("Not enough parameters specified for cmd " + cmd);
                    this.printUsage();
                    return exitCode;
                }
            } else if ("-nameservice".equalsIgnoreCase(cmd) && argv.length < 3) {
                System.err.println("Not enough parameters specificed for cmd " + cmd);
                this.printUsage();
                return exitCode;
            }
            try {
                String address = this.getConf().getTrimmed("dfs.federation.router.admin-address", "0.0.0.0:8111");
                InetSocketAddress routerSocket = NetUtils.createSocketAddr((String)address);
                this.client = new RouterClient(routerSocket, this.getConf());
            }
            catch (RPC.VersionMismatch v) {
                System.err.println("Version mismatch between client and server... command aborted");
                return exitCode;
            }
            catch (IOException e) {
                System.err.println("Bad connection to Router... command aborted");
                return exitCode;
            }
            debugException = null;
            exitCode = 0;
            try {
                if ("-add".equals(cmd)) {
                    if (this.addMount(argv, i)) {
                        System.out.println("Successfully added mount point " + argv[i]);
                    }
                    break block36;
                }
                if ("-update".equals(cmd)) {
                    if (this.updateMount(argv, i)) {
                        System.out.println("Successfully updated mount point " + argv[i]);
                    }
                    break block36;
                }
                if ("-rm".equals(cmd)) {
                    if (this.removeMount(argv[i])) {
                        System.out.println("Successfully removed mount point " + argv[i]);
                    }
                    break block36;
                }
                if ("-ls".equals(cmd)) {
                    if (argv.length > 1) {
                        this.listMounts(argv[i]);
                    } else {
                        this.listMounts("/");
                    }
                    break block36;
                }
                if ("-safemode".equals(cmd)) {
                    this.manageSafeMode(argv[i]);
                    break block36;
                }
                if ("-nameservice".equals(cmd)) {
                    String subcmd = argv[i];
                    String nsId = argv[i + 1];
                    this.manageNameservice(subcmd, nsId);
                    break block36;
                }
                if ("-getDisabledNameservices".equals(cmd)) {
                    this.getDisabledNameservices();
                    break block36;
                }
                this.printUsage();
                return exitCode;
            }
            catch (IllegalArgumentException arge) {
                debugException = arge;
                exitCode = -1;
                System.err.println(cmd.substring(1) + ": " + arge.getLocalizedMessage());
                this.printUsage();
            }
            catch (RemoteException e) {
                exitCode = -1;
                debugException = e;
                try {
                    String[] content = e.getLocalizedMessage().split("\n");
                    System.err.println(cmd.substring(1) + ": " + content[0]);
                    e.printStackTrace();
                }
                catch (Exception ex) {
                    System.err.println(cmd.substring(1) + ": " + ex.getLocalizedMessage());
                    e.printStackTrace();
                    debugException = ex;
                }
            }
            catch (Exception e) {
                exitCode = -1;
                debugException = e;
                System.err.println(cmd.substring(1) + ": " + e.getLocalizedMessage());
                e.printStackTrace();
            }
        }
        if (debugException != null) {
            LOG.debug("Exception encountered", debugException);
        }
        return exitCode;
    }

    public boolean addMount(String[] parameters, int i) throws IOException {
        String mount = parameters[i++];
        String[] nss = parameters[i++].split(",");
        String dest = parameters[i++];
        boolean readOnly = false;
        String owner = null;
        String group = null;
        FsPermission mode = null;
        DestinationOrder order = DestinationOrder.HASH;
        while (i < parameters.length) {
            if (parameters[i].equals("-readonly")) {
                readOnly = true;
            } else if (parameters[i].equals("-order")) {
                ++i;
                try {
                    order = DestinationOrder.valueOf(parameters[i]);
                }
                catch (Exception e) {
                    System.err.println("Cannot parse order: " + parameters[i]);
                }
            } else if (parameters[i].equals("-owner")) {
                owner = parameters[++i];
            } else if (parameters[i].equals("-group")) {
                group = parameters[++i];
            } else if (parameters[i].equals("-mode")) {
                short modeValue = Short.parseShort(parameters[++i], 8);
                mode = new FsPermission(modeValue);
            }
            ++i;
        }
        return this.addMount(mount, nss, dest, readOnly, order, new ACLEntity(owner, group, mode));
    }

    public boolean addMount(String mount, String[] nss, String dest, boolean readonly, DestinationOrder order, ACLEntity aclInfo) throws IOException {
        UpdateMountTableEntryRequest updateRequest;
        UpdateMountTableEntryResponse updateResponse;
        boolean updated;
        mount = RouterAdmin.normalizeFileSystemPath(mount);
        MountTableManager mountTable = this.client.getMountTableManager();
        GetMountTableEntriesRequest getRequest = GetMountTableEntriesRequest.newInstance(mount);
        GetMountTableEntriesResponse getResponse = mountTable.getMountTableEntries(getRequest);
        List<MountTable> results = getResponse.getEntries();
        MountTable existingEntry = null;
        for (MountTable result : results) {
            if (!mount.equals(result.getSourcePath())) continue;
            existingEntry = result;
        }
        if (existingEntry == null) {
            AddMountTableEntryRequest request;
            AddMountTableEntryResponse addResponse;
            boolean added;
            LinkedHashMap<String, String> destMap = new LinkedHashMap<String, String>();
            for (String ns : nss) {
                destMap.put(ns, dest);
            }
            MountTable newEntry = MountTable.newInstance(mount, destMap);
            if (readonly) {
                newEntry.setReadOnly(true);
            }
            if (order != null) {
                newEntry.setDestOrder(order);
            }
            if (aclInfo.getOwner() != null) {
                newEntry.setOwnerName(aclInfo.getOwner());
            }
            if (aclInfo.getGroup() != null) {
                newEntry.setGroupName(aclInfo.getGroup());
            }
            if (aclInfo.getMode() != null) {
                newEntry.setMode(aclInfo.getMode());
            }
            if (!(added = (addResponse = mountTable.addMountTableEntry(request = AddMountTableEntryRequest.newInstance(newEntry))).getStatus())) {
                System.err.println("Cannot add mount point " + mount);
            }
            return added;
        }
        for (String nsId : nss) {
            if (existingEntry.addDestination(nsId, dest)) continue;
            System.err.println("Cannot add destination at " + nsId + " " + dest);
        }
        if (readonly) {
            existingEntry.setReadOnly(true);
        }
        if (order != null) {
            existingEntry.setDestOrder(order);
        }
        if (aclInfo.getOwner() != null) {
            existingEntry.setOwnerName(aclInfo.getOwner());
        }
        if (aclInfo.getGroup() != null) {
            existingEntry.setGroupName(aclInfo.getGroup());
        }
        if (aclInfo.getMode() != null) {
            existingEntry.setMode(aclInfo.getMode());
        }
        if (!(updated = (updateResponse = mountTable.updateMountTableEntry(updateRequest = UpdateMountTableEntryRequest.newInstance(existingEntry))).getStatus())) {
            System.err.println("Cannot update mount point " + mount);
        }
        return updated;
    }

    public boolean updateMount(String[] parameters, int i) throws IOException {
        String mount = parameters[i++];
        String[] nss = parameters[i++].split(",");
        String dest = parameters[i++];
        boolean readOnly = false;
        String owner = null;
        String group = null;
        FsPermission mode = null;
        DestinationOrder order = null;
        while (i < parameters.length) {
            if (parameters[i].equals("-readonly")) {
                readOnly = true;
            } else if (parameters[i].equals("-order")) {
                ++i;
                try {
                    order = DestinationOrder.valueOf(parameters[i]);
                }
                catch (Exception e) {
                    System.err.println("Cannot parse order: " + parameters[i]);
                }
            } else if (parameters[i].equals("-owner")) {
                owner = parameters[++i];
            } else if (parameters[i].equals("-group")) {
                group = parameters[++i];
            } else if (parameters[i].equals("-mode")) {
                short modeValue = Short.parseShort(parameters[++i], 8);
                mode = new FsPermission(modeValue);
            }
            ++i;
        }
        return this.updateMount(mount, nss, dest, readOnly, order, new ACLEntity(owner, group, mode));
    }

    public boolean updateMount(String mount, String[] nss, String dest, boolean readonly, DestinationOrder order, ACLEntity aclInfo) throws IOException {
        UpdateMountTableEntryRequest updateRequest;
        UpdateMountTableEntryResponse updateResponse;
        boolean updated;
        mount = RouterAdmin.normalizeFileSystemPath(mount);
        MountTableManager mountTable = this.client.getMountTableManager();
        LinkedHashMap<String, String> destMap = new LinkedHashMap<String, String>();
        for (String ns : nss) {
            destMap.put(ns, dest);
        }
        MountTable newEntry = MountTable.newInstance(mount, destMap);
        newEntry.setReadOnly(readonly);
        if (order != null) {
            newEntry.setDestOrder(order);
        }
        if (aclInfo.getOwner() != null) {
            newEntry.setOwnerName(aclInfo.getOwner());
        }
        if (aclInfo.getGroup() != null) {
            newEntry.setGroupName(aclInfo.getGroup());
        }
        if (aclInfo.getMode() != null) {
            newEntry.setMode(aclInfo.getMode());
        }
        if (!(updated = (updateResponse = mountTable.updateMountTableEntry(updateRequest = UpdateMountTableEntryRequest.newInstance(newEntry))).getStatus())) {
            System.err.println("Cannot update mount point " + mount);
        }
        return updated;
    }

    public boolean removeMount(String path) throws IOException {
        RemoveMountTableEntryRequest request;
        path = RouterAdmin.normalizeFileSystemPath(path);
        MountTableManager mountTable = this.client.getMountTableManager();
        RemoveMountTableEntryResponse response = mountTable.removeMountTableEntry(request = RemoveMountTableEntryRequest.newInstance(path));
        boolean removed = response.getStatus();
        if (!removed) {
            System.out.println("Cannot remove mount point " + path);
        }
        return removed;
    }

    public void listMounts(String path) throws IOException {
        path = RouterAdmin.normalizeFileSystemPath(path);
        MountTableManager mountTable = this.client.getMountTableManager();
        GetMountTableEntriesRequest request = GetMountTableEntriesRequest.newInstance(path);
        GetMountTableEntriesResponse response = mountTable.getMountTableEntries(request);
        List<MountTable> entries = response.getEntries();
        RouterAdmin.printMounts(entries);
    }

    private static void printMounts(List<MountTable> entries) {
        System.out.println("Mount Table Entries:");
        System.out.println(String.format("%-25s %-25s %-25s %-25s %-25s", "Source", "Destinations", "Owner", "Group", "Mode"));
        for (MountTable entry : entries) {
            StringBuilder destBuilder = new StringBuilder();
            for (RemoteLocation location : entry.getDestinations()) {
                if (destBuilder.length() > 0) {
                    destBuilder.append(",");
                }
                destBuilder.append(String.format("%s->%s", location.getNameserviceId(), location.getDest()));
            }
            System.out.print(String.format("%-25s %-25s", entry.getSourcePath(), destBuilder.toString()));
            System.out.println(String.format(" %-25s %-25s %-25s", entry.getOwnerName(), entry.getGroupName(), entry.getMode()));
        }
    }

    private void manageSafeMode(String cmd) throws IOException {
        if (cmd.equals("enter")) {
            if (this.enterSafeMode()) {
                System.out.println("Successfully enter safe mode.");
            }
        } else if (cmd.equals("leave")) {
            if (this.leaveSafeMode()) {
                System.out.println("Successfully leave safe mode.");
            }
        } else if (cmd.equals("get")) {
            boolean result = this.getSafeMode();
            System.out.println("Safe Mode: " + result);
        }
    }

    private boolean enterSafeMode() throws IOException {
        RouterStateManager stateManager = this.client.getRouterStateManager();
        EnterSafeModeResponse response = stateManager.enterSafeMode(EnterSafeModeRequest.newInstance());
        return response.getStatus();
    }

    private boolean leaveSafeMode() throws IOException {
        RouterStateManager stateManager = this.client.getRouterStateManager();
        LeaveSafeModeResponse response = stateManager.leaveSafeMode(LeaveSafeModeRequest.newInstance());
        return response.getStatus();
    }

    private boolean getSafeMode() throws IOException {
        RouterStateManager stateManager = this.client.getRouterStateManager();
        GetSafeModeResponse response = stateManager.getSafeMode(GetSafeModeRequest.newInstance());
        return response.isInSafeMode();
    }

    private void manageNameservice(String cmd, String nsId) throws IOException {
        if (cmd.equals("enable")) {
            if (this.enableNameservice(nsId)) {
                System.out.println("Successfully enabled nameservice " + nsId);
            } else {
                System.err.println("Cannot enable " + nsId);
            }
        } else if (cmd.equals("disable")) {
            if (this.disableNameservice(nsId)) {
                System.out.println("Successfully disabled nameservice " + nsId);
            } else {
                System.err.println("Cannot disable " + nsId);
            }
        } else {
            throw new IllegalArgumentException("Unknown command: " + cmd);
        }
    }

    private boolean disableNameservice(String nsId) throws IOException {
        NameserviceManager nameserviceManager = this.client.getNameserviceManager();
        DisableNameserviceResponse response = nameserviceManager.disableNameservice(DisableNameserviceRequest.newInstance(nsId));
        return response.getStatus();
    }

    private boolean enableNameservice(String nsId) throws IOException {
        NameserviceManager nameserviceManager = this.client.getNameserviceManager();
        EnableNameserviceResponse response = nameserviceManager.enableNameservice(EnableNameserviceRequest.newInstance(nsId));
        return response.getStatus();
    }

    private void getDisabledNameservices() throws IOException {
        NameserviceManager nameserviceManager = this.client.getNameserviceManager();
        GetDisabledNameservicesRequest request = GetDisabledNameservicesRequest.newInstance();
        GetDisabledNameservicesResponse response = nameserviceManager.getDisabledNameservices(request);
        System.out.println("List of disabled nameservices:");
        for (String nsId : response.getNameservices()) {
            System.out.println(nsId);
        }
    }

    private static String normalizeFileSystemPath(String path) {
        Path normalizedPath = new Path(path);
        return normalizedPath.toString();
    }

    static class ACLEntity {
        private final String owner;
        private final String group;
        private final FsPermission mode;

        ACLEntity(String owner, String group, FsPermission mode) {
            this.owner = owner;
            this.group = group;
            this.mode = mode;
        }

        public String getOwner() {
            return this.owner;
        }

        public String getGroup() {
            return this.group;
        }

        public FsPermission getMode() {
            return this.mode;
        }
    }
}

