/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.metrics;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.server.federation.metrics.FederationRPCMBean;
import org.apache.hadoop.hdfs.server.federation.router.RouterRpcServer;
import org.apache.hadoop.metrics2.MetricsInfo;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.annotation.Metric;
import org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.hadoop.metrics2.impl.MsInfo;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.lib.MetricsRegistry;
import org.apache.hadoop.metrics2.lib.MutableCounterLong;
import org.apache.hadoop.metrics2.lib.MutableRate;

@Metrics(name="RouterRPCActivity", about="Router RPC Activity", context="dfs")
public class FederationRPCMetrics
implements FederationRPCMBean {
    private final MetricsRegistry registry = new MetricsRegistry("router");
    private RouterRpcServer rpcServer;
    @Metric(value={"Time for the router to process an operation internally"})
    private MutableRate processing;
    @Metric(value={"Number of operations the Router processed internally"})
    private MutableCounterLong processingOp;
    @Metric(value={"Time for the Router to proxy an operation to the Namenodes"})
    private MutableRate proxy;
    @Metric(value={"Number of operations the Router proxied to a Namenode"})
    private MutableCounterLong proxyOp;
    @Metric(value={"Number of operations to fail to reach NN"})
    private MutableCounterLong proxyOpFailureStandby;
    @Metric(value={"Number of operations to hit a standby NN"})
    private MutableCounterLong proxyOpFailureCommunicate;
    @Metric(value={"Number of operations to hit a client overloaded Router"})
    private MutableCounterLong proxyOpFailureClientOverloaded;
    @Metric(value={"Number of operations not implemented"})
    private MutableCounterLong proxyOpNotImplemented;
    @Metric(value={"Number of operation retries"})
    private MutableCounterLong proxyOpRetries;
    @Metric(value={"Failed requests due to State Store unavailable"})
    private MutableCounterLong routerFailureStateStore;
    @Metric(value={"Failed requests due to read only mount point"})
    private MutableCounterLong routerFailureReadOnly;
    @Metric(value={"Failed requests due to locked path"})
    private MutableCounterLong routerFailureLocked;
    @Metric(value={"Failed requests due to safe mode"})
    private MutableCounterLong routerFailureSafemode;

    public FederationRPCMetrics(Configuration conf, RouterRpcServer rpcServer) {
        this.rpcServer = rpcServer;
        this.registry.tag((MetricsInfo)MsInfo.SessionId, "RouterRPCSession");
        this.registry.tag((MetricsInfo)MsInfo.ProcessName, "Router");
    }

    public static FederationRPCMetrics create(Configuration conf, RouterRpcServer rpcServer) {
        MetricsSystem ms = DefaultMetricsSystem.instance();
        return (FederationRPCMetrics)ms.register(FederationRPCMetrics.class.getName(), "HDFS Federation RPC Metrics", (Object)new FederationRPCMetrics(conf, rpcServer));
    }

    private static double toMs(double ns) {
        return ns / 1000000.0;
    }

    public static void reset() {
        MetricsSystem ms = DefaultMetricsSystem.instance();
        ms.unregisterSource(FederationRPCMetrics.class.getName());
    }

    public void incrProxyOpFailureStandby() {
        this.proxyOpFailureStandby.incr();
    }

    @Override
    public long getProxyOpFailureStandby() {
        return this.proxyOpFailureStandby.value();
    }

    public void incrProxyOpFailureCommunicate() {
        this.proxyOpFailureCommunicate.incr();
    }

    @Override
    public long getProxyOpFailureCommunicate() {
        return this.proxyOpFailureCommunicate.value();
    }

    public void incrProxyOpFailureClientOverloaded() {
        this.proxyOpFailureClientOverloaded.incr();
    }

    @Override
    public long getProxyOpFailureClientOverloaded() {
        return this.proxyOpFailureClientOverloaded.value();
    }

    public void incrProxyOpNotImplemented() {
        this.proxyOpNotImplemented.incr();
    }

    @Override
    public long getProxyOpNotImplemented() {
        return this.proxyOpNotImplemented.value();
    }

    public void incrProxyOpRetries() {
        this.proxyOpRetries.incr();
    }

    @Override
    public long getProxyOpRetries() {
        return this.proxyOpRetries.value();
    }

    public void incrRouterFailureStateStore() {
        this.routerFailureStateStore.incr();
    }

    @Override
    public long getRouterFailureStateStoreOps() {
        return this.routerFailureStateStore.value();
    }

    public void incrRouterFailureSafemode() {
        this.routerFailureSafemode.incr();
    }

    @Override
    public long getRouterFailureSafemodeOps() {
        return this.routerFailureSafemode.value();
    }

    public void incrRouterFailureReadOnly() {
        this.routerFailureReadOnly.incr();
    }

    @Override
    public long getRouterFailureReadOnlyOps() {
        return this.routerFailureReadOnly.value();
    }

    public void incrRouterFailureLocked() {
        this.routerFailureLocked.incr();
    }

    @Override
    public long getRouterFailureLockedOps() {
        return this.routerFailureLocked.value();
    }

    @Override
    public int getRpcServerCallQueue() {
        return this.rpcServer.getServer().getCallQueueLen();
    }

    @Override
    public int getRpcServerNumOpenConnections() {
        return this.rpcServer.getServer().getNumOpenConnections();
    }

    @Override
    public int getRpcClientNumConnections() {
        return this.rpcServer.getRPCClient().getNumConnections();
    }

    @Override
    public int getRpcClientNumActiveConnections() {
        return this.rpcServer.getRPCClient().getNumActiveConnections();
    }

    @Override
    public int getRpcClientNumCreatingConnections() {
        return this.rpcServer.getRPCClient().getNumCreatingConnections();
    }

    @Override
    public int getRpcClientNumConnectionPools() {
        return this.rpcServer.getRPCClient().getNumConnectionPools();
    }

    @Override
    public String getRpcClientConnections() {
        return this.rpcServer.getRPCClient().getJSON();
    }

    public void addProxyTime(long time) {
        this.proxy.add(time);
        this.proxyOp.incr();
    }

    @Override
    public double getProxyAvg() {
        return FederationRPCMetrics.toMs(this.proxy.lastStat().mean());
    }

    @Override
    public long getProxyOps() {
        return this.proxyOp.value();
    }

    public void addProcessingTime(long time) {
        this.processing.add(time);
        this.processingOp.incr();
    }

    @Override
    public double getProcessingAvg() {
        return FederationRPCMetrics.toMs(this.processing.lastStat().mean());
    }

    @Override
    public long getProcessingOps() {
        return this.processingOp.value();
    }
}

