/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.router;

import org.apache.hadoop.hdfs.NameNodeProxiesClient;
import org.apache.hadoop.hdfs.protocol.ClientProtocol;
import org.apache.hadoop.ipc.RPC;

public class ConnectionContext {
    private final NameNodeProxiesClient.ProxyAndInfo<ClientProtocol> client;
    private int numThreads = 0;
    private boolean closed = false;

    public ConnectionContext(NameNodeProxiesClient.ProxyAndInfo<ClientProtocol> connection) {
        this.client = connection;
    }

    public synchronized boolean isActive() {
        return this.numThreads > 0;
    }

    public synchronized boolean isClosed() {
        return this.closed;
    }

    public synchronized boolean isUsable() {
        return !this.isActive() && !this.isClosed();
    }

    public synchronized NameNodeProxiesClient.ProxyAndInfo<ClientProtocol> getClient() {
        ++this.numThreads;
        return this.client;
    }

    public synchronized void release() {
        if (--this.numThreads == 0 && this.closed) {
            this.close();
        }
    }

    public synchronized void close() {
        this.closed = true;
        if (this.numThreads == 0) {
            ClientProtocol proxy = (ClientProtocol)this.client.getProxy();
            RPC.stopProxy((Object)proxy);
        }
    }
}

