/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.router;

import java.io.PrintStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.server.federation.router.Router;
import org.apache.hadoop.service.CompositeService;
import org.apache.hadoop.util.ExitUtil;
import org.apache.hadoop.util.ShutdownHookManager;
import org.apache.hadoop.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DFSRouter {
    private static final Logger LOG = LoggerFactory.getLogger(DFSRouter.class);
    private static final String USAGE = "Usage: hdfs dfsrouter";
    public static final int SHUTDOWN_HOOK_PRIORITY = 30;

    private DFSRouter() {
    }

    public static void main(String[] argv) {
        if (DFSUtil.parseHelpArgument((String[])argv, (String)USAGE, (PrintStream)System.out, (boolean)true)) {
            System.exit(0);
        }
        try {
            StringUtils.startupShutdownMessage(Router.class, (String[])argv, (Logger)LOG);
            Router router = new Router();
            ShutdownHookManager.get().addShutdownHook((Runnable)new CompositeService.CompositeServiceShutdownHook((CompositeService)router), 30);
            HdfsConfiguration conf = new HdfsConfiguration();
            router.init((Configuration)conf);
            router.start();
        }
        catch (Throwable e) {
            LOG.error("Failed to start router", e);
            ExitUtil.terminate((int)1, (Throwable)e);
        }
    }
}

