/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.router;

import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.fs.QuotaUsage;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.hdfs.server.federation.resolver.RemoteLocation;
import org.apache.hadoop.hdfs.server.federation.router.RemoteMethod;
import org.apache.hadoop.hdfs.server.federation.router.RemoteParam;
import org.apache.hadoop.hdfs.server.federation.router.Router;
import org.apache.hadoop.hdfs.server.federation.router.RouterQuotaManager;
import org.apache.hadoop.hdfs.server.federation.router.RouterRpcClient;
import org.apache.hadoop.hdfs.server.federation.router.RouterRpcServer;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Quota {
    private static final Logger LOG = LoggerFactory.getLogger(Quota.class);
    private final RouterRpcServer rpcServer;
    private final RouterRpcClient rpcClient;
    private final Router router;

    public Quota(Router router, RouterRpcServer server) {
        this.router = router;
        this.rpcServer = server;
        this.rpcClient = server.getRPCClient();
    }

    public void setQuota(String path, long namespaceQuota, long storagespaceQuota, StorageType type) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.WRITE);
        List<RemoteLocation> locations = this.getQuotaRemoteLocations(path);
        if (LOG.isDebugEnabled()) {
            for (RemoteLocation loc : locations) {
                LOG.debug("Set quota for path: nsId: {}, dest: {}.", (Object)loc.getNameserviceId(), (Object)loc.getDest());
            }
        }
        RemoteMethod method = new RemoteMethod("setQuota", new Class[]{String.class, Long.TYPE, Long.TYPE, StorageType.class}, new RemoteParam(), namespaceQuota, storagespaceQuota, type);
        this.rpcClient.invokeConcurrent(locations, method, false, false);
    }

    public QuotaUsage getQuotaUsage(String path) throws IOException {
        List<RemoteLocation> quotaLocs = this.getValidQuotaLocations(path);
        RemoteMethod method = new RemoteMethod("getQuotaUsage", new Class[]{String.class}, new RemoteParam());
        Map<RemoteLocation, QuotaUsage> results = this.rpcClient.invokeConcurrent(quotaLocs, method, true, false, QuotaUsage.class);
        return this.aggregateQuota(results);
    }

    private List<RemoteLocation> getValidQuotaLocations(String path) throws IOException {
        List<RemoteLocation> locations = this.getQuotaRemoteLocations(path);
        HashMap validLocations = new HashMap();
        for (RemoteLocation loc : locations) {
            String nsId = loc.getNameserviceId();
            LinkedList<RemoteLocation> dests = (LinkedList<RemoteLocation>)validLocations.get(nsId);
            if (dests == null) {
                dests = new LinkedList<RemoteLocation>();
                dests.add(loc);
                validLocations.put(nsId, dests);
                continue;
            }
            boolean isChildPath = false;
            for (RemoteLocation d : dests) {
                if (!loc.getDest().startsWith(d.getDest())) continue;
                isChildPath = true;
                break;
            }
            if (isChildPath) continue;
            dests.add(loc);
        }
        LinkedList<RemoteLocation> quotaLocs = new LinkedList<RemoteLocation>();
        for (List locs : validLocations.values()) {
            quotaLocs.addAll(locs);
        }
        return quotaLocs;
    }

    private QuotaUsage aggregateQuota(Map<RemoteLocation, QuotaUsage> results) {
        long nsCount = 0L;
        long ssCount = 0L;
        boolean hasQuotaUnSet = false;
        for (Map.Entry<RemoteLocation, QuotaUsage> entry : results.entrySet()) {
            RemoteLocation loc = entry.getKey();
            QuotaUsage usage = entry.getValue();
            if (usage == null) continue;
            if (usage.getQuota() == -1L && usage.getSpaceQuota() == -1L) {
                hasQuotaUnSet = true;
            }
            nsCount += usage.getFileAndDirectoryCount();
            ssCount += usage.getSpaceConsumed();
            LOG.debug("Get quota usage for path: nsId: {}, dest: {}, nsCount: {}, ssCount: {}.", new Object[]{loc.getNameserviceId(), loc.getDest(), usage.getFileAndDirectoryCount(), usage.getSpaceConsumed()});
        }
        QuotaUsage.Builder builder = new QuotaUsage.Builder().fileAndDirectoryCount(nsCount).spaceConsumed(ssCount);
        if (hasQuotaUnSet) {
            builder.quota(Long.MAX_VALUE);
        }
        return builder.build();
    }

    private List<RemoteLocation> getQuotaRemoteLocations(String path) throws IOException {
        LinkedList<RemoteLocation> locations = new LinkedList<RemoteLocation>();
        RouterQuotaManager manager = this.router.getQuotaManager();
        if (manager != null) {
            Set<String> childrenPaths = manager.getPaths(path);
            for (String childPath : childrenPaths) {
                locations.addAll(this.rpcServer.getLocationsForPath(childPath, true));
            }
        }
        return locations;
    }
}

