/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.router;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.apache.hadoop.hdfs.protocol.ClientProtocol;
import org.apache.hadoop.hdfs.server.federation.router.RemoteLocationContext;
import org.apache.hadoop.hdfs.server.federation.router.RemoteParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteMethod {
    private static final Logger LOG = LoggerFactory.getLogger(RemoteMethod.class);
    private final Object[] params;
    private final Class<?>[] types;
    private final String methodName;

    public RemoteMethod(String method) {
        this.params = null;
        this.types = null;
        this.methodName = method;
    }

    public RemoteMethod(String method, Class<?>[] pTypes, Object ... pParams) throws IOException {
        if (pParams.length != pTypes.length) {
            throw new IOException("Invalid parameters for method " + method);
        }
        this.params = pParams;
        this.types = Arrays.copyOf(pTypes, pTypes.length);
        this.methodName = method;
    }

    public Method getMethod() throws IOException {
        try {
            if (this.types != null) {
                return ClientProtocol.class.getDeclaredMethod(this.methodName, this.types);
            }
            return ClientProtocol.class.getDeclaredMethod(this.methodName, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            LOG.error("Cannot get method {} with types {}", new Object[]{this.methodName, Arrays.toString(this.types), e});
            throw new IOException(e);
        }
        catch (SecurityException e) {
            LOG.error("Cannot access method {} with types {}", new Object[]{this.methodName, Arrays.toString(this.types), e});
            throw new IOException(e);
        }
    }

    public Class<?>[] getTypes() {
        return Arrays.copyOf(this.types, this.types.length);
    }

    public Object[] getParams() {
        return this.getParams(null);
    }

    public String getMethodName() {
        return this.methodName;
    }

    public Object[] getParams(RemoteLocationContext context) {
        if (this.params == null) {
            return new Object[0];
        }
        Object[] objList = new Object[this.params.length];
        for (int i = 0; i < this.params.length; ++i) {
            Object currentObj = this.params[i];
            if (currentObj instanceof RemoteParam) {
                RemoteParam paramGetter = (RemoteParam)currentObj;
                objList[i] = paramGetter.getParameterForContext(context);
                continue;
            }
            objList[i] = currentObj;
        }
        return objList;
    }
}

