/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.router;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.SocketFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.protocolPB.RouterAdminProtocolPB;
import org.apache.hadoop.hdfs.protocolPB.RouterAdminProtocolTranslatorPB;
import org.apache.hadoop.hdfs.server.federation.resolver.MountTableManager;
import org.apache.hadoop.hdfs.server.federation.router.RouterStateManager;
import org.apache.hadoop.ipc.ProtobufRpcEngine;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.UserGroupInformation;

@InterfaceAudience.Private
public class RouterClient
implements Closeable {
    private final RouterAdminProtocolTranslatorPB proxy;
    private final UserGroupInformation ugi = UserGroupInformation.getCurrentUser();

    private static RouterAdminProtocolTranslatorPB createRouterProxy(InetSocketAddress address, Configuration conf, UserGroupInformation ugi) throws IOException {
        RPC.setProtocolEngine((Configuration)conf, RouterAdminProtocolPB.class, ProtobufRpcEngine.class);
        AtomicBoolean fallbackToSimpleAuth = new AtomicBoolean(false);
        long version = RPC.getProtocolVersion(RouterAdminProtocolPB.class);
        RouterAdminProtocolPB proxy = (RouterAdminProtocolPB)RPC.getProtocolProxy(RouterAdminProtocolPB.class, (long)version, (InetSocketAddress)address, (UserGroupInformation)ugi, (Configuration)conf, (SocketFactory)NetUtils.getDefaultSocketFactory((Configuration)conf), (int)RPC.getRpcTimeout((Configuration)conf), null, (AtomicBoolean)fallbackToSimpleAuth).getProxy();
        return new RouterAdminProtocolTranslatorPB(proxy);
    }

    public RouterClient(InetSocketAddress address, Configuration conf) throws IOException {
        this.proxy = RouterClient.createRouterProxy(address, conf, this.ugi);
    }

    public MountTableManager getMountTableManager() {
        return this.proxy;
    }

    public RouterStateManager getRouterStateManager() {
        return this.proxy;
    }

    @Override
    public synchronized void close() throws IOException {
        RPC.stopProxy((Object)this.proxy);
    }
}

