/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.router;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.server.federation.store.records.MountTable;
import org.apache.hadoop.hdfs.server.namenode.FSPermissionChecker;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;

public class RouterPermissionChecker
extends FSPermissionChecker {
    static final Log LOG = LogFactory.getLog(RouterPermissionChecker.class);
    public static final short MOUNT_TABLE_PERMISSION_DEFAULT = 493;

    public RouterPermissionChecker(String routerOwner, String supergroup, UserGroupInformation callerUgi) {
        super(routerOwner, supergroup, callerUgi, null);
    }

    public void checkPermission(MountTable mountTable, FsAction access) throws AccessControlException {
        if (this.isSuperUser()) {
            return;
        }
        FsPermission mode = mountTable.getMode();
        if (this.getUser().equals(mountTable.getOwnerName()) && mode.getUserAction().implies(access)) {
            return;
        }
        if (this.isMemberOfGroup(mountTable.getGroupName()) && mode.getGroupAction().implies(access)) {
            return;
        }
        if (!this.getUser().equals(mountTable.getOwnerName()) && !this.isMemberOfGroup(mountTable.getGroupName()) && mode.getOtherAction().implies(access)) {
            return;
        }
        throw new AccessControlException("Permission denied while accessing mount table " + mountTable.getSourcePath() + ": user " + this.getUser() + " does not have " + access.toString() + " permissions.");
    }
}

