/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.router;

import org.apache.hadoop.fs.QuotaUsage;
import org.apache.hadoop.hdfs.protocol.DSQuotaExceededException;
import org.apache.hadoop.hdfs.protocol.NSQuotaExceededException;
import org.apache.hadoop.hdfs.server.namenode.Quota;
import org.apache.hadoop.util.StringUtils;

public final class RouterQuotaUsage
extends QuotaUsage {
    public static final long QUOTA_USAGE_COUNT_DEFAULT = 0L;

    private RouterQuotaUsage(Builder builder) {
        super((QuotaUsage.Builder)builder);
    }

    public void verifyNamespaceQuota() throws NSQuotaExceededException {
        if (Quota.isViolated((long)this.getQuota(), (long)this.getFileAndDirectoryCount())) {
            throw new NSQuotaExceededException(this.getQuota(), this.getFileAndDirectoryCount());
        }
    }

    public void verifyStoragespaceQuota() throws DSQuotaExceededException {
        if (Quota.isViolated((long)this.getSpaceQuota(), (long)this.getSpaceConsumed())) {
            throw new DSQuotaExceededException(this.getSpaceQuota(), this.getSpaceConsumed());
        }
    }

    public String toString() {
        String nsQuota = String.valueOf(this.getQuota());
        String nsCount = String.valueOf(this.getFileAndDirectoryCount());
        if (this.getQuota() == Long.MAX_VALUE) {
            nsQuota = "-";
            nsCount = "-";
        }
        String ssQuota = StringUtils.byteDesc((long)this.getSpaceQuota());
        String ssCount = StringUtils.byteDesc((long)this.getSpaceConsumed());
        if (this.getSpaceQuota() == Long.MAX_VALUE) {
            ssQuota = "-";
            ssCount = "-";
        }
        StringBuilder str = new StringBuilder();
        str.append("[NsQuota: ").append(nsQuota).append("/").append(nsCount);
        str.append(", SsQuota: ").append(ssQuota).append("/").append(ssCount).append("]");
        return str.toString();
    }

    public static class Builder
    extends QuotaUsage.Builder {
        public RouterQuotaUsage build() {
            return new RouterQuotaUsage(this);
        }

        public Builder fileAndDirectoryCount(long count) {
            super.fileAndDirectoryCount(count);
            return this;
        }

        public Builder quota(long quota) {
            super.quota(quota);
            return this;
        }

        public Builder spaceConsumed(long spaceConsumed) {
            super.spaceConsumed(spaceConsumed);
            return this;
        }

        public Builder spaceQuota(long spaceQuota) {
            super.spaceQuota(spaceQuota);
            return this;
        }
    }
}

