/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.store;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.server.federation.metrics.StateStoreMBean;
import org.apache.hadoop.hdfs.server.federation.metrics.StateStoreMetrics;
import org.apache.hadoop.hdfs.server.federation.router.RBFConfigKeys;
import org.apache.hadoop.hdfs.server.federation.store.RecordStore;
import org.apache.hadoop.hdfs.server.federation.store.StateStoreCache;
import org.apache.hadoop.hdfs.server.federation.store.StateStoreCacheUpdateService;
import org.apache.hadoop.hdfs.server.federation.store.StateStoreConnectionMonitorService;
import org.apache.hadoop.hdfs.server.federation.store.driver.StateStoreDriver;
import org.apache.hadoop.hdfs.server.federation.store.impl.MembershipStoreImpl;
import org.apache.hadoop.hdfs.server.federation.store.impl.MountTableStoreImpl;
import org.apache.hadoop.hdfs.server.federation.store.impl.RouterStoreImpl;
import org.apache.hadoop.hdfs.server.federation.store.records.BaseRecord;
import org.apache.hadoop.hdfs.server.federation.store.records.MembershipState;
import org.apache.hadoop.hdfs.server.federation.store.records.RouterState;
import org.apache.hadoop.metrics2.MetricsException;
import org.apache.hadoop.metrics2.util.MBeans;
import org.apache.hadoop.service.CompositeService;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class StateStoreService
extends CompositeService {
    private static final Logger LOG = LoggerFactory.getLogger(StateStoreService.class);
    private Configuration conf;
    private String identifier;
    private StateStoreDriver driver;
    private StateStoreConnectionMonitorService monitorService;
    private StateStoreMetrics metrics;
    private final Map<Class<? extends BaseRecord>, RecordStore<? extends BaseRecord>> recordStores = new HashMap<Class<? extends BaseRecord>, RecordStore<? extends BaseRecord>>();
    private StateStoreCacheUpdateService cacheUpdater;
    private long cacheLastUpdateTime;
    private final List<StateStoreCache> cachesToUpdateInternal = new ArrayList<StateStoreCache>();
    private final List<StateStoreCache> cachesToUpdateExternal = new ArrayList<StateStoreCache>();

    public StateStoreService() {
        super(StateStoreService.class.getName());
    }

    protected void serviceInit(Configuration config) throws Exception {
        this.conf = config;
        Class driverClass = this.conf.getClass("dfs.federation.router.store.driver.class", RBFConfigKeys.FEDERATION_STORE_DRIVER_CLASS_DEFAULT, StateStoreDriver.class);
        this.driver = (StateStoreDriver)ReflectionUtils.newInstance((Class)driverClass, (Configuration)this.conf);
        if (this.driver == null) {
            throw new IOException("Cannot create driver for the State Store");
        }
        this.addRecordStore(MembershipStoreImpl.class);
        this.addRecordStore(MountTableStoreImpl.class);
        this.addRecordStore(RouterStoreImpl.class);
        this.monitorService = new StateStoreConnectionMonitorService(this);
        this.addService((Service)this.monitorService);
        MembershipState.setExpirationMs(this.conf.getLong("dfs.federation.router.store.membership.expiration", RBFConfigKeys.FEDERATION_STORE_MEMBERSHIP_EXPIRATION_MS_DEFAULT));
        RouterState.setExpirationMs(this.conf.getTimeDuration("dfs.federation.router.store.router.expiration", RBFConfigKeys.FEDERATION_STORE_ROUTER_EXPIRATION_MS_DEFAULT, TimeUnit.MILLISECONDS));
        this.cacheUpdater = new StateStoreCacheUpdateService(this);
        this.addService((Service)this.cacheUpdater);
        this.metrics = StateStoreMetrics.create(this.conf);
        try {
            StandardMBean bean = new StandardMBean(this.metrics, StateStoreMBean.class);
            ObjectName registeredObject = MBeans.register((String)"Router", (String)"StateStore", (Object)bean);
            LOG.info("Registered StateStoreMBean: {}", (Object)registeredObject);
        }
        catch (NotCompliantMBeanException e) {
            throw new RuntimeException("Bad StateStoreMBean setup", e);
        }
        catch (MetricsException e) {
            LOG.info("Failed to register State Store bean {}", (Object)e.getMessage());
        }
        super.serviceInit(this.conf);
    }

    protected void serviceStart() throws Exception {
        this.loadDriver();
        super.serviceStart();
    }

    protected void serviceStop() throws Exception {
        this.closeDriver();
        if (this.metrics != null) {
            this.metrics.shutdown();
            this.metrics = null;
        }
        super.serviceStop();
    }

    private <T extends RecordStore<?>> void addRecordStore(Class<T> clazz) throws ReflectiveOperationException {
        assert (this.getServiceState() == Service.STATE.INITED) : "Cannot add record to the State Store once started";
        T recordStore = RecordStore.newInstance(clazz, this.getDriver());
        Class<?> recordClass = ((RecordStore)recordStore).getRecordClass();
        this.recordStores.put((Class<? extends BaseRecord>)recordClass, (RecordStore<? extends BaseRecord>)recordStore);
        if (recordStore instanceof StateStoreCache) {
            StateStoreCache cachedRecordStore = (StateStoreCache)recordStore;
            this.cachesToUpdateInternal.add(cachedRecordStore);
        }
    }

    public <T extends RecordStore<?>> T getRegisteredRecordStore(Class<T> recordStoreClass) {
        for (RecordStore<? extends BaseRecord> recordStore : this.recordStores.values()) {
            if (!recordStoreClass.isInstance(recordStore)) continue;
            RecordStore<? extends BaseRecord> recordStoreChecked = recordStore;
            return (T)recordStoreChecked;
        }
        return null;
    }

    public Collection<Class<? extends BaseRecord>> getSupportedRecords() {
        return this.recordStores.keySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadDriver() {
        StateStoreDriver stateStoreDriver = this.driver;
        synchronized (stateStoreDriver) {
            if (!this.isDriverReady()) {
                String driverName = this.driver.getClass().getSimpleName();
                if (this.driver.init(this.conf, this.getIdentifier(), this.getSupportedRecords(), this.metrics)) {
                    LOG.info("Connection to the State Store driver {} is open and ready", (Object)driverName);
                    this.refreshCaches();
                } else {
                    LOG.error("Cannot initialize State Store driver {}", (Object)driverName);
                }
            }
        }
    }

    public boolean isDriverReady() {
        return this.driver.isDriverReady();
    }

    @VisibleForTesting
    public void closeDriver() throws Exception {
        if (this.driver != null) {
            this.driver.close();
        }
    }

    public StateStoreDriver getDriver() {
        return this.driver;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(String id) {
        this.identifier = id;
    }

    public long getCacheUpdateTime() {
        return this.cacheLastUpdateTime;
    }

    @VisibleForTesting
    public void stopCacheUpdateService() {
        if (this.cacheUpdater != null) {
            this.cacheUpdater.stop();
            this.removeService((Service)this.cacheUpdater);
            this.cacheUpdater = null;
        }
    }

    public void registerCacheExternal(StateStoreCache client) {
        this.cachesToUpdateExternal.add(client);
    }

    public void refreshCaches() {
        this.refreshCaches(false);
    }

    public void refreshCaches(boolean force) {
        boolean success = true;
        if (this.isDriverReady()) {
            LinkedList<StateStoreCache> cachesToUpdate = new LinkedList<StateStoreCache>();
            cachesToUpdate.addAll(this.cachesToUpdateInternal);
            cachesToUpdate.addAll(this.cachesToUpdateExternal);
            for (StateStoreCache cachedStore : cachesToUpdate) {
                String cacheName = cachedStore.getClass().getSimpleName();
                boolean result = false;
                try {
                    result = cachedStore.loadCache(force);
                }
                catch (IOException e) {
                    LOG.error("Error updating cache for {}", (Object)cacheName, (Object)e);
                    result = false;
                }
                if (result) continue;
                success = false;
                LOG.error("Cache update failed for cache {}", (Object)cacheName);
            }
        } else {
            success = false;
            LOG.info("Skipping State Store cache update, driver is not ready.");
        }
        if (success) {
            this.cacheLastUpdateTime = Time.now();
        }
    }

    public boolean loadCache(Class<?> clazz) throws IOException {
        return this.loadCache(clazz, false);
    }

    public boolean loadCache(Class<?> clazz, boolean force) throws IOException {
        LinkedList<StateStoreCache> cachesToUpdate = new LinkedList<StateStoreCache>();
        cachesToUpdate.addAll(this.cachesToUpdateInternal);
        cachesToUpdate.addAll(this.cachesToUpdateExternal);
        for (StateStoreCache cachedStore : cachesToUpdate) {
            if (!clazz.isInstance(cachedStore)) continue;
            return cachedStore.loadCache(force);
        }
        throw new IOException("Registered cache was not found for " + clazz);
    }

    public StateStoreMetrics getMetrics() {
        return this.metrics;
    }
}

