/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.metrics;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ha.HAServiceProtocol;
import org.apache.hadoop.hdfs.DFSUtilClient;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.protocol.RollingUpgradeInfo;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.federation.metrics.FederationMetrics;
import org.apache.hadoop.hdfs.server.federation.resolver.FederationNamespaceInfo;
import org.apache.hadoop.hdfs.server.federation.router.Router;
import org.apache.hadoop.hdfs.server.federation.router.RouterRpcServer;
import org.apache.hadoop.hdfs.server.federation.router.SubClusterTimeoutException;
import org.apache.hadoop.hdfs.server.federation.store.MembershipStore;
import org.apache.hadoop.hdfs.server.federation.store.StateStoreService;
import org.apache.hadoop.hdfs.server.federation.store.protocol.GetNamespaceInfoRequest;
import org.apache.hadoop.hdfs.server.federation.store.protocol.GetNamespaceInfoResponse;
import org.apache.hadoop.hdfs.server.namenode.NameNodeMXBean;
import org.apache.hadoop.hdfs.server.namenode.NameNodeStatusMXBean;
import org.apache.hadoop.hdfs.server.namenode.metrics.FSNamesystemMBean;
import org.apache.hadoop.ipc.StandbyException;
import org.apache.hadoop.metrics2.util.MBeans;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.util.Time;
import org.apache.hadoop.util.VersionInfo;
import org.eclipse.jetty.util.ajax.JSON;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NamenodeBeanMetrics
implements FSNamesystemMBean,
NameNodeMXBean,
NameNodeStatusMXBean {
    private static final Logger LOG = LoggerFactory.getLogger(NamenodeBeanMetrics.class);
    private static final String DN_REPORT_TIME_OUT = "dfs.federation.router.dn-report.time-out";
    private static final long DN_REPORT_TIME_OUT_DEFAULT = TimeUnit.SECONDS.toMillis(1L);
    public static final String DN_REPORT_CACHE_EXPIRE = "dfs.federation.router.dn-report.cache-expire";
    public static final long DN_REPORT_CACHE_EXPIRE_DEFAULT = TimeUnit.SECONDS.toMillis(10L);
    private final Router router;
    private ObjectName fsBeanName;
    private ObjectName fsStateBeanName;
    private ObjectName nnInfoBeanName;
    private ObjectName nnStatusBeanName;
    private final long dnReportTimeOut;
    private final LoadingCache<HdfsConstants.DatanodeReportType, String> dnCache;

    public NamenodeBeanMetrics(Router router) {
        StandardMBean bean;
        this.router = router;
        try {
            bean = new StandardMBean(this, FSNamesystemMBean.class);
            this.fsBeanName = MBeans.register((String)"NameNode", (String)"FSNamesystem", (Object)bean);
            LOG.info("Registered FSNamesystem MBean: {}", (Object)this.fsBeanName);
        }
        catch (NotCompliantMBeanException e) {
            throw new RuntimeException("Bad FSNamesystem MBean setup", e);
        }
        try {
            bean = new StandardMBean(this, FSNamesystemMBean.class);
            this.fsStateBeanName = MBeans.register((String)"NameNode", (String)"FSNamesystemState", (Object)bean);
            LOG.info("Registered FSNamesystemState MBean: {}", (Object)this.fsStateBeanName);
        }
        catch (NotCompliantMBeanException e) {
            throw new RuntimeException("Bad FSNamesystemState MBean setup", e);
        }
        try {
            bean = new StandardMBean(this, NameNodeMXBean.class);
            this.nnInfoBeanName = MBeans.register((String)"NameNode", (String)"NameNodeInfo", (Object)bean);
            LOG.info("Registered NameNodeInfo MBean: {}", (Object)this.nnInfoBeanName);
        }
        catch (NotCompliantMBeanException e) {
            throw new RuntimeException("Bad NameNodeInfo MBean setup", e);
        }
        try {
            bean = new StandardMBean(this, NameNodeStatusMXBean.class);
            this.nnStatusBeanName = MBeans.register((String)"NameNode", (String)"NameNodeStatus", (Object)bean);
            LOG.info("Registered NameNodeStatus MBean: {}", (Object)this.nnStatusBeanName);
        }
        catch (NotCompliantMBeanException e) {
            throw new RuntimeException("Bad NameNodeStatus MBean setup", e);
        }
        Configuration conf = router.getConfig();
        this.dnReportTimeOut = conf.getTimeDuration(DN_REPORT_TIME_OUT, DN_REPORT_TIME_OUT_DEFAULT, TimeUnit.MILLISECONDS);
        long dnCacheExpire = conf.getTimeDuration(DN_REPORT_CACHE_EXPIRE, DN_REPORT_CACHE_EXPIRE_DEFAULT, TimeUnit.MILLISECONDS);
        this.dnCache = CacheBuilder.newBuilder().expireAfterWrite(dnCacheExpire, TimeUnit.MILLISECONDS).build((CacheLoader)new CacheLoader<HdfsConstants.DatanodeReportType, String>(){

            public String load(HdfsConstants.DatanodeReportType type) throws Exception {
                return NamenodeBeanMetrics.this.getNodesImpl(type);
            }
        });
    }

    public void close() {
        if (this.fsStateBeanName != null) {
            MBeans.unregister((ObjectName)this.fsStateBeanName);
            this.fsStateBeanName = null;
        }
        if (this.nnInfoBeanName != null) {
            MBeans.unregister((ObjectName)this.nnInfoBeanName);
            this.nnInfoBeanName = null;
        }
        if (this.nnStatusBeanName != null) {
            MBeans.unregister((ObjectName)this.nnStatusBeanName);
            this.nnStatusBeanName = null;
        }
    }

    private FederationMetrics getFederationMetrics() {
        return this.router.getMetrics();
    }

    public String getVersion() {
        return VersionInfo.getVersion() + ", r" + VersionInfo.getRevision();
    }

    public String getSoftwareVersion() {
        return VersionInfo.getVersion();
    }

    public long getUsed() {
        return this.getFederationMetrics().getUsedCapacity();
    }

    public long getFree() {
        return this.getFederationMetrics().getRemainingCapacity();
    }

    public long getTotal() {
        return this.getFederationMetrics().getTotalCapacity();
    }

    public long getProvidedCapacity() {
        return this.getFederationMetrics().getProvidedSpace();
    }

    public String getSafemode() {
        return "";
    }

    public boolean isUpgradeFinalized() {
        return true;
    }

    public RollingUpgradeInfo.Bean getRollingUpgradeStatus() {
        return null;
    }

    public long getNonDfsUsedSpace() {
        return 0L;
    }

    public float getPercentUsed() {
        return DFSUtilClient.getPercentUsed((long)this.getCapacityUsed(), (long)this.getCapacityTotal());
    }

    public float getPercentRemaining() {
        return DFSUtilClient.getPercentUsed((long)this.getCapacityRemaining(), (long)this.getCapacityTotal());
    }

    public long getCacheUsed() {
        return 0L;
    }

    public long getCacheCapacity() {
        return 0L;
    }

    public long getBlockPoolUsedSpace() {
        return 0L;
    }

    public float getPercentBlockPoolUsed() {
        return 0.0f;
    }

    public long getTotalBlocks() {
        return this.getFederationMetrics().getNumBlocks();
    }

    public long getNumberOfMissingBlocks() {
        return this.getFederationMetrics().getNumOfMissingBlocks();
    }

    @Deprecated
    public long getPendingReplicationBlocks() {
        return this.getFederationMetrics().getNumOfBlocksPendingReplication();
    }

    public long getPendingReconstructionBlocks() {
        return this.getFederationMetrics().getNumOfBlocksPendingReplication();
    }

    @Deprecated
    public long getUnderReplicatedBlocks() {
        return this.getFederationMetrics().getNumOfBlocksUnderReplicated();
    }

    public long getLowRedundancyBlocks() {
        return this.getFederationMetrics().getNumOfBlocksUnderReplicated();
    }

    public long getPendingDeletionBlocks() {
        return this.getFederationMetrics().getNumOfBlocksPendingDeletion();
    }

    public long getScheduledReplicationBlocks() {
        return -1L;
    }

    public long getNumberOfMissingBlocksWithReplicationFactorOne() {
        return 0L;
    }

    public String getCorruptFiles() {
        return "N/A";
    }

    public int getThreads() {
        return ManagementFactory.getThreadMXBean().getThreadCount();
    }

    public String getLiveNodes() {
        return this.getNodes(HdfsConstants.DatanodeReportType.LIVE);
    }

    public String getDeadNodes() {
        return this.getNodes(HdfsConstants.DatanodeReportType.DEAD);
    }

    public String getDecomNodes() {
        return this.getNodes(HdfsConstants.DatanodeReportType.DECOMMISSIONING);
    }

    private String getNodes(HdfsConstants.DatanodeReportType type) {
        try {
            return (String)this.dnCache.get((Object)type);
        }
        catch (ExecutionException e) {
            LOG.error("Cannot get the DN storage report for {}", (Object)type, (Object)e);
            return "{}";
        }
    }

    private String getNodesImpl(HdfsConstants.DatanodeReportType type) {
        HashMap info = new HashMap();
        try {
            DatanodeInfo[] datanodes;
            RouterRpcServer rpcServer = this.router.getRpcServer();
            for (DatanodeInfo node : datanodes = rpcServer.getDatanodeReport(type, false, this.dnReportTimeOut)) {
                HashMap<String, Object> innerinfo = new HashMap<String, Object>();
                innerinfo.put("infoAddr", node.getInfoAddr());
                innerinfo.put("infoSecureAddr", node.getInfoSecureAddr());
                innerinfo.put("xferaddr", node.getXferAddr());
                innerinfo.put("location", node.getNetworkLocation());
                innerinfo.put("lastContact", this.getLastContact(node));
                innerinfo.put("usedSpace", node.getDfsUsed());
                innerinfo.put("adminState", node.getAdminState().toString());
                innerinfo.put("nonDfsUsedSpace", node.getNonDfsUsed());
                innerinfo.put("capacity", node.getCapacity());
                innerinfo.put("numBlocks", -1);
                innerinfo.put("version", node.getSoftwareVersion() == null ? "UNKNOWN" : node.getSoftwareVersion());
                innerinfo.put("used", node.getDfsUsed());
                innerinfo.put("remaining", node.getRemaining());
                innerinfo.put("blockScheduled", -1);
                innerinfo.put("blockPoolUsed", node.getBlockPoolUsed());
                innerinfo.put("blockPoolUsedPercent", Float.valueOf(node.getBlockPoolUsedPercent()));
                innerinfo.put("volfails", -1);
                info.put(node.getHostName() + ":" + node.getXferPort(), Collections.unmodifiableMap(innerinfo));
            }
        }
        catch (StandbyException e) {
            LOG.error("Cannot get {} nodes, Router in safe mode", (Object)type);
        }
        catch (SubClusterTimeoutException e) {
            LOG.error("Cannot get {} nodes, subclusters timed out responding", (Object)type);
        }
        catch (IOException e) {
            LOG.error("Cannot get " + type + " nodes", (Throwable)e);
        }
        return JSON.toString(info);
    }

    public String getClusterId() {
        try {
            return this.getNamespaceInfo(FederationNamespaceInfo::getClusterId).toString();
        }
        catch (IOException e) {
            LOG.error("Cannot fetch cluster ID metrics {}", (Object)e.getMessage());
            return "";
        }
    }

    public String getBlockPoolId() {
        try {
            return this.getNamespaceInfo(FederationNamespaceInfo::getBlockPoolId).toString();
        }
        catch (IOException e) {
            LOG.error("Cannot fetch block pool ID metrics {}", (Object)e.getMessage());
            return "";
        }
    }

    private Collection<String> getNamespaceInfo(Function<FederationNamespaceInfo, String> f) throws IOException {
        StateStoreService stateStore = this.router.getStateStore();
        MembershipStore membershipStore = stateStore.getRegisteredRecordStore(MembershipStore.class);
        GetNamespaceInfoRequest request = GetNamespaceInfoRequest.newInstance();
        GetNamespaceInfoResponse response = membershipStore.getNamespaceInfo(request);
        return response.getNamespaceInfo().stream().map(f).collect(Collectors.toSet());
    }

    public String getNameDirStatuses() {
        return "N/A";
    }

    public String getNodeUsage() {
        return "N/A";
    }

    public String getNameJournalStatus() {
        return "N/A";
    }

    public String getJournalTransactionInfo() {
        return "N/A";
    }

    public long getNNStartedTimeInMillis() {
        return this.router.getStartTime();
    }

    public String getCompileInfo() {
        return VersionInfo.getDate() + " by " + VersionInfo.getUser() + " from " + VersionInfo.getBranch();
    }

    public int getDistinctVersionCount() {
        return 0;
    }

    public Map<String, Integer> getDistinctVersions() {
        return null;
    }

    public String getFSState() {
        return "Operational";
    }

    public long getBlocksTotal() {
        return this.getTotalBlocks();
    }

    public long getCapacityTotal() {
        return this.getTotal();
    }

    public long getCapacityRemaining() {
        return this.getFree();
    }

    public long getCapacityUsed() {
        return this.getUsed();
    }

    public long getProvidedCapacityTotal() {
        return this.getProvidedCapacity();
    }

    public long getFilesTotal() {
        return this.getFederationMetrics().getNumFiles();
    }

    public int getTotalLoad() {
        return -1;
    }

    public int getNumLiveDataNodes() {
        return this.router.getMetrics().getNumLiveNodes();
    }

    public int getNumDeadDataNodes() {
        return this.router.getMetrics().getNumDeadNodes();
    }

    public int getNumStaleDataNodes() {
        return -1;
    }

    public int getNumDecomLiveDataNodes() {
        return this.router.getMetrics().getNumDecomLiveNodes();
    }

    public int getNumDecomDeadDataNodes() {
        return this.router.getMetrics().getNumDecomDeadNodes();
    }

    public int getNumDecommissioningDataNodes() {
        return this.router.getMetrics().getNumDecommissioningNodes();
    }

    public int getNumInMaintenanceLiveDataNodes() {
        return 0;
    }

    public int getNumInMaintenanceDeadDataNodes() {
        return 0;
    }

    public int getNumEnteringMaintenanceDataNodes() {
        return 0;
    }

    public int getVolumeFailuresTotal() {
        return 0;
    }

    public long getEstimatedCapacityLostTotal() {
        return 0L;
    }

    public String getSnapshotStats() {
        return null;
    }

    public long getMaxObjects() {
        return 0L;
    }

    public long getBlockDeletionStartTime() {
        return -1L;
    }

    public int getNumStaleStorages() {
        return -1;
    }

    public String getTopUserOpCounts() {
        return "N/A";
    }

    public int getFsLockQueueLength() {
        return 0;
    }

    public long getTotalSyncCount() {
        return 0L;
    }

    public String getTotalSyncTimes() {
        return "";
    }

    private long getLastContact(DatanodeInfo node) {
        return (Time.now() - node.getLastUpdate()) / 1000L;
    }

    public String getNNRole() {
        return HdfsServerConstants.NamenodeRole.NAMENODE.toString();
    }

    public String getState() {
        return HAServiceProtocol.HAServiceState.ACTIVE.toString();
    }

    public String getHostAndPort() {
        return NetUtils.getHostPortString((InetSocketAddress)this.router.getRpcServerAddress());
    }

    public boolean isSecurityEnabled() {
        return false;
    }

    public long getLastHATransitionTime() {
        return 0L;
    }

    public long getBytesWithFutureGenerationStamps() {
        return 0L;
    }

    public String getSlowPeersReport() {
        return "N/A";
    }

    public String getSlowDisksReport() {
        return "N/A";
    }

    public long getNumberOfSnapshottableDirs() {
        return 0L;
    }

    public String getEnteringMaintenanceNodes() {
        return "N/A";
    }

    public String getNameDirSize() {
        return "N/A";
    }

    public int getNumEncryptionZones() {
        return 0;
    }
}

