/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.router;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.net.URLConnection;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.server.federation.resolver.ActiveNamenodeResolver;
import org.apache.hadoop.hdfs.server.federation.resolver.FileSubclusterResolver;
import org.apache.hadoop.hdfs.server.federation.router.RBFConfigKeys;
import org.apache.hadoop.hdfs.server.federation.router.Router;
import org.apache.hadoop.hdfs.server.federation.store.StateStoreService;
import org.apache.hadoop.util.VersionInfo;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FederationUtil {
    private static final Logger LOG = LoggerFactory.getLogger(FederationUtil.class);

    private FederationUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JSONArray getJmx(String beanQuery, String webAddress) {
        JSONArray ret = null;
        BufferedReader reader = null;
        try {
            String host = webAddress;
            int port = -1;
            if (webAddress.indexOf(":") > 0) {
                String[] webAddressSplit = webAddress.split(":");
                host = webAddressSplit[0];
                port = Integer.parseInt(webAddressSplit[1]);
            }
            URL jmxURL = new URL("http", host, port, "/jmx?qry=" + beanQuery);
            URLConnection conn = jmxURL.openConnection();
            conn.setConnectTimeout(5000);
            conn.setReadTimeout(5000);
            InputStream in = conn.getInputStream();
            InputStreamReader isr = new InputStreamReader(in, "UTF-8");
            reader = new BufferedReader(isr);
            StringBuilder sb = new StringBuilder();
            String line = null;
            while ((line = reader.readLine()) != null) {
                sb.append(line);
            }
            String jmxOutput = sb.toString();
            JSONObject json = new JSONObject(jmxOutput);
            ret = json.getJSONArray("beans");
        }
        catch (IOException e) {
            LOG.error("Cannot read JMX bean {} from server {}: {}", new Object[]{beanQuery, webAddress, e.getMessage()});
        }
        catch (JSONException e) {
            LOG.error("Cannot parse JMX output for {} from server {}: {}", new Object[]{beanQuery, webAddress, e.getMessage()});
        }
        catch (Exception e) {
            LOG.error("Cannot parse JMX output for {} from server {}: {}", new Object[]{beanQuery, webAddress, e});
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    LOG.error("Problem closing {}", (Object)webAddress, (Object)e);
                }
            }
        }
        return ret;
    }

    public static String getVersion() {
        return VersionInfo.getVersion();
    }

    public static String getCompileInfo() {
        return VersionInfo.getDate() + " by " + VersionInfo.getUser() + " from " + VersionInfo.getBranch();
    }

    private static <T, R> T newInstance(Configuration conf, R context, Class<R> contextClass, Class<T> clazz) {
        try {
            if (contextClass == null) {
                Constructor<T> constructor = clazz.getConstructor(new Class[0]);
                return constructor.newInstance(new Object[0]);
            }
            Constructor<T> constructor = clazz.getConstructor(Configuration.class, contextClass);
            return constructor.newInstance(conf, context);
        }
        catch (ReflectiveOperationException e) {
            LOG.error("Could not instantiate: {}", (Object)clazz.getSimpleName(), (Object)e);
            return null;
        }
    }

    public static FileSubclusterResolver newFileSubclusterResolver(Configuration conf, Router router) {
        Class clazz = conf.getClass("dfs.federation.router.file.resolver.client.class", RBFConfigKeys.FEDERATION_FILE_RESOLVER_CLIENT_CLASS_DEFAULT, FileSubclusterResolver.class);
        return (FileSubclusterResolver)FederationUtil.newInstance(conf, router, Router.class, clazz);
    }

    public static ActiveNamenodeResolver newActiveNamenodeResolver(Configuration conf, StateStoreService stateStore) {
        Class clazz = conf.getClass("dfs.federation.router.namenode.resolver.client.class", RBFConfigKeys.FEDERATION_NAMENODE_RESOLVER_CLIENT_CLASS_DEFAULT, ActiveNamenodeResolver.class);
        return (ActiveNamenodeResolver)FederationUtil.newInstance(conf, stateStore, StateStoreService.class, clazz);
    }

    public static boolean isParentEntry(String path, String parent) {
        if (!path.startsWith(parent)) {
            return false;
        }
        if (path.equals(parent)) {
            return true;
        }
        return path.charAt(parent.length()) == '/' || parent.equals("/");
    }
}

