/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.router;

import java.io.IOException;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.QuotaUsage;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.server.federation.router.PeriodicService;
import org.apache.hadoop.hdfs.server.federation.router.Router;
import org.apache.hadoop.hdfs.server.federation.router.RouterQuotaManager;
import org.apache.hadoop.hdfs.server.federation.router.RouterQuotaUsage;
import org.apache.hadoop.hdfs.server.federation.router.RouterRpcServer;
import org.apache.hadoop.hdfs.server.federation.store.MountTableStore;
import org.apache.hadoop.hdfs.server.federation.store.protocol.GetMountTableEntriesRequest;
import org.apache.hadoop.hdfs.server.federation.store.protocol.GetMountTableEntriesResponse;
import org.apache.hadoop.hdfs.server.federation.store.protocol.UpdateMountTableEntryRequest;
import org.apache.hadoop.hdfs.server.federation.store.records.MountTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RouterQuotaUpdateService
extends PeriodicService {
    private static final Logger LOG = LoggerFactory.getLogger(RouterQuotaUpdateService.class);
    private MountTableStore mountTableStore;
    private RouterRpcServer rpcServer;
    private final Router router;
    private RouterQuotaManager quotaManager;

    public RouterQuotaUpdateService(Router router) throws IOException {
        super(RouterQuotaUpdateService.class.getName());
        this.router = router;
        this.rpcServer = router.getRpcServer();
        this.quotaManager = router.getQuotaManager();
        if (this.quotaManager == null) {
            throw new IOException("Router quota manager is not initialized.");
        }
    }

    protected void serviceInit(Configuration conf) throws Exception {
        this.setIntervalMs(conf.getTimeDuration("dfs.federation.router.quota-cache.update.interval", 60000L, TimeUnit.MILLISECONDS));
        super.serviceInit(conf);
    }

    @Override
    protected void periodicInvoke() {
        LOG.debug("Start to update quota cache.");
        try {
            LinkedList<MountTable> updateMountTables = new LinkedList<MountTable>();
            List<MountTable> mountTables = this.getQuotaSetMountTables();
            for (MountTable entry : mountTables) {
                String src = entry.getSourcePath();
                RouterQuotaUsage oldQuota = entry.getQuota();
                long nsQuota = oldQuota.getQuota();
                long ssQuota = oldQuota.getSpaceQuota();
                QuotaUsage currentQuotaUsage = null;
                HdfsFileStatus ret = this.rpcServer.getFileInfo(src);
                if (ret == null) {
                    currentQuotaUsage = new RouterQuotaUsage.Builder().fileAndDirectoryCount(0L).quota(nsQuota).spaceConsumed(0L).spaceQuota(ssQuota).build();
                } else {
                    try {
                        currentQuotaUsage = this.rpcServer.getQuotaModule().getQuotaUsage(src);
                    }
                    catch (IOException ioe) {
                        LOG.error("Unable to get quota usage for " + src, (Throwable)ioe);
                        continue;
                    }
                }
                if (currentQuotaUsage.getQuota() == Long.MAX_VALUE) {
                    try {
                        this.rpcServer.setQuota(src, nsQuota, ssQuota, null);
                    }
                    catch (IOException ioe) {
                        LOG.error("Unable to set quota at remote location for " + src, (Throwable)ioe);
                    }
                }
                RouterQuotaUsage newQuota = this.generateNewQuota(oldQuota, currentQuotaUsage);
                this.quotaManager.put(src, newQuota);
                entry.setQuota(newQuota);
                if (oldQuota.equals((Object)newQuota)) continue;
                updateMountTables.add(entry);
                LOG.debug("Update quota usage entity of path: {}, nsCount: {}, nsQuota: {}, ssCount: {}, ssQuota: {}.", new Object[]{src, newQuota.getFileAndDirectoryCount(), newQuota.getQuota(), newQuota.getSpaceConsumed(), newQuota.getSpaceQuota()});
            }
            this.updateMountTableEntries(updateMountTables);
        }
        catch (IOException e) {
            LOG.error("Quota cache updated error.", (Throwable)e);
        }
    }

    private MountTableStore getMountTableStore() throws IOException {
        if (this.mountTableStore == null) {
            this.mountTableStore = this.router.getStateStore().getRegisteredRecordStore(MountTableStore.class);
            if (this.mountTableStore == null) {
                throw new IOException("Mount table state store is not available.");
            }
        }
        return this.mountTableStore;
    }

    private List<MountTable> getMountTableEntries() throws IOException {
        GetMountTableEntriesRequest getRequest = GetMountTableEntriesRequest.newInstance("/");
        GetMountTableEntriesResponse getResponse = this.getMountTableStore().getMountTableEntries(getRequest);
        return getResponse.getEntries();
    }

    private List<MountTable> getQuotaSetMountTables() throws IOException {
        List<MountTable> mountTables = this.getMountTableEntries();
        HashSet<String> stalePaths = new HashSet<String>();
        for (String path : this.quotaManager.getAll()) {
            stalePaths.add(path);
        }
        LinkedList<MountTable> neededMountTables = new LinkedList<MountTable>();
        for (MountTable entry : mountTables) {
            if (this.isQuotaSet(entry)) {
                neededMountTables.add(entry);
            }
            String src = entry.getSourcePath();
            this.quotaManager.put(src, entry.getQuota());
            stalePaths.remove(src);
        }
        for (String stalePath : stalePaths) {
            this.quotaManager.remove(stalePath);
        }
        return neededMountTables;
    }

    private boolean isQuotaSet(MountTable mountTable) {
        if (mountTable != null) {
            return this.quotaManager.isQuotaSet(mountTable.getQuota());
        }
        return false;
    }

    private RouterQuotaUsage generateNewQuota(RouterQuotaUsage oldQuota, QuotaUsage currentQuotaUsage) {
        RouterQuotaUsage newQuota = new RouterQuotaUsage.Builder().fileAndDirectoryCount(currentQuotaUsage.getFileAndDirectoryCount()).quota(oldQuota.getQuota()).spaceConsumed(currentQuotaUsage.getSpaceConsumed()).spaceQuota(oldQuota.getSpaceQuota()).build();
        return newQuota;
    }

    private void updateMountTableEntries(List<MountTable> updateMountTables) throws IOException {
        for (MountTable entry : updateMountTables) {
            UpdateMountTableEntryRequest updateRequest = UpdateMountTableEntryRequest.newInstance(entry);
            try {
                this.getMountTableStore().updateMountTableEntry(updateRequest);
            }
            catch (IOException e) {
                LOG.error("Quota update error for mount entry " + entry.getSourcePath(), (Throwable)e);
            }
        }
    }
}

