/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.router;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.util.AbstractQueue;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.NameNodeProxiesClient;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.server.federation.resolver.ActiveNamenodeResolver;
import org.apache.hadoop.hdfs.server.federation.resolver.FederationNamenodeContext;
import org.apache.hadoop.hdfs.server.federation.resolver.FederationNamenodeServiceState;
import org.apache.hadoop.hdfs.server.federation.resolver.RemoteLocation;
import org.apache.hadoop.hdfs.server.federation.router.ConnectionContext;
import org.apache.hadoop.hdfs.server.federation.router.ConnectionManager;
import org.apache.hadoop.hdfs.server.federation.router.RemoteLocationContext;
import org.apache.hadoop.hdfs.server.federation.router.RemoteMethod;
import org.apache.hadoop.hdfs.server.federation.router.RouterRpcMonitor;
import org.apache.hadoop.hdfs.server.federation.router.RouterRpcServer;
import org.apache.hadoop.hdfs.server.federation.router.SubClusterTimeoutException;
import org.apache.hadoop.io.retry.RetryPolicies;
import org.apache.hadoop.io.retry.RetryPolicy;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.ipc.StandbyException;
import org.apache.hadoop.security.UserGroupInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RouterRpcClient {
    private static final Logger LOG = LoggerFactory.getLogger(RouterRpcClient.class);
    private final String routerId;
    private final ActiveNamenodeResolver namenodeResolver;
    private final ConnectionManager connectionManager;
    private final ThreadPoolExecutor executorService;
    private final RetryPolicy retryPolicy;
    private final RouterRpcMonitor rpcMonitor;
    private static final Pattern STACK_TRACE_PATTERN = Pattern.compile("\\tat (.*)\\.(.*)\\((.*):(\\d*)\\)");

    public RouterRpcClient(Configuration conf, String identifier, ActiveNamenodeResolver resolver, RouterRpcMonitor monitor) {
        this.routerId = identifier;
        this.namenodeResolver = resolver;
        this.connectionManager = new ConnectionManager(conf);
        this.connectionManager.start();
        int numThreads = conf.getInt("dfs.federation.router.client.thread-size", 32);
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat("RPC Router Client-%d").build();
        AbstractQueue workQueue = conf.getBoolean("dfs.federation.router.client.reject.overload", false) ? new ArrayBlockingQueue(numThreads) : new LinkedBlockingQueue();
        this.executorService = new ThreadPoolExecutor(numThreads, numThreads, 0L, TimeUnit.MILLISECONDS, (BlockingQueue<Runnable>)((Object)workQueue), threadFactory);
        this.rpcMonitor = monitor;
        int maxFailoverAttempts = conf.getInt("dfs.client.failover.max.attempts", 15);
        int maxRetryAttempts = conf.getInt("dfs.federation.router.client.retry.max.attempts", 3);
        int failoverSleepBaseMillis = conf.getInt("dfs.client.failover.sleep.base.millis", 500);
        int failoverSleepMaxMillis = conf.getInt("dfs.client.failover.sleep.max.millis", 15000);
        this.retryPolicy = RetryPolicies.failoverOnNetworkException((RetryPolicy)RetryPolicies.TRY_ONCE_THEN_FAIL, (int)maxFailoverAttempts, (int)maxRetryAttempts, (long)failoverSleepBaseMillis, (long)failoverSleepMaxMillis);
    }

    public ActiveNamenodeResolver getNamenodeResolver() {
        return this.namenodeResolver;
    }

    public void shutdown() {
        if (this.connectionManager != null) {
            this.connectionManager.close();
        }
        if (this.executorService != null) {
            this.executorService.shutdownNow();
        }
    }

    public int getNumConnections() {
        return this.connectionManager.getNumConnections();
    }

    public int getNumActiveConnections() {
        return this.connectionManager.getNumActiveConnections();
    }

    public int getNumConnectionPools() {
        return this.connectionManager.getNumConnectionPools();
    }

    public int getNumCreatingConnections() {
        return this.connectionManager.getNumCreatingConnections();
    }

    public String getJSON() {
        return this.connectionManager.getJSON();
    }

    private ConnectionContext getConnection(UserGroupInformation ugi, String nsId, String rpcAddress, Class<?> proto) throws IOException {
        ConnectionContext connection = null;
        try {
            connection = this.connectionManager.getConnection(ugi, rpcAddress, proto);
            LOG.debug("User {} NN {} is using connection {}", new Object[]{ugi.getUserName(), rpcAddress, connection});
        }
        catch (Exception ex) {
            LOG.error("Cannot open NN client to address: {}", (Object)rpcAddress, (Object)ex);
        }
        if (connection == null) {
            throw new IOException("Cannot get a connection to " + rpcAddress);
        }
        return connection;
    }

    private static IOException toIOException(Exception e) {
        if (e instanceof RemoteException) {
            return ((RemoteException)e).unwrapRemoteException();
        }
        if (e instanceof IOException) {
            return (IOException)e;
        }
        return new IOException(e);
    }

    private RetryPolicy.RetryAction.RetryDecision shouldRetry(IOException ioe, int retryCount, String nsId) throws IOException {
        if (this.isClusterUnAvailable(nsId)) {
            if (retryCount == 0) {
                return RetryPolicy.RetryAction.RetryDecision.RETRY;
            }
            throw new IOException("No namenode available under nameservice " + nsId, ioe);
        }
        try {
            RetryPolicy.RetryAction a = this.retryPolicy.shouldRetry((Exception)ioe, retryCount, 0, true);
            return a.action;
        }
        catch (Exception ex) {
            LOG.error("Re-throwing API exception, no more retries", (Throwable)ex);
            throw RouterRpcClient.toIOException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object invokeMethod(UserGroupInformation ugi, List<? extends FederationNamenodeContext> namenodes, Class<?> protocol, Method method, Object ... params) throws IOException {
        if (namenodes == null || namenodes.isEmpty()) {
            throw new IOException("No namenodes to invoke " + method.getName() + " with params " + Arrays.toString(params) + " from " + this.routerId);
        }
        Object ret = null;
        if (this.rpcMonitor != null) {
            this.rpcMonitor.proxyOp();
        }
        boolean failover = false;
        LinkedHashMap<FederationNamenodeContext, IOException> ioes = new LinkedHashMap<FederationNamenodeContext, IOException>();
        for (FederationNamenodeContext federationNamenodeContext : namenodes) {
            ConnectionContext connection = null;
            try {
                Object address;
                String nsId = federationNamenodeContext.getNameserviceId();
                String rpcAddress = federationNamenodeContext.getRpcAddress();
                connection = this.getConnection(ugi, nsId, rpcAddress, protocol);
                NameNodeProxiesClient.ProxyAndInfo<?> client = connection.getClient();
                Object proxy = client.getProxy();
                ret = this.invoke(nsId, 0, method, proxy, params);
                if (failover) {
                    address = client.getAddress();
                    this.namenodeResolver.updateActiveNamenode(nsId, (InetSocketAddress)address);
                }
                if (this.rpcMonitor != null) {
                    this.rpcMonitor.proxyOpComplete(true);
                }
                address = ret;
                return address;
            }
            catch (IOException ioe) {
                ioes.put(federationNamenodeContext, ioe);
                if (ioe instanceof StandbyException) {
                    if (this.rpcMonitor != null) {
                        this.rpcMonitor.proxyOpFailureStandby();
                    }
                    failover = true;
                    continue;
                }
                if (ioe instanceof RemoteException) {
                    if (this.rpcMonitor != null) {
                        this.rpcMonitor.proxyOpComplete(true);
                    }
                    throw (RemoteException)ioe;
                }
                if (this.rpcMonitor != null) {
                    this.rpcMonitor.proxyOpFailureCommunicate();
                    this.rpcMonitor.proxyOpComplete(false);
                }
                throw ioe;
            }
            finally {
                if (connection == null) continue;
                connection.release();
            }
        }
        if (this.rpcMonitor != null) {
            this.rpcMonitor.proxyOpComplete(false);
        }
        String msg = "No namenode available to invoke " + method.getName() + " " + Arrays.toString(params);
        LOG.error(msg);
        for (Map.Entry entry : ioes.entrySet()) {
            FederationNamenodeContext namenode = (FederationNamenodeContext)entry.getKey();
            String nsId = namenode.getNameserviceId();
            String nnId = namenode.getNamenodeId();
            String addr = namenode.getRpcAddress();
            IOException ioe = (IOException)entry.getValue();
            if (ioe instanceof StandbyException) {
                LOG.error("{} {} at {} is in Standby", new Object[]{nsId, nnId, addr});
                continue;
            }
            LOG.error("{} {} at {} error: \"{}\"", new Object[]{nsId, nnId, addr, ioe.getMessage()});
        }
        throw new StandbyException(msg);
    }

    private Object invoke(String nsId, int retryCount, Method method, Object obj, Object ... params) throws IOException {
        try {
            return method.invoke(obj, params);
        }
        catch (IllegalAccessException e) {
            LOG.error("Unexpected exception while proxying API", (Throwable)e);
            return null;
        }
        catch (IllegalArgumentException e) {
            LOG.error("Unexpected exception while proxying API", (Throwable)e);
            return null;
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IOException) {
                IOException ioe = (IOException)cause;
                RetryPolicy.RetryAction.RetryDecision decision = this.shouldRetry(ioe, retryCount, nsId);
                if (decision == RetryPolicy.RetryAction.RetryDecision.RETRY) {
                    if (this.rpcMonitor != null) {
                        this.rpcMonitor.proxyOpRetries();
                    }
                    return this.invoke(nsId, ++retryCount, method, obj, params);
                }
                if (decision == RetryPolicy.RetryAction.RetryDecision.FAILOVER_AND_RETRY) {
                    if (ioe instanceof StandbyException) {
                        throw ioe;
                    }
                    throw new StandbyException(ioe.getMessage());
                }
                if (ioe instanceof RemoteException) {
                    RemoteException re = (RemoteException)ioe;
                    ioe = re.unwrapRemoteException();
                    ioe = RouterRpcClient.getCleanException(ioe);
                }
                throw ioe;
            }
            throw new IOException(e);
        }
    }

    private boolean isClusterUnAvailable(String nsId) throws IOException {
        List<? extends FederationNamenodeContext> nnState = this.namenodeResolver.getNamenodesForNameserviceId(nsId);
        if (nnState != null) {
            for (FederationNamenodeContext federationNamenodeContext : nnState) {
                if (federationNamenodeContext.getState() != FederationNamenodeServiceState.ACTIVE) continue;
                return false;
            }
        }
        return true;
    }

    private static IOException getCleanException(IOException ioe) {
        Object ret = null;
        String msg = ioe.getMessage();
        Throwable cause = ioe.getCause();
        StackTraceElement[] stackTrace = ioe.getStackTrace();
        int index = msg.indexOf("\n");
        if (index > 0) {
            String[] msgSplit = msg.split("\n");
            msg = msgSplit[0];
            LinkedList<StackTraceElement> elements = new LinkedList<StackTraceElement>();
            for (int i = 1; i < msgSplit.length; ++i) {
                String line = msgSplit[i];
                Matcher matcher = STACK_TRACE_PATTERN.matcher(line);
                if (!matcher.find()) continue;
                String declaringClass = matcher.group(1);
                String methodName = matcher.group(2);
                String fileName = matcher.group(3);
                int lineNumber = Integer.parseInt(matcher.group(4));
                StackTraceElement element = new StackTraceElement(declaringClass, methodName, fileName, lineNumber);
                elements.add(element);
            }
            stackTrace = elements.toArray(new StackTraceElement[elements.size()]);
        }
        if (ioe instanceof RemoteException) {
            RemoteException re = (RemoteException)ioe;
            ret = new RemoteException(re.getClassName(), msg);
        } else {
            Class<?> ioeClass = ioe.getClass();
            try {
                Constructor<?> constructor = ioeClass.getDeclaredConstructor(String.class);
                ret = (IOException)constructor.newInstance(msg);
            }
            catch (ReflectiveOperationException e) {
                LOG.error("Could not create exception {}", (Object)ioeClass.getSimpleName(), (Object)e);
                ret = ioe;
            }
        }
        if (ret != null) {
            ((Throwable)ret).initCause(cause);
            ((Throwable)ret).setStackTrace(stackTrace);
        }
        return ret;
    }

    public Object invokeSingle(ExtendedBlock block, RemoteMethod method) throws IOException {
        String bpId = block.getBlockPoolId();
        return this.invokeSingleBlockPool(bpId, method);
    }

    public Object invokeSingleBlockPool(String bpId, RemoteMethod method) throws IOException {
        String nsId = this.getNameserviceForBlockPoolId(bpId);
        return this.invokeSingle(nsId, method);
    }

    public Object invokeSingle(String nsId, RemoteMethod method) throws IOException {
        UserGroupInformation ugi = RouterRpcServer.getRemoteUser();
        List<? extends FederationNamenodeContext> nns = this.getNamenodesForNameservice(nsId);
        RemoteLocation loc = new RemoteLocation(nsId, "/", "/");
        Class<?> proto = method.getProtocol();
        Method m = method.getMethod();
        Object[] params = method.getParams(loc);
        return this.invokeMethod(ugi, nns, proto, m, params);
    }

    public <T> T invokeSingle(String nsId, RemoteMethod method, Class<T> clazz) throws IOException {
        Object ret = this.invokeSingle(nsId, method);
        return (T)ret;
    }

    public Object invokeSingle(RemoteLocationContext location, RemoteMethod remoteMethod) throws IOException {
        List<RemoteLocationContext> locations = Collections.singletonList(location);
        return this.invokeSequential(locations, remoteMethod);
    }

    public Object invokeSequential(List<? extends RemoteLocationContext> locations, RemoteMethod remoteMethod) throws IOException {
        return this.invokeSequential(locations, remoteMethod, null, null);
    }

    public <T> T invokeSequential(List<? extends RemoteLocationContext> locations, RemoteMethod remoteMethod, Class<T> expectedResultClass, Object expectedResultValue) throws IOException {
        UserGroupInformation ugi = RouterRpcServer.getRemoteUser();
        Method m = remoteMethod.getMethod();
        IOException firstThrownException = null;
        IOException lastThrownException = null;
        Object firstResult = null;
        for (RemoteLocationContext remoteLocationContext : locations) {
            String ns = remoteLocationContext.getNameserviceId();
            List<? extends FederationNamenodeContext> namenodes = this.getNamenodesForNameservice(ns);
            try {
                Class<?> proto = remoteMethod.getProtocol();
                Object[] params = remoteMethod.getParams(remoteLocationContext);
                Object result = this.invokeMethod(ugi, namenodes, proto, m, params);
                if (RouterRpcClient.isExpectedClass(expectedResultClass, result) && RouterRpcClient.isExpectedValue(expectedResultValue, result)) {
                    Object ret = result;
                    return (T)ret;
                }
                if (firstResult != null) continue;
                firstResult = result;
            }
            catch (IOException ioe) {
                lastThrownException = ioe = this.processException(ioe, remoteLocationContext);
                if (firstThrownException != null) continue;
                firstThrownException = lastThrownException;
            }
            catch (Exception e) {
                LOG.error("Unexpected exception {} proxying {} to {}", new Object[]{e.getClass(), m.getName(), ns, e});
                lastThrownException = new IOException("Unexpected exception proxying API " + e.getMessage(), e);
                if (firstThrownException != null) continue;
                firstThrownException = lastThrownException;
            }
        }
        if (firstThrownException != null) {
            throw firstThrownException;
        }
        Object ret = firstResult;
        return (T)ret;
    }

    private IOException processException(IOException ioe, RemoteLocationContext loc) {
        if (ioe instanceof RemoteException) {
            RemoteException re = (RemoteException)ioe;
            String newMsg = RouterRpcClient.processExceptionMsg(re.getMessage(), loc.getDest(), loc.getSrc());
            RemoteException newException = new RemoteException(re.getClassName(), newMsg);
            newException.setStackTrace(ioe.getStackTrace());
            return newException;
        }
        if (ioe instanceof FileNotFoundException) {
            String newMsg = RouterRpcClient.processExceptionMsg(ioe.getMessage(), loc.getDest(), loc.getSrc());
            FileNotFoundException newException = new FileNotFoundException(newMsg);
            newException.setStackTrace(ioe.getStackTrace());
            return newException;
        }
        return ioe;
    }

    @VisibleForTesting
    static String processExceptionMsg(String msg, String dst, String src) {
        if (dst.equals(src) || !dst.startsWith("/") || !src.startsWith("/")) {
            return msg;
        }
        String newMsg = msg.replaceFirst(dst, src);
        int minLen = Math.min(dst.length(), src.length());
        for (int i = 0; newMsg.equals(msg) && i < minLen; ++i) {
            String dst1 = dst.substring(0, dst.length() - 1 - i);
            String src1 = src.substring(0, src.length() - 1 - i);
            newMsg = msg.replaceFirst(dst1, src1);
        }
        return newMsg;
    }

    private static boolean isExpectedClass(Class<?> expectedClass, Object clazz) {
        if (expectedClass == null) {
            return true;
        }
        if (clazz == null) {
            return false;
        }
        return expectedClass.isInstance(clazz);
    }

    private static boolean isExpectedValue(Object expectedValue, Object value) {
        if (expectedValue == null) {
            return true;
        }
        if (value == null) {
            return false;
        }
        return value.equals(expectedValue);
    }

    public <T extends RemoteLocationContext, R> boolean invokeAll(Collection<T> locations, RemoteMethod method) throws IOException {
        boolean anyResult = false;
        Map<T, Boolean> results = this.invokeConcurrent(locations, method, false, false, Boolean.class);
        for (Boolean value : results.values()) {
            boolean result = value;
            if (!result) continue;
            anyResult = true;
        }
        return anyResult;
    }

    public <T extends RemoteLocationContext, R> void invokeConcurrent(Collection<T> locations, RemoteMethod method) throws IOException {
        this.invokeConcurrent(locations, method, Void.TYPE);
    }

    public <T extends RemoteLocationContext, R> Map<T, R> invokeConcurrent(Collection<T> locations, RemoteMethod method, Class<R> clazz) throws IOException {
        return this.invokeConcurrent(locations, method, false, false, clazz);
    }

    public <T extends RemoteLocationContext, R> void invokeConcurrent(Collection<T> locations, RemoteMethod method, boolean requireResponse, boolean standby) throws IOException {
        this.invokeConcurrent(locations, method, requireResponse, standby, Void.TYPE);
    }

    public <T extends RemoteLocationContext, R> Map<T, R> invokeConcurrent(Collection<T> locations, RemoteMethod method, boolean requireResponse, boolean standby, Class<R> clazz) throws IOException {
        return this.invokeConcurrent(locations, method, requireResponse, standby, -1L, clazz);
    }

    /*
     * WARNING - void declaration
     */
    public <T extends RemoteLocationContext, R> Map<T, R> invokeConcurrent(Collection<T> locations, RemoteMethod method, boolean requireResponse, boolean standby, long timeOutMs, Class<R> clazz) throws IOException {
        final UserGroupInformation ugi = RouterRpcServer.getRemoteUser();
        final Method m = method.getMethod();
        if (locations.isEmpty()) {
            throw new IOException("No remote locations available");
        }
        if (locations.size() == 1) {
            RemoteLocationContext location = (RemoteLocationContext)locations.iterator().next();
            String ns = location.getNameserviceId();
            List<? extends FederationNamenodeContext> namenodes = this.getNamenodesForNameservice(ns);
            Class<?> proto = method.getProtocol();
            Object[] paramList = method.getParams(location);
            Object result = this.invokeMethod(ugi, namenodes, proto, m, paramList);
            return Collections.singletonMap(location, clazz.cast(result));
        }
        LinkedList<RemoteLocationContext> orderedLocations = new LinkedList<RemoteLocationContext>();
        HashSet<Callable<Object>> callables = new HashSet<Callable<Object>>();
        for (RemoteLocationContext location : locations) {
            String nsId = location.getNameserviceId();
            final List<? extends FederationNamenodeContext> namenodes = this.getNamenodesForNameservice(nsId);
            final Class<?> proto = method.getProtocol();
            final Object[] paramList = method.getParams(location);
            if (standby) {
                for (FederationNamenodeContext federationNamenodeContext : namenodes) {
                    String nnId = federationNamenodeContext.getNamenodeId();
                    final List<FederationNamenodeContext> nnList = Collections.singletonList(federationNamenodeContext);
                    RemoteLocationContext nnLocation = location;
                    if (location instanceof RemoteLocation) {
                        nnLocation = new RemoteLocation(nsId, nnId, location.getDest());
                    }
                    orderedLocations.add(nnLocation);
                    callables.add(new Callable<Object>(){

                        @Override
                        public Object call() throws Exception {
                            return RouterRpcClient.this.invokeMethod(ugi, nnList, proto, m, paramList);
                        }
                    });
                }
                continue;
            }
            orderedLocations.add(location);
            callables.add(new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    return RouterRpcClient.this.invokeMethod(ugi, namenodes, proto, m, paramList);
                }
            });
        }
        if (this.rpcMonitor != null) {
            this.rpcMonitor.proxyOp();
        }
        try {
            RemoteLocationContext location;
            IOException ioe;
            List futures = null;
            futures = timeOutMs > 0L ? this.executorService.invokeAll(callables, timeOutMs, TimeUnit.MILLISECONDS) : this.executorService.invokeAll(callables);
            TreeMap<RemoteLocationContext, R> results = new TreeMap<RemoteLocationContext, R>();
            TreeMap<RemoteLocationContext, Object> exceptions = new TreeMap<RemoteLocationContext, Object>();
            for (int i = 0; i < futures.size(); ++i) {
                RemoteLocationContext location2 = (RemoteLocationContext)orderedLocations.get(i);
                try {
                    Future future = futures.get(i);
                    Object result = future.get();
                    results.put(location2, clazz.cast(result));
                    continue;
                }
                catch (CancellationException ce) {
                    RemoteLocationContext loc = (RemoteLocationContext)orderedLocations.get(i);
                    String string = "Invocation to \"" + loc + "\" for \"" + method.getMethodName() + "\" timed out";
                    LOG.error(string);
                    SubClusterTimeoutException ioe2 = new SubClusterTimeoutException(string);
                    exceptions.put(location2, ioe2);
                    continue;
                }
                catch (ExecutionException ex) {
                    void var19_38;
                    Throwable cause = ex.getCause();
                    LOG.debug("Canot execute {} in {}: {}", new Object[]{m.getName(), location2, cause.getMessage()});
                    Object var19_35 = null;
                    if (cause instanceof IOException) {
                        IOException iOException = (IOException)cause;
                    } else {
                        IOException iOException = new IOException("Unhandled exception while proxying API " + m.getName() + ": " + cause.getMessage(), cause);
                    }
                    if (requireResponse) {
                        throw var19_38;
                    }
                    exceptions.put(location2, var19_38);
                }
            }
            if (results.isEmpty() && (ioe = (IOException)exceptions.get(location = (RemoteLocationContext)orderedLocations.get(0))) != null) {
                throw ioe;
            }
            return results;
        }
        catch (RejectedExecutionException e) {
            if (this.rpcMonitor != null) {
                this.rpcMonitor.proxyOpFailureClientOverloaded();
            }
            int active = this.executorService.getActiveCount();
            int total = this.executorService.getMaximumPoolSize();
            String msg = "Not enough client threads " + active + "/" + total;
            LOG.error(msg);
            throw new StandbyException("Router " + this.routerId + " is overloaded: " + msg);
        }
        catch (InterruptedException ex) {
            LOG.error("Unexpected error while invoking API: {}", (Object)ex.getMessage());
            throw new IOException("Unexpected error while invoking API " + ex.getMessage(), ex);
        }
    }

    private List<? extends FederationNamenodeContext> getNamenodesForNameservice(String nsId) throws IOException {
        List<? extends FederationNamenodeContext> namenodes = this.namenodeResolver.getNamenodesForNameserviceId(nsId);
        if (namenodes == null || namenodes.isEmpty()) {
            throw new IOException("Cannot locate a registered namenode for " + nsId + " from " + this.routerId);
        }
        return namenodes;
    }

    private List<? extends FederationNamenodeContext> getNamenodesForBlockPoolId(String bpId) throws IOException {
        List<? extends FederationNamenodeContext> namenodes = this.namenodeResolver.getNamenodesForBlockPoolId(bpId);
        if (namenodes == null || namenodes.isEmpty()) {
            throw new IOException("Cannot locate a registered namenode for " + bpId + " from " + this.routerId);
        }
        return namenodes;
    }

    private String getNameserviceForBlockPoolId(String bpId) throws IOException {
        List<? extends FederationNamenodeContext> namenodes = this.getNamenodesForBlockPoolId(bpId);
        FederationNamenodeContext namenode = namenodes.get(0);
        return namenode.getNameserviceId();
    }
}

