/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.router;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.hdfs.protocol.AddErasureCodingPolicyResponse;
import org.apache.hadoop.hdfs.protocol.ECBlockGroupStats;
import org.apache.hadoop.hdfs.protocol.ErasureCodingPolicy;
import org.apache.hadoop.hdfs.protocol.ErasureCodingPolicyInfo;
import org.apache.hadoop.hdfs.server.federation.resolver.ActiveNamenodeResolver;
import org.apache.hadoop.hdfs.server.federation.resolver.FederationNamespaceInfo;
import org.apache.hadoop.hdfs.server.federation.resolver.RemoteLocation;
import org.apache.hadoop.hdfs.server.federation.router.RemoteMethod;
import org.apache.hadoop.hdfs.server.federation.router.RemoteParam;
import org.apache.hadoop.hdfs.server.federation.router.RouterRpcClient;
import org.apache.hadoop.hdfs.server.federation.router.RouterRpcServer;
import org.apache.hadoop.hdfs.server.namenode.NameNode;

public class ErasureCoding {
    private final RouterRpcServer rpcServer;
    private final RouterRpcClient rpcClient;
    private final ActiveNamenodeResolver namenodeResolver;

    public ErasureCoding(RouterRpcServer server) {
        this.rpcServer = server;
        this.rpcClient = this.rpcServer.getRPCClient();
        this.namenodeResolver = this.rpcClient.getNamenodeResolver();
    }

    public ErasureCodingPolicyInfo[] getErasureCodingPolicies() throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.READ);
        RemoteMethod method = new RemoteMethod("getErasureCodingPolicies");
        Set<FederationNamespaceInfo> nss = this.namenodeResolver.getNamespaces();
        Map<FederationNamespaceInfo, ErasureCodingPolicyInfo[]> ret = this.rpcClient.invokeConcurrent(nss, method, true, false, ErasureCodingPolicyInfo[].class);
        return RouterRpcServer.merge(ret, ErasureCodingPolicyInfo.class);
    }

    public Map<String, String> getErasureCodingCodecs() throws IOException {
        Map<FederationNamespaceInfo, Map> obj;
        this.rpcServer.checkOperation(NameNode.OperationCategory.READ);
        RemoteMethod method = new RemoteMethod("getErasureCodingCodecs");
        Set<FederationNamespaceInfo> nss = this.namenodeResolver.getNamespaces();
        Map<FederationNamespaceInfo, Map> retCodecs = this.rpcClient.invokeConcurrent(nss, method, true, false, Map.class);
        HashMap<String, String> ret = new HashMap<String, String>();
        Map<FederationNamespaceInfo, Map> results = obj = retCodecs;
        Collection<Map> allCodecs = results.values();
        for (Map codecs : allCodecs) {
            ret.putAll(codecs);
        }
        return ret;
    }

    public AddErasureCodingPolicyResponse[] addErasureCodingPolicies(ErasureCodingPolicy[] policies) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.WRITE);
        RemoteMethod method = new RemoteMethod("addErasureCodingPolicies", new Class[]{ErasureCodingPolicy[].class}, new Object[]{policies});
        Set<FederationNamespaceInfo> nss = this.namenodeResolver.getNamespaces();
        Map<FederationNamespaceInfo, AddErasureCodingPolicyResponse[]> ret = this.rpcClient.invokeConcurrent(nss, method, true, false, AddErasureCodingPolicyResponse[].class);
        return RouterRpcServer.merge(ret, AddErasureCodingPolicyResponse.class);
    }

    public void removeErasureCodingPolicy(String ecPolicyName) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.WRITE);
        RemoteMethod method = new RemoteMethod("removeErasureCodingPolicy", new Class[]{String.class}, ecPolicyName);
        Set<FederationNamespaceInfo> nss = this.namenodeResolver.getNamespaces();
        this.rpcClient.invokeConcurrent(nss, method, true, false);
    }

    public void disableErasureCodingPolicy(String ecPolicyName) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.WRITE);
        RemoteMethod method = new RemoteMethod("disableErasureCodingPolicy", new Class[]{String.class}, ecPolicyName);
        Set<FederationNamespaceInfo> nss = this.namenodeResolver.getNamespaces();
        this.rpcClient.invokeConcurrent(nss, method, true, false);
    }

    public void enableErasureCodingPolicy(String ecPolicyName) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.WRITE);
        RemoteMethod method = new RemoteMethod("enableErasureCodingPolicy", new Class[]{String.class}, ecPolicyName);
        Set<FederationNamespaceInfo> nss = this.namenodeResolver.getNamespaces();
        this.rpcClient.invokeConcurrent(nss, method, true, false);
    }

    public ErasureCodingPolicy getErasureCodingPolicy(String src) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.READ);
        List<RemoteLocation> locations = this.rpcServer.getLocationsForPath(src, true);
        RemoteMethod remoteMethod = new RemoteMethod("getErasureCodingPolicy", new Class[]{String.class}, new RemoteParam());
        ErasureCodingPolicy ret = (ErasureCodingPolicy)this.rpcClient.invokeSequential(locations, remoteMethod, null, null);
        return ret;
    }

    public void setErasureCodingPolicy(String src, String ecPolicyName) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.WRITE);
        List<RemoteLocation> locations = this.rpcServer.getLocationsForPath(src, true);
        RemoteMethod remoteMethod = new RemoteMethod("setErasureCodingPolicy", new Class[]{String.class, String.class}, new RemoteParam(), ecPolicyName);
        this.rpcClient.invokeSequential(locations, remoteMethod, null, null);
    }

    public void unsetErasureCodingPolicy(String src) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.WRITE);
        List<RemoteLocation> locations = this.rpcServer.getLocationsForPath(src, true);
        RemoteMethod remoteMethod = new RemoteMethod("unsetErasureCodingPolicy", new Class[]{String.class}, new RemoteParam());
        this.rpcClient.invokeSequential(locations, remoteMethod, null, null);
    }

    public ECBlockGroupStats getECBlockGroupStats() throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.READ);
        RemoteMethod method = new RemoteMethod("getECBlockGroupStats");
        Set<FederationNamespaceInfo> nss = this.namenodeResolver.getNamespaces();
        Map<FederationNamespaceInfo, ECBlockGroupStats> allStats = this.rpcClient.invokeConcurrent(nss, method, true, false, ECBlockGroupStats.class);
        long lowRedundancyBlockGroups = 0L;
        long corruptBlockGroups = 0L;
        long missingBlockGroups = 0L;
        long bytesInFutureBlockGroups = 0L;
        long pendingDeletionBlocks = 0L;
        long highestPriorityLowRedundancyBlocks = 0L;
        boolean hasHighestPriorityLowRedundancyBlocks = false;
        for (ECBlockGroupStats stats : allStats.values()) {
            lowRedundancyBlockGroups += stats.getLowRedundancyBlockGroups();
            corruptBlockGroups += stats.getCorruptBlockGroups();
            missingBlockGroups += stats.getMissingBlockGroups();
            bytesInFutureBlockGroups += stats.getBytesInFutureBlockGroups();
            pendingDeletionBlocks += stats.getPendingDeletionBlocks();
            if (!stats.hasHighestPriorityLowRedundancyBlocks()) continue;
            hasHighestPriorityLowRedundancyBlocks = true;
            highestPriorityLowRedundancyBlocks += stats.getHighestPriorityLowRedundancyBlocks().longValue();
        }
        if (hasHighestPriorityLowRedundancyBlocks) {
            return new ECBlockGroupStats(lowRedundancyBlockGroups, corruptBlockGroups, missingBlockGroups, bytesInFutureBlockGroups, pendingDeletionBlocks, Long.valueOf(highestPriorityLowRedundancyBlocks));
        }
        return new ECBlockGroupStats(lowRedundancyBlockGroups, corruptBlockGroups, missingBlockGroups, bytesInFutureBlockGroups, pendingDeletionBlocks);
    }
}

