/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.router;

import com.sun.jersey.spi.container.ResourceFilters;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Path;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.protocol.ClientProtocol;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.server.common.JspHelper;
import org.apache.hadoop.hdfs.server.federation.resolver.ActiveNamenodeResolver;
import org.apache.hadoop.hdfs.server.federation.resolver.FederationNamenodeContext;
import org.apache.hadoop.hdfs.server.federation.resolver.RemoteLocation;
import org.apache.hadoop.hdfs.server.federation.router.Router;
import org.apache.hadoop.hdfs.server.federation.router.RouterRpcServer;
import org.apache.hadoop.hdfs.server.namenode.web.resources.NamenodeWebHdfsMethods;
import org.apache.hadoop.hdfs.web.JsonUtil;
import org.apache.hadoop.hdfs.web.ParamFilter;
import org.apache.hadoop.hdfs.web.URLConnectionFactory;
import org.apache.hadoop.hdfs.web.resources.AccessTimeParam;
import org.apache.hadoop.hdfs.web.resources.AclPermissionParam;
import org.apache.hadoop.hdfs.web.resources.BlockSizeParam;
import org.apache.hadoop.hdfs.web.resources.BufferSizeParam;
import org.apache.hadoop.hdfs.web.resources.ConcatSourcesParam;
import org.apache.hadoop.hdfs.web.resources.CreateFlagParam;
import org.apache.hadoop.hdfs.web.resources.CreateParentParam;
import org.apache.hadoop.hdfs.web.resources.DelegationParam;
import org.apache.hadoop.hdfs.web.resources.DestinationParam;
import org.apache.hadoop.hdfs.web.resources.DoAsParam;
import org.apache.hadoop.hdfs.web.resources.ExcludeDatanodesParam;
import org.apache.hadoop.hdfs.web.resources.FsActionParam;
import org.apache.hadoop.hdfs.web.resources.GetOpParam;
import org.apache.hadoop.hdfs.web.resources.GroupParam;
import org.apache.hadoop.hdfs.web.resources.HttpOpParam;
import org.apache.hadoop.hdfs.web.resources.LengthParam;
import org.apache.hadoop.hdfs.web.resources.ModificationTimeParam;
import org.apache.hadoop.hdfs.web.resources.NewLengthParam;
import org.apache.hadoop.hdfs.web.resources.NoRedirectParam;
import org.apache.hadoop.hdfs.web.resources.OffsetParam;
import org.apache.hadoop.hdfs.web.resources.OldSnapshotNameParam;
import org.apache.hadoop.hdfs.web.resources.OverwriteParam;
import org.apache.hadoop.hdfs.web.resources.OwnerParam;
import org.apache.hadoop.hdfs.web.resources.Param;
import org.apache.hadoop.hdfs.web.resources.PermissionParam;
import org.apache.hadoop.hdfs.web.resources.PostOpParam;
import org.apache.hadoop.hdfs.web.resources.PutOpParam;
import org.apache.hadoop.hdfs.web.resources.RenameOptionSetParam;
import org.apache.hadoop.hdfs.web.resources.RenewerParam;
import org.apache.hadoop.hdfs.web.resources.ReplicationParam;
import org.apache.hadoop.hdfs.web.resources.SnapshotNameParam;
import org.apache.hadoop.hdfs.web.resources.StartAfterParam;
import org.apache.hadoop.hdfs.web.resources.StoragePolicyParam;
import org.apache.hadoop.hdfs.web.resources.TokenArgumentParam;
import org.apache.hadoop.hdfs.web.resources.TokenKindParam;
import org.apache.hadoop.hdfs.web.resources.TokenServiceParam;
import org.apache.hadoop.hdfs.web.resources.UnmaskedPermissionParam;
import org.apache.hadoop.hdfs.web.resources.UriFsPathParam;
import org.apache.hadoop.hdfs.web.resources.UserParam;
import org.apache.hadoop.hdfs.web.resources.XAttrEncodingParam;
import org.apache.hadoop.hdfs.web.resources.XAttrNameParam;
import org.apache.hadoop.hdfs.web.resources.XAttrSetFlagParam;
import org.apache.hadoop.hdfs.web.resources.XAttrValueParam;
import org.apache.hadoop.ipc.ExternalCall;
import org.apache.hadoop.ipc.RetriableException;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.net.Node;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="")
@ResourceFilters(value={ParamFilter.class})
public class RouterWebHdfsMethods
extends NamenodeWebHdfsMethods {
    private static final Logger LOG = LoggerFactory.getLogger(RouterWebHdfsMethods.class);
    private static final ThreadLocal<String> REMOTE_ADDRESS = new ThreadLocal();
    @Context
    private HttpServletRequest request;
    private String method;
    private String query;
    private String reqPath;

    public RouterWebHdfsMethods(@Context HttpServletRequest request) {
        super(request);
        this.method = request.getMethod();
        this.query = request.getQueryString();
        this.reqPath = request.getServletPath();
        REMOTE_ADDRESS.set(JspHelper.getRemoteAddr((HttpServletRequest)request));
    }

    protected void init(UserGroupInformation ugi, DelegationParam delegation, UserParam username, DoAsParam doAsUser, UriFsPathParam path, HttpOpParam<?> op, Param<?, ?> ... parameters) {
        super.init(ugi, delegation, username, doAsUser, path, op, parameters);
        REMOTE_ADDRESS.set(JspHelper.getRemoteAddr((HttpServletRequest)this.request));
    }

    protected ClientProtocol getRpcClientProtocol() throws IOException {
        Router router = this.getRouter();
        RouterRpcServer routerRpcServer = router.getRpcServer();
        if (routerRpcServer == null) {
            throw new RetriableException("Router is in startup mode");
        }
        return routerRpcServer;
    }

    private void reset() {
        REMOTE_ADDRESS.set(null);
    }

    protected String getRemoteAddr() {
        return REMOTE_ADDRESS.get();
    }

    protected void queueExternalCall(ExternalCall call) throws IOException, InterruptedException {
        this.getRouter().getRpcServer().getServer().queueCall((Server.Call)call);
    }

    private Router getRouter() {
        return (Router)((Object)this.getContext().getAttribute("name.node"));
    }

    private static RouterRpcServer getRPCServer(Router router) throws IOException {
        RouterRpcServer routerRpcServer = router.getRpcServer();
        if (routerRpcServer == null) {
            throw new RetriableException("Router is in startup mode");
        }
        return routerRpcServer;
    }

    protected Response put(UserGroupInformation ugi, DelegationParam delegation, UserParam username, DoAsParam doAsUser, String fullpath, PutOpParam op, DestinationParam destination, OwnerParam owner, GroupParam group, PermissionParam permission, UnmaskedPermissionParam unmaskedPermission, OverwriteParam overwrite, BufferSizeParam bufferSize, ReplicationParam replication, BlockSizeParam blockSize, ModificationTimeParam modificationTime, AccessTimeParam accessTime, RenameOptionSetParam renameOptions, CreateParentParam createParent, TokenArgumentParam delegationTokenArgument, AclPermissionParam aclPermission, XAttrNameParam xattrName, XAttrValueParam xattrValue, XAttrSetFlagParam xattrSetFlag, SnapshotNameParam snapshotName, OldSnapshotNameParam oldSnapshotName, ExcludeDatanodesParam exclDatanodes, CreateFlagParam createFlagParam, NoRedirectParam noredirectParam, StoragePolicyParam policyName) throws IOException, URISyntaxException {
        switch ((PutOpParam.Op)op.getValue()) {
            case CREATE: {
                Router router = this.getRouter();
                URI uri = this.redirectURI(router, fullpath);
                if (!((Boolean)noredirectParam.getValue()).booleanValue()) {
                    return Response.temporaryRedirect((URI)uri).type("application/octet-stream").build();
                }
                String js = JsonUtil.toJsonString((String)"Location", (Object)uri);
                return Response.ok((Object)js).type("application/json").build();
            }
            case MKDIRS: 
            case CREATESYMLINK: 
            case RENAME: 
            case SETREPLICATION: 
            case SETOWNER: 
            case SETPERMISSION: 
            case SETTIMES: 
            case RENEWDELEGATIONTOKEN: 
            case CANCELDELEGATIONTOKEN: 
            case MODIFYACLENTRIES: 
            case REMOVEACLENTRIES: 
            case REMOVEDEFAULTACL: 
            case REMOVEACL: 
            case SETACL: 
            case SETXATTR: 
            case REMOVEXATTR: 
            case ALLOWSNAPSHOT: 
            case CREATESNAPSHOT: 
            case RENAMESNAPSHOT: 
            case DISALLOWSNAPSHOT: 
            case SETSTORAGEPOLICY: {
                return super.put(ugi, delegation, username, doAsUser, fullpath, op, destination, owner, group, permission, unmaskedPermission, overwrite, bufferSize, replication, blockSize, modificationTime, accessTime, renameOptions, createParent, delegationTokenArgument, aclPermission, xattrName, xattrValue, xattrSetFlag, snapshotName, oldSnapshotName, exclDatanodes, createFlagParam, noredirectParam, policyName);
            }
        }
        throw new UnsupportedOperationException(op + " is not supported");
    }

    protected Response post(UserGroupInformation ugi, DelegationParam delegation, UserParam username, DoAsParam doAsUser, String fullpath, PostOpParam op, ConcatSourcesParam concatSrcs, BufferSizeParam bufferSize, ExcludeDatanodesParam excludeDatanodes, NewLengthParam newLength, NoRedirectParam noRedirectParam) throws IOException, URISyntaxException {
        switch ((PostOpParam.Op)op.getValue()) {
            case APPEND: {
                Router router = this.getRouter();
                URI uri = this.redirectURI(router, ugi, delegation, username, doAsUser, fullpath, (HttpOpParam.Op)op.getValue(), -1L, (String)excludeDatanodes.getValue(), new Param[]{bufferSize});
                if (!((Boolean)noRedirectParam.getValue()).booleanValue()) {
                    return Response.temporaryRedirect((URI)uri).type("application/octet-stream").build();
                }
                String js = JsonUtil.toJsonString((String)"Location", (Object)uri);
                return Response.ok((Object)js).type("application/json").build();
            }
            case CONCAT: 
            case TRUNCATE: 
            case UNSETSTORAGEPOLICY: {
                return super.post(ugi, delegation, username, doAsUser, fullpath, op, concatSrcs, bufferSize, excludeDatanodes, newLength, noRedirectParam);
            }
        }
        throw new UnsupportedOperationException(op + " is not supported");
    }

    protected Response get(UserGroupInformation ugi, DelegationParam delegation, UserParam username, DoAsParam doAsUser, String fullpath, GetOpParam op, OffsetParam offset, LengthParam length, RenewerParam renewer, BufferSizeParam bufferSize, List<XAttrNameParam> xattrNames, XAttrEncodingParam xattrEncoding, ExcludeDatanodesParam excludeDatanodes, FsActionParam fsAction, SnapshotNameParam snapshotName, OldSnapshotNameParam oldSnapshotName, TokenKindParam tokenKind, TokenServiceParam tokenService, NoRedirectParam noredirectParam, StartAfterParam startAfter) throws IOException, URISyntaxException {
        try {
            Router router = this.getRouter();
            switch ((GetOpParam.Op)op.getValue()) {
                case OPEN: {
                    URI uri = this.redirectURI(router, ugi, delegation, username, doAsUser, fullpath, (HttpOpParam.Op)op.getValue(), (Long)offset.getValue(), (String)excludeDatanodes.getValue(), new Param[]{offset, length, bufferSize});
                    if (!((Boolean)noredirectParam.getValue()).booleanValue()) {
                        Response response = Response.temporaryRedirect((URI)uri).type("application/octet-stream").build();
                        return response;
                    }
                    String js = JsonUtil.toJsonString((String)"Location", (Object)uri);
                    Response response = Response.ok((Object)js).type("application/json").build();
                    return response;
                }
                case GETFILECHECKSUM: {
                    URI uri = this.redirectURI(router, ugi, delegation, username, doAsUser, fullpath, (HttpOpParam.Op)op.getValue(), -1L, null, new Param[0]);
                    if (!((Boolean)noredirectParam.getValue()).booleanValue()) {
                        Response js = Response.temporaryRedirect((URI)uri).type("application/octet-stream").build();
                        return js;
                    }
                    String js = JsonUtil.toJsonString((String)"Location", (Object)uri);
                    Response response = Response.ok((Object)js).type("application/json").build();
                    return response;
                }
                case GET_BLOCK_LOCATIONS: 
                case GETFILESTATUS: 
                case LISTSTATUS: 
                case GETCONTENTSUMMARY: 
                case GETHOMEDIRECTORY: 
                case GETACLSTATUS: 
                case GETXATTRS: 
                case LISTXATTRS: 
                case CHECKACCESS: {
                    Response response = super.get(ugi, delegation, username, doAsUser, fullpath, op, offset, length, renewer, bufferSize, xattrNames, xattrEncoding, excludeDatanodes, fsAction, snapshotName, oldSnapshotName, tokenKind, tokenService, noredirectParam, startAfter);
                    return response;
                }
            }
            throw new UnsupportedOperationException(op + " is not supported");
        }
        finally {
            this.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private URI redirectURI(Router router, String path) throws IOException {
        HttpURLConnection conn = this.forwardRequest(router, path);
        try {
            conn.setInstanceFollowRedirects(false);
            conn.setDoOutput(true);
            conn.connect();
            int responseCode = conn.getResponseCode();
            if (responseCode != 307) {
                LOG.info("We expected a redirection from the Namenode, not {}", (Object)responseCode);
                URI uRI = null;
                return uRI;
            }
            String redirectLocation = conn.getHeaderField("Location");
            try {
                redirectLocation = redirectLocation.replaceAll("(?<=[?&;])namenoderpcaddress=.*?(?=[&;])", "namenoderpcaddress=" + router.getRouterId()).replaceAll("(?<=[/])webhdfs/v1/.*?(?=[?])", "webhdfs/v1" + path);
                URI uRI = new URI(redirectLocation);
                return uRI;
            }
            catch (URISyntaxException e) {
                LOG.error("Cannot parse redirect location {}", (Object)redirectLocation);
                if (conn != null) {
                    conn.disconnect();
                }
            }
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
        return null;
    }

    private HttpURLConnection forwardRequest(Router router, String path) throws IOException {
        Configuration conf = (Configuration)this.getContext().getAttribute("current.conf");
        URLConnectionFactory connectionFactory = URLConnectionFactory.newDefaultURLConnectionFactory((Configuration)conf);
        RouterRpcServer rpcServer = RouterWebHdfsMethods.getRPCServer(router);
        RemoteLocation createLoc = rpcServer.getCreateLocation(path);
        String nsId = createLoc.getNameserviceId();
        String dest = createLoc.getDest();
        ActiveNamenodeResolver nnResolver = router.getNamenodeResolver();
        List<? extends FederationNamenodeContext> namenodes = nnResolver.getNamenodesForNameserviceId(nsId);
        for (FederationNamenodeContext federationNamenodeContext : namenodes) {
            try {
                String nnWebAddress = federationNamenodeContext.getWebAddress();
                String[] nnWebAddressSplit = nnWebAddress.split(":");
                String host = nnWebAddressSplit[0];
                int port = Integer.parseInt(nnWebAddressSplit[1]);
                this.query = URLDecoder.decode(this.query, "UTF-8");
                URI uri = new URI(this.getScheme(), null, host, port, this.reqPath + dest, this.query, null);
                URL url = uri.toURL();
                HttpURLConnection conn = (HttpURLConnection)connectionFactory.openConnection(url);
                conn.setRequestMethod(this.method);
                return conn;
            }
            catch (Exception e) {
                LOG.error("Cannot redirect request to {}", (Object)federationNamenodeContext, (Object)e);
            }
        }
        return null;
    }

    private URI redirectURI(Router router, UserGroupInformation ugi, DelegationParam delegation, UserParam username, DoAsParam doAsUser, String path, HttpOpParam.Op op, long openOffset, String excludeDatanodes, Param<?, ?> ... parameters) throws URISyntaxException, IOException {
        String delegationQuery;
        DatanodeInfo dn = this.chooseDatanode(router, path, op, openOffset, excludeDatanodes);
        if (dn == null) {
            throw new IOException("Failed to find datanode, suggest to check cluster health. excludeDatanodes=" + excludeDatanodes);
        }
        if (!UserGroupInformation.isSecurityEnabled()) {
            delegationQuery = Param.toSortedString((String)"&", (Param[])new Param[]{doAsUser, username});
        } else if (delegation.getValue() != null) {
            delegationQuery = "&" + delegation;
        } else {
            Token<? extends TokenIdentifier> t = this.generateDelegationToken(router, ugi, this.request.getUserPrincipal().getName());
            delegationQuery = "&delegation=" + t.encodeToUrlString();
        }
        String redirectQuery = op.toQueryString() + delegationQuery + "&namenoderpcaddress=" + router.getRouterId() + Param.toSortedString((String)"&", parameters);
        String uripath = "/webhdfs/v1" + path;
        int port = "http".equals(this.getScheme()) ? dn.getInfoPort() : dn.getInfoSecurePort();
        URI uri = new URI(this.getScheme(), null, dn.getHostName(), port, uripath, redirectQuery, null);
        if (LOG.isTraceEnabled()) {
            LOG.trace("redirectURI={}", (Object)uri);
        }
        return uri;
    }

    private DatanodeInfo chooseDatanode(Router router, String path, HttpOpParam.Op op, long openOffset, String excludeDatanodes) throws IOException {
        final RouterRpcServer rpcServer = RouterWebHdfsMethods.getRPCServer(router);
        UserGroupInformation loginUser = UserGroupInformation.getLoginUser();
        DatanodeInfo[] dns = (DatanodeInfo[])loginUser.doAs((PrivilegedAction)new PrivilegedAction<DatanodeInfo[]>(){

            @Override
            public DatanodeInfo[] run() {
                try {
                    return rpcServer.getDatanodeReport(HdfsConstants.DatanodeReportType.LIVE);
                }
                catch (IOException e) {
                    LOG.error("Cannot get the datanodes from the RPC server", (Throwable)e);
                    return null;
                }
            }
        });
        HashSet<Node> excludes = new HashSet<Node>();
        if (excludeDatanodes != null) {
            Collection collection = StringUtils.getTrimmedStringCollection((String)excludeDatanodes);
            for (DatanodeInfo dn : dns) {
                if (!collection.contains(dn.getName())) continue;
                excludes.add((Node)dn);
            }
        }
        if (op == GetOpParam.Op.OPEN || op == PostOpParam.Op.APPEND || op == GetOpParam.Op.GETFILECHECKSUM) {
            long offset;
            LocatedBlocks locations;
            int count;
            ClientProtocol cp = this.getRpcClientProtocol();
            HdfsFileStatus status = cp.getFileInfo(path);
            if (status == null) {
                throw new FileNotFoundException("File " + path + " not found.");
            }
            long len = status.getLen();
            if (op == GetOpParam.Op.OPEN && (openOffset < 0L || openOffset >= len && len > 0L)) {
                throw new IOException("Offset=" + openOffset + " out of the range [0, " + len + "); " + op + ", path=" + path);
            }
            if (len > 0L && (count = (locations = cp.getBlockLocations(path, offset = op == GetOpParam.Op.OPEN ? openOffset : len - 1L, 1L)).locatedBlockCount()) > 0) {
                LocatedBlock location0 = locations.get(0);
                return RouterWebHdfsMethods.bestNode((DatanodeInfo[])location0.getLocations(), excludes);
            }
        }
        return RouterWebHdfsMethods.getRandomDatanode(dns, excludes);
    }

    private static DatanodeInfo getRandomDatanode(DatanodeInfo[] dns, HashSet<Node> excludes) {
        DatanodeInfo dn = null;
        if (dns == null) {
            return dn;
        }
        int numDNs = dns.length;
        int availableNodes = 0;
        if (excludes.isEmpty()) {
            availableNodes = numDNs;
        } else {
            for (DatanodeInfo di : dns) {
                if (excludes.contains(di)) continue;
                ++availableNodes;
            }
        }
        if (availableNodes > 0) {
            while (dn == null || excludes.contains(dn)) {
                Random rnd = new Random();
                int idx = rnd.nextInt(numDNs);
                dn = dns[idx];
            }
        }
        return dn;
    }

    private Token<? extends TokenIdentifier> generateDelegationToken(Router router, UserGroupInformation ugi, String renewer) throws IOException {
        throw new UnsupportedOperationException("TODO Generate token for ugi=" + ugi + " request=" + this.request);
    }
}

