/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.metrics;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import java.util.stream.Collectors;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.server.federation.metrics.FederationMBean;
import org.apache.hadoop.hdfs.server.federation.metrics.RouterMBean;
import org.apache.hadoop.hdfs.server.federation.resolver.ActiveNamenodeResolver;
import org.apache.hadoop.hdfs.server.federation.resolver.FederationNamenodeContext;
import org.apache.hadoop.hdfs.server.federation.resolver.FederationNamespaceInfo;
import org.apache.hadoop.hdfs.server.federation.resolver.RemoteLocation;
import org.apache.hadoop.hdfs.server.federation.router.Router;
import org.apache.hadoop.hdfs.server.federation.router.RouterRpcServer;
import org.apache.hadoop.hdfs.server.federation.router.RouterServiceState;
import org.apache.hadoop.hdfs.server.federation.router.security.RouterSecurityManager;
import org.apache.hadoop.hdfs.server.federation.store.MembershipStore;
import org.apache.hadoop.hdfs.server.federation.store.MountTableStore;
import org.apache.hadoop.hdfs.server.federation.store.RouterStore;
import org.apache.hadoop.hdfs.server.federation.store.StateStoreService;
import org.apache.hadoop.hdfs.server.federation.store.protocol.GetMountTableEntriesRequest;
import org.apache.hadoop.hdfs.server.federation.store.protocol.GetMountTableEntriesResponse;
import org.apache.hadoop.hdfs.server.federation.store.protocol.GetNamenodeRegistrationsRequest;
import org.apache.hadoop.hdfs.server.federation.store.protocol.GetNamenodeRegistrationsResponse;
import org.apache.hadoop.hdfs.server.federation.store.protocol.GetNamespaceInfoRequest;
import org.apache.hadoop.hdfs.server.federation.store.protocol.GetNamespaceInfoResponse;
import org.apache.hadoop.hdfs.server.federation.store.protocol.GetRouterRegistrationsRequest;
import org.apache.hadoop.hdfs.server.federation.store.protocol.GetRouterRegistrationsResponse;
import org.apache.hadoop.hdfs.server.federation.store.records.BaseRecord;
import org.apache.hadoop.hdfs.server.federation.store.records.MembershipState;
import org.apache.hadoop.hdfs.server.federation.store.records.MembershipStats;
import org.apache.hadoop.hdfs.server.federation.store.records.MountTable;
import org.apache.hadoop.hdfs.server.federation.store.records.RouterState;
import org.apache.hadoop.hdfs.server.federation.store.records.StateStoreVersion;
import org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.hadoop.metrics2.util.MBeans;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.Time;
import org.apache.hadoop.util.VersionInfo;
import org.codehaus.jettison.json.JSONObject;
import org.eclipse.jetty.util.ajax.JSON;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metrics(name="RBFActivity", about="RBF metrics", context="dfs")
public class RBFMetrics
implements RouterMBean,
FederationMBean {
    private static final Logger LOG = LoggerFactory.getLogger(RBFMetrics.class);
    private static final String DATE_FORMAT = "yyyy/MM/dd HH:mm:ss";
    private final long timeOut;
    private final Router router;
    private ObjectName routerBeanName;
    private ObjectName federationBeanName;
    private final ActiveNamenodeResolver namenodeResolver;
    private final StateStoreService stateStore;
    private MembershipStore membershipStore;
    private MountTableStore mountTableStore;
    private RouterStore routerStore;

    public RBFMetrics(Router router) throws IOException {
        StandardMBean bean;
        this.router = router;
        try {
            bean = new StandardMBean(this, RouterMBean.class);
            this.routerBeanName = MBeans.register((String)"Router", (String)"Router", (Object)bean);
            LOG.info("Registered Router MBean: {}", (Object)this.routerBeanName);
        }
        catch (NotCompliantMBeanException e) {
            throw new RuntimeException("Bad Router MBean setup", e);
        }
        try {
            bean = new StandardMBean(this, FederationMBean.class);
            this.federationBeanName = MBeans.register((String)"Router", (String)"FederationState", (Object)bean);
            LOG.info("Registered FederationState MBean: {}", (Object)this.federationBeanName);
        }
        catch (NotCompliantMBeanException e) {
            throw new RuntimeException("Bad FederationState MBean setup", e);
        }
        this.namenodeResolver = this.router.getNamenodeResolver();
        this.stateStore = this.router.getStateStore();
        if (this.stateStore == null) {
            LOG.error("State store not available");
        } else {
            this.membershipStore = this.stateStore.getRegisteredRecordStore(MembershipStore.class);
            this.mountTableStore = this.stateStore.getRegisteredRecordStore(MountTableStore.class);
            this.routerStore = this.stateStore.getRegisteredRecordStore(RouterStore.class);
        }
        Configuration conf = router.getConfig();
        this.timeOut = conf.getTimeDuration("dfs.federation.router.dn-report.time-out", 1000L, TimeUnit.MILLISECONDS);
    }

    public void close() {
        if (this.routerBeanName != null) {
            MBeans.unregister((ObjectName)this.routerBeanName);
        }
        if (this.federationBeanName != null) {
            MBeans.unregister((ObjectName)this.federationBeanName);
        }
    }

    @Override
    public String getNamenodes() {
        LinkedHashMap info = new LinkedHashMap();
        if (this.membershipStore == null) {
            return "{}";
        }
        try {
            GetNamenodeRegistrationsRequest request = GetNamenodeRegistrationsRequest.newInstance();
            GetNamenodeRegistrationsResponse response = this.membershipStore.getNamenodeRegistrations(request);
            List<MembershipState> namenodes = response.getNamenodeMemberships();
            if (namenodes == null || namenodes.size() == 0) {
                return JSON.toString(info);
            }
            ArrayList<MembershipState> namenodesOrder = new ArrayList<MembershipState>(namenodes);
            Collections.sort(namenodesOrder, MembershipState.NAME_COMPARATOR);
            for (MembershipState namenode : namenodesOrder) {
                HashMap<String, Object> innerInfo = new HashMap<String, Object>();
                Map<String, Object> map = RBFMetrics.getJson(namenode);
                innerInfo.putAll(map);
                long dateModified = namenode.getDateModified();
                long lastHeartbeat = RBFMetrics.getSecondsSince(dateModified);
                innerInfo.put("lastHeartbeat", lastHeartbeat);
                MembershipStats stats = namenode.getStats();
                long used = stats.getTotalSpace() - stats.getAvailableSpace();
                innerInfo.put("used", used);
                info.put(namenode.getNamenodeKey(), Collections.unmodifiableMap(innerInfo));
            }
        }
        catch (IOException e) {
            LOG.error("Enable to fetch json representation of namenodes {}", (Object)e.getMessage());
            return "{}";
        }
        return JSON.toString(info);
    }

    @Override
    public String getNameservices() {
        LinkedHashMap info = new LinkedHashMap();
        try {
            List<MembershipState> namenodes = this.getActiveNamenodeRegistrations();
            ArrayList<MembershipState> namenodesOrder = new ArrayList<MembershipState>(namenodes);
            Collections.sort(namenodesOrder, MembershipState.NAME_COMPARATOR);
            for (MembershipState namenode : namenodesOrder) {
                HashMap<String, Object> innerInfo = new HashMap<String, Object>();
                Map<String, Object> map = RBFMetrics.getJson(namenode);
                innerInfo.putAll(map);
                long dateModified = namenode.getDateModified();
                long lastHeartbeat = RBFMetrics.getSecondsSince(dateModified);
                innerInfo.put("lastHeartbeat", lastHeartbeat);
                MembershipStats stats = namenode.getStats();
                long used = stats.getTotalSpace() - stats.getAvailableSpace();
                innerInfo.put("used", used);
                info.put(namenode.getNamenodeKey(), Collections.unmodifiableMap(innerInfo));
            }
        }
        catch (IOException e) {
            LOG.error("Cannot retrieve nameservices for JMX: {}", (Object)e.getMessage());
            return "{}";
        }
        return JSON.toString(info);
    }

    @Override
    public String getMountTable() {
        LinkedList info = new LinkedList();
        if (this.mountTableStore == null) {
            return "[]";
        }
        try {
            GetMountTableEntriesRequest request = GetMountTableEntriesRequest.newInstance("/");
            GetMountTableEntriesResponse response = this.mountTableStore.getMountTableEntries(request);
            List<MountTable> mounts = response.getEntries();
            ArrayList<MountTable> orderedMounts = new ArrayList<MountTable>(mounts);
            Collections.sort(orderedMounts, MountTable.SOURCE_COMPARATOR);
            for (MountTable entry : orderedMounts) {
                LinkedHashSet<String> nameservices = new LinkedHashSet<String>();
                LinkedHashSet<String> paths = new LinkedHashSet<String>();
                for (RemoteLocation location : entry.getDestinations()) {
                    nameservices.add(location.getNameserviceId());
                    paths.add(location.getDest());
                }
                Map<String, Object> map = RBFMetrics.getJson(entry);
                map.put("dateCreated", RBFMetrics.getDateString(entry.getDateCreated()));
                map.put("dateModified", RBFMetrics.getDateString(entry.getDateModified()));
                HashMap<String, Object> innerInfo = new HashMap<String, Object>();
                innerInfo.putAll(map);
                innerInfo.put("nameserviceId", StringUtils.join((CharSequence)",", nameservices));
                innerInfo.put("path", StringUtils.join((CharSequence)",", paths));
                if (nameservices.size() > 1) {
                    innerInfo.put("order", entry.getDestOrder().toString());
                } else {
                    innerInfo.put("order", "");
                }
                innerInfo.put("readonly", entry.isReadOnly());
                innerInfo.put("faulttolerant", entry.isFaultTolerant());
                info.add(Collections.unmodifiableMap(innerInfo));
            }
        }
        catch (IOException e) {
            LOG.error("Cannot generate JSON of mount table from store: {}", (Object)e.getMessage());
            return "[]";
        }
        return JSON.toString(info);
    }

    @Override
    public String getRouters() {
        LinkedHashMap<String, Map<String, Object>> info = new LinkedHashMap<String, Map<String, Object>>();
        if (this.routerStore == null) {
            return "{}";
        }
        try {
            GetRouterRegistrationsRequest request = GetRouterRegistrationsRequest.newInstance();
            GetRouterRegistrationsResponse response = this.routerStore.getRouterRegistrations(request);
            List<RouterState> routers = response.getRouters();
            ArrayList<RouterState> routersOrder = new ArrayList<RouterState>(routers);
            Collections.sort(routersOrder);
            for (RouterState record : routersOrder) {
                HashMap<String, Object> innerInfo = new HashMap<String, Object>();
                Map<String, Object> map = RBFMetrics.getJson(record);
                innerInfo.putAll(map);
                long dateModified = record.getDateModified();
                long lastHeartbeat = RBFMetrics.getSecondsSince(dateModified);
                innerInfo.put("lastHeartbeat", lastHeartbeat);
                StateStoreVersion stateStoreVersion = record.getStateStoreVersion();
                if (stateStoreVersion == null) {
                    LOG.error("Cannot get State Store versions");
                } else {
                    RBFMetrics.setStateStoreVersions(innerInfo, stateStoreVersion);
                }
                info.put(record.getPrimaryKey(), Collections.unmodifiableMap(innerInfo));
            }
        }
        catch (IOException e) {
            LOG.error("Cannot get Routers JSON from the State Store", (Throwable)e);
            return "{}";
        }
        return JSON.toString(info);
    }

    private static void setStateStoreVersions(Map<String, Object> map, StateStoreVersion version) {
        long membershipVersion = version.getMembershipVersion();
        String lastMembershipUpdate = RBFMetrics.getDateString(membershipVersion);
        map.put("lastMembershipUpdate", lastMembershipUpdate);
        long mountTableVersion = version.getMountTableVersion();
        String lastMountTableDate = RBFMetrics.getDateString(mountTableVersion);
        map.put("lastMountTableUpdate", lastMountTableDate);
    }

    @Override
    public long getTotalCapacity() {
        return this.getNameserviceAggregatedLong(MembershipStats::getTotalSpace);
    }

    @Override
    public long getRemainingCapacity() {
        return this.getNameserviceAggregatedLong(MembershipStats::getAvailableSpace);
    }

    @Override
    public long getProvidedSpace() {
        return this.getNameserviceAggregatedLong(MembershipStats::getProvidedSpace);
    }

    @Override
    public long getUsedCapacity() {
        return this.getTotalCapacity() - this.getRemainingCapacity();
    }

    @Override
    public int getNumNameservices() {
        try {
            Set<FederationNamespaceInfo> nss = this.namenodeResolver.getNamespaces();
            return nss.size();
        }
        catch (IOException e) {
            LOG.error("Cannot fetch number of expired registrations from the store: {}", (Object)e.getMessage());
            return 0;
        }
    }

    @Override
    public int getNumNamenodes() {
        if (this.membershipStore == null) {
            return 0;
        }
        try {
            GetNamenodeRegistrationsRequest request = GetNamenodeRegistrationsRequest.newInstance();
            GetNamenodeRegistrationsResponse response = this.membershipStore.getNamenodeRegistrations(request);
            List<MembershipState> memberships = response.getNamenodeMemberships();
            return memberships.size();
        }
        catch (IOException e) {
            LOG.error("Cannot retrieve numNamenodes for JMX: {}", (Object)e.getMessage());
            return 0;
        }
    }

    @Override
    public int getNumExpiredNamenodes() {
        if (this.membershipStore == null) {
            return 0;
        }
        try {
            GetNamenodeRegistrationsRequest request = GetNamenodeRegistrationsRequest.newInstance();
            GetNamenodeRegistrationsResponse response = this.membershipStore.getExpiredNamenodeRegistrations(request);
            List<MembershipState> expiredMemberships = response.getNamenodeMemberships();
            return expiredMemberships.size();
        }
        catch (IOException e) {
            LOG.error("Cannot retrieve numExpiredNamenodes for JMX: {}", (Object)e.getMessage());
            return 0;
        }
    }

    @Override
    public int getNumLiveNodes() {
        return this.getNameserviceAggregatedInt(MembershipStats::getNumOfActiveDatanodes);
    }

    @Override
    public int getNumDeadNodes() {
        return this.getNameserviceAggregatedInt(MembershipStats::getNumOfDeadDatanodes);
    }

    @Override
    public int getNumStaleNodes() {
        return this.getNameserviceAggregatedInt(MembershipStats::getNumOfStaleDatanodes);
    }

    @Override
    public int getNumDecommissioningNodes() {
        return this.getNameserviceAggregatedInt(MembershipStats::getNumOfDecommissioningDatanodes);
    }

    @Override
    public int getNumDecomLiveNodes() {
        return this.getNameserviceAggregatedInt(MembershipStats::getNumOfDecomActiveDatanodes);
    }

    @Override
    public int getNumDecomDeadNodes() {
        return this.getNameserviceAggregatedInt(MembershipStats::getNumOfDecomDeadDatanodes);
    }

    @Override
    public int getNumInMaintenanceLiveDataNodes() {
        return this.getNameserviceAggregatedInt(MembershipStats::getNumOfInMaintenanceLiveDataNodes);
    }

    @Override
    public int getNumInMaintenanceDeadDataNodes() {
        return this.getNameserviceAggregatedInt(MembershipStats::getNumOfInMaintenanceDeadDataNodes);
    }

    @Override
    public int getNumEnteringMaintenanceDataNodes() {
        return this.getNameserviceAggregatedInt(MembershipStats::getNumOfEnteringMaintenanceDataNodes);
    }

    @Override
    public String getNodeUsage() {
        float median = 0.0f;
        float max = 0.0f;
        float min = 0.0f;
        float dev = 0.0f;
        HashMap info = new HashMap();
        try {
            RouterRpcServer rpcServer = this.router.getRpcServer();
            DatanodeInfo[] live = rpcServer.getDatanodeReport(HdfsConstants.DatanodeReportType.LIVE, false, this.timeOut);
            if (live.length > 0) {
                float totalDfsUsed = 0.0f;
                float[] usages = new float[live.length];
                int i = 0;
                for (DatanodeInfo dn : live) {
                    usages[i++] = dn.getDfsUsedPercent();
                    totalDfsUsed += dn.getDfsUsedPercent();
                }
                totalDfsUsed /= (float)live.length;
                Arrays.sort(usages);
                median = usages[usages.length / 2];
                max = usages[usages.length - 1];
                min = usages[0];
                for (i = 0; i < usages.length; ++i) {
                    dev += (usages[i] - totalDfsUsed) * (usages[i] - totalDfsUsed);
                }
                dev = (float)Math.sqrt(dev / (float)usages.length);
            }
        }
        catch (IOException e) {
            LOG.error("Cannot get the live nodes: {}", (Object)e.getMessage());
        }
        HashMap<String, String> innerInfo = new HashMap<String, String>();
        innerInfo.put("min", StringUtils.format((String)"%.2f%%", (Object[])new Object[]{Float.valueOf(min)}));
        innerInfo.put("median", StringUtils.format((String)"%.2f%%", (Object[])new Object[]{Float.valueOf(median)}));
        innerInfo.put("max", StringUtils.format((String)"%.2f%%", (Object[])new Object[]{Float.valueOf(max)}));
        innerInfo.put("stdDev", StringUtils.format((String)"%.2f%%", (Object[])new Object[]{Float.valueOf(dev)}));
        info.put("nodeUsage", innerInfo);
        return JSON.toString(info);
    }

    @Override
    public long getNumBlocks() {
        return this.getNameserviceAggregatedLong(MembershipStats::getNumOfBlocks);
    }

    @Override
    public long getNumOfMissingBlocks() {
        return this.getNameserviceAggregatedLong(MembershipStats::getNumOfBlocksMissing);
    }

    @Override
    public long getNumOfBlocksPendingReplication() {
        return this.getNameserviceAggregatedLong(MembershipStats::getNumOfBlocksPendingReplication);
    }

    @Override
    public long getNumOfBlocksUnderReplicated() {
        return this.getNameserviceAggregatedLong(MembershipStats::getNumOfBlocksUnderReplicated);
    }

    @Override
    public long getNumOfBlocksPendingDeletion() {
        return this.getNameserviceAggregatedLong(MembershipStats::getNumOfBlocksPendingDeletion);
    }

    @Override
    public long getNumFiles() {
        return this.getNameserviceAggregatedLong(MembershipStats::getNumOfFiles);
    }

    @Override
    public String getRouterStarted() {
        long startTime = this.router.getStartTime();
        return new Date(startTime).toString();
    }

    @Override
    public String getVersion() {
        return VersionInfo.getVersion() + ", r" + VersionInfo.getRevision();
    }

    @Override
    public String getCompiledDate() {
        return VersionInfo.getDate();
    }

    @Override
    public String getCompileInfo() {
        return VersionInfo.getDate() + " by " + VersionInfo.getUser() + " from " + VersionInfo.getBranch();
    }

    @Override
    public String getHostAndPort() {
        InetSocketAddress address = this.router.getRpcServerAddress();
        if (address != null) {
            try {
                String hostname = InetAddress.getLocalHost().getHostName();
                int port = address.getPort();
                return hostname + ":" + port;
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        return "Unknown";
    }

    @Override
    public String getRouterId() {
        return this.router.getRouterId();
    }

    @Override
    public String getClusterId() {
        try {
            Collection<String> clusterIds = this.getNamespaceInfo(FederationNamespaceInfo::getClusterId);
            return clusterIds.toString();
        }
        catch (IOException e) {
            LOG.error("Cannot fetch cluster ID metrics: {}", (Object)e.getMessage());
            return "";
        }
    }

    @Override
    public String getBlockPoolId() {
        try {
            Collection<String> blockpoolIds = this.getNamespaceInfo(FederationNamespaceInfo::getBlockPoolId);
            return blockpoolIds.toString();
        }
        catch (IOException e) {
            LOG.error("Cannot fetch block pool ID metrics: {}", (Object)e.getMessage());
            return "";
        }
    }

    @Override
    public String getRouterStatus() {
        return this.router.getRouterState().toString();
    }

    @Override
    public long getCurrentTokensCount() {
        RouterSecurityManager mgr = this.router.getRpcServer().getRouterSecurityManager();
        if (mgr != null && mgr.getSecretManager() != null) {
            return mgr.getSecretManager().getCurrentTokensSize();
        }
        return -1L;
    }

    @Override
    public boolean isSecurityEnabled() {
        return UserGroupInformation.isSecurityEnabled();
    }

    @Override
    public String getSafemode() {
        if (this.router.isRouterState(RouterServiceState.SAFEMODE)) {
            return "Safe mode is ON. " + this.getSafeModeTip();
        }
        return "";
    }

    private String getSafeModeTip() {
        String cmd = "Use \"hdfs dfsrouteradmin -safemode leave\" to turn safe mode off.";
        if (this.router.isRouterState(RouterServiceState.INITIALIZING) || this.router.isRouterState(RouterServiceState.UNINITIALIZED)) {
            return "Router is in" + (Object)((Object)this.router.getRouterState()) + "mode, the router will immediately return to normal mode after some time. " + cmd;
        }
        if (this.router.isRouterState(RouterServiceState.SAFEMODE)) {
            return "It was turned on manually. " + cmd;
        }
        return "";
    }

    private Collection<String> getNamespaceInfo(Function<FederationNamespaceInfo, String> f) throws IOException {
        if (this.membershipStore == null) {
            return new HashSet<String>();
        }
        GetNamespaceInfoRequest request = GetNamespaceInfoRequest.newInstance();
        GetNamespaceInfoResponse response = this.membershipStore.getNamespaceInfo(request);
        return response.getNamespaceInfo().stream().map(f).collect(Collectors.toSet());
    }

    private int getNameserviceAggregatedInt(ToIntFunction<MembershipStats> f) {
        try {
            return this.getActiveNamenodeRegistrations().stream().map(MembershipState::getStats).collect(Collectors.summingInt(f));
        }
        catch (IOException e) {
            LOG.error("Unable to extract metrics: {}", (Object)e.getMessage());
            return 0;
        }
    }

    private long getNameserviceAggregatedLong(ToLongFunction<MembershipStats> f) {
        try {
            return this.getActiveNamenodeRegistrations().stream().map(MembershipState::getStats).collect(Collectors.summingLong(f));
        }
        catch (IOException e) {
            LOG.error("Unable to extract metrics: {}", (Object)e.getMessage());
            return 0L;
        }
    }

    private List<MembershipState> getActiveNamenodeRegistrations() throws IOException {
        ArrayList<MembershipState> resultList = new ArrayList<MembershipState>();
        if (this.membershipStore == null) {
            return resultList;
        }
        GetNamespaceInfoRequest request = GetNamespaceInfoRequest.newInstance();
        GetNamespaceInfoResponse response = this.membershipStore.getNamespaceInfo(request);
        for (FederationNamespaceInfo nsInfo : response.getNamespaceInfo()) {
            FederationNamenodeContext nn;
            String nsId = nsInfo.getNameserviceId();
            List<? extends FederationNamenodeContext> nns = this.namenodeResolver.getNamenodesForNameserviceId(nsId);
            if (nns == null || !((nn = nns.get(0)) instanceof MembershipState)) continue;
            resultList.add((MembershipState)nn);
        }
        return resultList;
    }

    @VisibleForTesting
    static String getDateString(long time) {
        if (time <= 0L) {
            return "-";
        }
        Date date = new Date(time);
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT);
        return sdf.format(date);
    }

    private static long getSecondsSince(long timeMs) {
        if (timeMs < 0L) {
            return -1L;
        }
        return (Time.now() - timeMs) / 1000L;
    }

    private static Map<String, Object> getJson(BaseRecord record) {
        HashMap<String, Object> json = new HashMap<String, Object>();
        Map<String, Class<?>> fields = RBFMetrics.getFields(record);
        for (String fieldName : fields.keySet()) {
            if (fieldName.equalsIgnoreCase("proto")) continue;
            try {
                Object value = RBFMetrics.getField(record, fieldName);
                if (value instanceof BaseRecord) {
                    BaseRecord recordField = (BaseRecord)value;
                    json.putAll(RBFMetrics.getJson(recordField));
                    continue;
                }
                json.put(fieldName, value == null ? JSONObject.NULL : value);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Cannot serialize field " + fieldName + " into JSON");
            }
        }
        return json;
    }

    private static Map<String, Class<?>> getFields(BaseRecord record) {
        HashMap getters = new HashMap();
        for (Method m : record.getClass().getDeclaredMethods()) {
            if (!m.getName().startsWith("get")) continue;
            try {
                Class<?> type = m.getReturnType();
                char[] c = m.getName().substring(3).toCharArray();
                c[0] = Character.toLowerCase(c[0]);
                String key = new String(c);
                getters.put(key, type);
            }
            catch (Exception e) {
                LOG.error("Cannot execute getter {} on {}", (Object)m.getName(), (Object)record);
            }
        }
        return getters;
    }

    private static Object getField(BaseRecord record, String fieldName) {
        Object result = null;
        Method m = RBFMetrics.locateGetter(record, fieldName);
        if (m != null) {
            try {
                result = m.invoke((Object)record, new Object[0]);
            }
            catch (Exception e) {
                LOG.error("Cannot get field {} on {}", (Object)fieldName, (Object)record);
            }
        }
        return result;
    }

    private static Method locateGetter(BaseRecord record, String fieldName) {
        for (Method m : record.getClass().getMethods()) {
            if (!m.getName().equalsIgnoreCase("get" + fieldName)) continue;
            return m;
        }
        return null;
    }
}

