/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.resolver;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.server.federation.resolver.ActiveNamenodeResolver;
import org.apache.hadoop.hdfs.server.federation.resolver.FederationNamenodeContext;
import org.apache.hadoop.hdfs.server.federation.resolver.FederationNamenodeServiceState;
import org.apache.hadoop.hdfs.server.federation.resolver.FederationNamespaceInfo;
import org.apache.hadoop.hdfs.server.federation.resolver.NamenodePriorityComparator;
import org.apache.hadoop.hdfs.server.federation.resolver.NamenodeStatusReport;
import org.apache.hadoop.hdfs.server.federation.store.DisabledNameserviceStore;
import org.apache.hadoop.hdfs.server.federation.store.MembershipStore;
import org.apache.hadoop.hdfs.server.federation.store.RecordStore;
import org.apache.hadoop.hdfs.server.federation.store.StateStoreCache;
import org.apache.hadoop.hdfs.server.federation.store.StateStoreService;
import org.apache.hadoop.hdfs.server.federation.store.StateStoreUnavailableException;
import org.apache.hadoop.hdfs.server.federation.store.protocol.GetNamenodeRegistrationsRequest;
import org.apache.hadoop.hdfs.server.federation.store.protocol.GetNamenodeRegistrationsResponse;
import org.apache.hadoop.hdfs.server.federation.store.protocol.GetNamespaceInfoRequest;
import org.apache.hadoop.hdfs.server.federation.store.protocol.GetNamespaceInfoResponse;
import org.apache.hadoop.hdfs.server.federation.store.protocol.NamenodeHeartbeatRequest;
import org.apache.hadoop.hdfs.server.federation.store.protocol.UpdateNamenodeRegistrationRequest;
import org.apache.hadoop.hdfs.server.federation.store.records.MembershipState;
import org.apache.hadoop.hdfs.server.federation.store.records.MembershipStats;
import org.apache.hadoop.util.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MembershipNamenodeResolver
implements ActiveNamenodeResolver,
StateStoreCache {
    private static final Logger LOG = LoggerFactory.getLogger(MembershipNamenodeResolver.class);
    private final StateStoreService stateStore;
    private MembershipStore membershipInterface;
    private DisabledNameserviceStore disabledNameserviceInterface;
    private String routerId;
    private Map<String, List<? extends FederationNamenodeContext>> cacheNS;
    private Map<String, List<? extends FederationNamenodeContext>> cacheBP;

    public MembershipNamenodeResolver(Configuration conf, StateStoreService store) throws IOException {
        this.stateStore = store;
        this.cacheNS = new ConcurrentHashMap<String, List<? extends FederationNamenodeContext>>();
        this.cacheBP = new ConcurrentHashMap<String, List<? extends FederationNamenodeContext>>();
        if (this.stateStore != null) {
            this.stateStore.registerCacheExternal(this);
        }
    }

    private synchronized MembershipStore getMembershipStore() throws IOException {
        if (this.membershipInterface == null) {
            this.membershipInterface = this.getStoreInterface(MembershipStore.class);
        }
        return this.membershipInterface;
    }

    private synchronized DisabledNameserviceStore getDisabledNameserviceStore() throws IOException {
        if (this.disabledNameserviceInterface == null) {
            this.disabledNameserviceInterface = this.getStoreInterface(DisabledNameserviceStore.class);
        }
        return this.disabledNameserviceInterface;
    }

    private <T extends RecordStore<?>> T getStoreInterface(Class<T> clazz) throws IOException {
        T store = this.stateStore.getRegisteredRecordStore(clazz);
        if (store == null) {
            throw new IOException("State Store does not have an interface for " + clazz.getSimpleName());
        }
        return store;
    }

    @Override
    public boolean loadCache(boolean force) {
        try {
            MembershipStore membership = this.getMembershipStore();
            membership.loadCache(force);
            DisabledNameserviceStore disabled = this.getDisabledNameserviceStore();
            disabled.loadCache(force);
        }
        catch (IOException e) {
            LOG.error("Cannot update membership from the State Store", (Throwable)e);
        }
        this.cacheBP.clear();
        this.cacheNS.clear();
        return true;
    }

    @Override
    public void updateActiveNamenode(String nsId, InetSocketAddress address) throws IOException {
        try {
            MembershipState partial = MembershipState.newInstance();
            String rpcAddress = address.getHostName() + ":" + address.getPort();
            partial.setRpcAddress(rpcAddress);
            partial.setNameserviceId(nsId);
            GetNamenodeRegistrationsRequest request = GetNamenodeRegistrationsRequest.newInstance(partial);
            MembershipStore membership = this.getMembershipStore();
            GetNamenodeRegistrationsResponse response = membership.getNamenodeRegistrations(request);
            List<MembershipState> records = response.getNamenodeMemberships();
            if (records != null && records.size() == 1) {
                MembershipState record = records.get(0);
                UpdateNamenodeRegistrationRequest updateRequest = UpdateNamenodeRegistrationRequest.newInstance(record.getNameserviceId(), record.getNamenodeId(), FederationNamenodeServiceState.ACTIVE);
                membership.updateNamenodeRegistration(updateRequest);
                this.cacheNS.remove(nsId);
                this.cacheBP.clear();
            }
        }
        catch (StateStoreUnavailableException e) {
            LOG.error("Cannot update {} as active, State Store unavailable", (Object)address);
        }
    }

    @Override
    public List<? extends FederationNamenodeContext> getNamenodesForNameserviceId(String nsId) throws IOException {
        List<MembershipState> result;
        List<? extends FederationNamenodeContext> ret = this.cacheNS.get(nsId);
        if (ret != null) {
            return ret;
        }
        try {
            MembershipState partial = MembershipState.newInstance();
            partial.setNameserviceId(nsId);
            GetNamenodeRegistrationsRequest request = GetNamenodeRegistrationsRequest.newInstance(partial);
            result = this.getRecentRegistrationForQuery(request, true, false);
        }
        catch (StateStoreUnavailableException e) {
            LOG.error("Cannot get active NN for {}, State Store unavailable", (Object)nsId);
            return null;
        }
        if (result == null || result.isEmpty()) {
            LOG.error("Cannot locate eligible NNs for {}", (Object)nsId);
            return null;
        }
        try {
            Set<String> disabled = this.getDisabledNameserviceStore().getDisabledNameservices();
            if (disabled == null) {
                LOG.error("Cannot get disabled name services");
            } else {
                for (MembershipState nn : result) {
                    if (!disabled.contains(nn.getNameserviceId())) continue;
                    nn.setState(FederationNamenodeServiceState.DISABLED);
                }
            }
        }
        catch (StateStoreUnavailableException e) {
            LOG.error("Cannot get disabled name services, State Store unavailable");
        }
        ret = Collections.unmodifiableList(result);
        this.cacheNS.put(nsId, result);
        return ret;
    }

    @Override
    public List<? extends FederationNamenodeContext> getNamenodesForBlockPoolId(String bpId) throws IOException {
        List<? extends FederationNamenodeContext> ret = this.cacheBP.get(bpId);
        if (ret == null) {
            try {
                MembershipState partial = MembershipState.newInstance();
                partial.setBlockPoolId(bpId);
                GetNamenodeRegistrationsRequest request = GetNamenodeRegistrationsRequest.newInstance(partial);
                List<MembershipState> result = this.getRecentRegistrationForQuery(request, true, false);
                if (result == null || result.isEmpty()) {
                    LOG.error("Cannot locate eligible NNs for {}", (Object)bpId);
                } else {
                    this.cacheBP.put(bpId, result);
                    ret = result;
                }
            }
            catch (StateStoreUnavailableException e) {
                LOG.error("Cannot get active NN for {}, State Store unavailable", (Object)bpId);
                return null;
            }
        }
        if (ret == null) {
            return null;
        }
        return Collections.unmodifiableList(ret);
    }

    @Override
    public boolean registerNamenode(NamenodeStatusReport report) throws IOException {
        if (this.routerId == null) {
            LOG.warn("Cannot register namenode, router ID is not known {}", (Object)report);
            return false;
        }
        MembershipState record = MembershipState.newInstance(this.routerId, report.getNameserviceId(), report.getNamenodeId(), report.getClusterId(), report.getBlockPoolId(), report.getRpcAddress(), report.getServiceAddress(), report.getLifelineAddress(), report.getWebScheme(), report.getWebAddress(), report.getState(), report.getSafemode());
        if (report.statsValid()) {
            MembershipStats stats = MembershipStats.newInstance();
            stats.setNumOfFiles(report.getNumFiles());
            stats.setNumOfBlocks(report.getNumBlocks());
            stats.setNumOfBlocksMissing(report.getNumBlocksMissing());
            stats.setNumOfBlocksPendingReplication(report.getNumOfBlocksPendingReplication());
            stats.setNumOfBlocksUnderReplicated(report.getNumOfBlocksUnderReplicated());
            stats.setNumOfBlocksPendingDeletion(report.getNumOfBlocksPendingDeletion());
            stats.setAvailableSpace(report.getAvailableSpace());
            stats.setTotalSpace(report.getTotalSpace());
            stats.setProvidedSpace(report.getProvidedSpace());
            stats.setNumOfDecommissioningDatanodes(report.getNumDecommissioningDatanodes());
            stats.setNumOfActiveDatanodes(report.getNumLiveDatanodes());
            stats.setNumOfDeadDatanodes(report.getNumDeadDatanodes());
            stats.setNumOfStaleDatanodes(report.getNumStaleDatanodes());
            stats.setNumOfDecomActiveDatanodes(report.getNumDecomLiveDatanodes());
            stats.setNumOfDecomDeadDatanodes(report.getNumDecomDeadDatanodes());
            stats.setNumOfInMaintenanceLiveDataNodes(report.getNumInMaintenanceLiveDataNodes());
            stats.setNumOfInMaintenanceDeadDataNodes(report.getNumInMaintenanceDeadDataNodes());
            stats.setNumOfEnteringMaintenanceDataNodes(report.getNumEnteringMaintenanceDataNodes());
            record.setStats(stats);
        }
        if (report.getState() != FederationNamenodeServiceState.UNAVAILABLE) {
            record.setLastContact(Time.now());
        }
        NamenodeHeartbeatRequest request = NamenodeHeartbeatRequest.newInstance();
        request.setNamenodeMembership(record);
        return this.getMembershipStore().namenodeHeartbeat(request).getResult();
    }

    @Override
    public Set<FederationNamespaceInfo> getNamespaces() throws IOException {
        GetNamespaceInfoRequest request = GetNamespaceInfoRequest.newInstance();
        GetNamespaceInfoResponse response = this.getMembershipStore().getNamespaceInfo(request);
        Set<FederationNamespaceInfo> nss = response.getNamespaceInfo();
        TreeSet<FederationNamespaceInfo> ret = new TreeSet<FederationNamespaceInfo>();
        Set<String> disabled = this.getDisabledNamespaces();
        for (FederationNamespaceInfo ns : nss) {
            if (disabled.contains(ns.getNameserviceId())) continue;
            ret.add(ns);
        }
        return ret;
    }

    @Override
    public Set<String> getDisabledNamespaces() throws IOException {
        DisabledNameserviceStore store = this.getDisabledNameserviceStore();
        return store.getDisabledNameservices();
    }

    private List<MembershipState> getRecentRegistrationForQuery(GetNamenodeRegistrationsRequest request, boolean addUnavailable, boolean addExpired) throws IOException {
        MembershipStore membershipStore = this.getMembershipStore();
        GetNamenodeRegistrationsResponse response = membershipStore.getNamenodeRegistrations(request);
        List<MembershipState> memberships = response.getNamenodeMemberships();
        if (!addExpired || !addUnavailable) {
            Iterator<MembershipState> iterator = memberships.iterator();
            while (iterator.hasNext()) {
                MembershipState membership = iterator.next();
                if (membership.getState() == FederationNamenodeServiceState.EXPIRED && !addExpired) {
                    iterator.remove();
                    continue;
                }
                if (membership.getState() != FederationNamenodeServiceState.UNAVAILABLE || addUnavailable) continue;
                iterator.remove();
            }
        }
        ArrayList<MembershipState> priorityList = new ArrayList<MembershipState>();
        priorityList.addAll(memberships);
        Collections.sort(priorityList, new NamenodePriorityComparator());
        LOG.debug("Selected most recent NN {} for query", priorityList);
        return priorityList;
    }

    @Override
    public void setRouterId(String router) {
        this.routerId = router;
    }
}

