/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.resolver.order;

import com.google.common.annotations.VisibleForTesting;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.hdfs.server.federation.resolver.PathLocation;
import org.apache.hadoop.hdfs.server.federation.resolver.order.OrderedResolver;
import org.apache.hadoop.hdfs.server.federation.utils.ConsistentHashRing;
import org.apache.hadoop.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HashResolver
implements OrderedResolver {
    protected static final Logger LOG = LoggerFactory.getLogger(HashResolver.class);
    private final Map<Integer, ConsistentHashRing> hashResolverMap = new ConcurrentHashMap<Integer, ConsistentHashRing>();
    private static final String HEX_PATTERN = "\\p{XDigit}";
    private static final String UUID_PATTERN = "\\p{XDigit}{8}-\\p{XDigit}{4}-\\p{XDigit}{4}-\\p{XDigit}{4}-\\p{XDigit}{12}";
    private static final String ATTEMPT_PATTERN = "attempt_\\d+_\\d{4}_._\\d{6}_\\d{2}";
    private static final String[] TEMP_FILE_PATTERNS = new String[]{"(.+)\\.COPYING$", "(.+)\\._COPYING_.*$", "(.+)\\.tmp$", "_temp/(.+)$", "_temporary/(.+)\\.\\p{XDigit}{8}-\\p{XDigit}{4}-\\p{XDigit}{4}-\\p{XDigit}{4}-\\p{XDigit}{12}$", "(.*)_temporary/\\d/_temporary/attempt_\\d+_\\d{4}_._\\d{6}_\\d{2}/(.+)$"};
    private static final Pattern TEMP_FILE_PATTERN = Pattern.compile(StringUtils.join((CharSequence)"|", (String[])TEMP_FILE_PATTERNS));

    @Override
    public String getFirstNamespace(String path, PathLocation loc) {
        String finalPath = HashResolver.extractTempFileName(path);
        Set<String> namespaces = loc.getNamespaces();
        ConsistentHashRing locator = this.getHashResolver(namespaces);
        String hashedSubcluster = locator.getLocation(finalPath);
        if (hashedSubcluster == null) {
            String srcPath = loc.getSourcePath();
            LOG.error("Cannot find subcluster for {} ({} -> {})", new Object[]{srcPath, path, finalPath});
        }
        LOG.debug("Namespace for {} ({}) is {}", new Object[]{path, finalPath, hashedSubcluster});
        return hashedSubcluster;
    }

    private ConsistentHashRing getHashResolver(Set<String> namespaces) {
        int hash = namespaces.hashCode();
        return this.hashResolverMap.computeIfAbsent(hash, k -> new ConsistentHashRing(namespaces));
    }

    @VisibleForTesting
    public static String extractTempFileName(String input) {
        StringBuilder sb = new StringBuilder();
        Matcher matcher = TEMP_FILE_PATTERN.matcher(input);
        if (matcher.find()) {
            for (int i = 1; i <= matcher.groupCount(); ++i) {
                String match = matcher.group(i);
                if (match == null) continue;
                sb.append(match);
            }
        }
        if (sb.length() > 0) {
            String ret = sb.toString();
            LOG.debug("Extracted {} from {}", (Object)ret, (Object)input);
            return ret;
        }
        return input;
    }
}

