/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.resolver.order;

import com.google.common.collect.Iterables;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.commons.collections.CollectionUtils;
import org.apache.hadoop.hdfs.server.federation.resolver.PathLocation;
import org.apache.hadoop.hdfs.server.federation.resolver.order.OrderedResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RandomResolver
implements OrderedResolver {
    private static final Logger LOG = LoggerFactory.getLogger(RandomResolver.class);

    @Override
    public String getFirstNamespace(String path, PathLocation loc) {
        Set<String> namespaces;
        Set<String> set = namespaces = loc == null ? null : loc.getNamespaces();
        if (CollectionUtils.isEmpty(namespaces)) {
            LOG.error("Cannot get namespaces for {}", (Object)loc);
            return null;
        }
        int index = ThreadLocalRandom.current().nextInt(namespaces.size());
        return (String)Iterables.get(namespaces, (int)index);
    }
}

